package drr.regulation.csa.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilder;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilderImpl;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportImpl;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.common.trade.basket.BasketConstituentsReport.BasketConstituentsReportBuilder;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilder;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields.DTCCAdditionalFieldsBuilder;
import drr.regulation.csa.rewrite.trade.CSANonReportable;
import drr.regulation.csa.rewrite.trade.CSANonReportable.CSANonReportableBuilder;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.regulation.csa.rewrite.trade.CSATransactionReport.CSATransactionReportBuilder;
import drr.regulation.csa.rewrite.trade.CSATransactionReport.CSATransactionReportBuilderImpl;
import drr.regulation.csa.rewrite.trade.CSATransactionReport.CSATransactionReportImpl;
import drr.regulation.csa.rewrite.trade.meta.CSATransactionReportMeta;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.payment.OtherPayment.OtherPaymentBuilder;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceFormat.PriceFormatBuilder;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.price.PricePeriod.PricePeriodBuilder;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="CSATransactionReport", builder=CSATransactionReport.CSATransactionReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="CSATransactionReport", model="drr", builder=CSATransactionReport.CSATransactionReportBuilderImpl.class, version="6.0.0-dev.128")
public interface CSATransactionReport extends CommonTransactionReport {

	CSATransactionReportMeta metaData = new CSATransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	String getCounterparty2IdentifierSource();
	String getBuyerIdentifier();
	String getSellerIdentifier();
	String getPayerIdentifierLeg1();
	String getPayerIdentifierLeg2();
	String getReceiverIdentifierLeg1();
	String getReceiverIdentifierLeg2();
	String getBrokerIdentifier();
	String getCountryAndProvinceOrTerritoryOfIndividual();
	List<String> getJurisdictionOfCounterparty1();
	List<String> getJurisdictionOfCounterparty2();
	String getSubsequentPositionUTI();
	String getPriorUSI();
	Boolean getInterAffiliateIndicator();
	Boolean getPlatformAnonymousExecutionIndicator();
	String getMasterAgreementType();
	Integer getMasterAgreementVersion();
	Boolean getNonStandardizedTermIndicator();
	ClearingAccountOriginEnum getClearingAccountOrigin();
	String getClearingMemberIdentifier();
	ZonedDateTime getClearingReceiptTimestamp();
	List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty1();
	List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty2();
	String getVariationMarginCollateralPortfolioCode();
	String getInitialMarginCollateralPortfolioCode();
	ReportLevelEnum getLevel();
	Boolean getAmendmentIndicator();
	Boolean getPackageIndicator();
	Boolean getCryptoAssetUnderlyingIndicatorLeg1();
	Boolean getCryptoAssetUnderlyingIndicatorLeg2();
	String getCustomBasketCode();
	Boolean getCustomBasketIndicator();
	String getUnderlierIDOtherLeg1();
	String getUnderlierIDOtherLeg2();
	String getUnderlierIDOtherSourceLeg1();
	String getUnderlierIDOtherSourceLeg2();
	String getUnderlyingAssetTradingPlatformIdentifierLeg1();
	String getUnderlyingAssetTradingPlatformIdentifierLeg2();
	String getUnderlyingAssetPriceSourceLeg1();
	String getUnderlyingAssetPriceSourceLeg2();
	String getSettlementLocation();
	String getExchangeRateBasisLeg1();
	CSANonReportable getNonReportable();
	DTCCAdditionalFields getDtccAdditionalFields();

	/*********************** Build Methods  ***********************/
	CSATransactionReport build();
	
	CSATransactionReport.CSATransactionReportBuilder toBuilder();
	
	static CSATransactionReport.CSATransactionReportBuilder builder() {
		return new CSATransactionReport.CSATransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CSATransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CSATransactionReport> getType() {
		return CSATransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, getStrikePriceSchedule());
		processRosetta(path.newSubPath("price"), processor, PriceFormat.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, getOtherPayment());
		processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, getLeg1());
		processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, getLeg2());
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
		processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
		processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, getBarrier());
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.class, getUnderlying());
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, getCounterparty2IdentifierSource(), this);
		processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, getBuyerIdentifier(), this);
		processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, getSellerIdentifier(), this);
		processor.processBasic(path.newSubPath("payerIdentifierLeg1"), String.class, getPayerIdentifierLeg1(), this);
		processor.processBasic(path.newSubPath("payerIdentifierLeg2"), String.class, getPayerIdentifierLeg2(), this);
		processor.processBasic(path.newSubPath("receiverIdentifierLeg1"), String.class, getReceiverIdentifierLeg1(), this);
		processor.processBasic(path.newSubPath("receiverIdentifierLeg2"), String.class, getReceiverIdentifierLeg2(), this);
		processor.processBasic(path.newSubPath("brokerIdentifier"), String.class, getBrokerIdentifier(), this);
		processor.processBasic(path.newSubPath("countryAndProvinceOrTerritoryOfIndividual"), String.class, getCountryAndProvinceOrTerritoryOfIndividual(), this);
		processor.processBasic(path.newSubPath("jurisdictionOfCounterparty1"), String.class, getJurisdictionOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("jurisdictionOfCounterparty2"), String.class, getJurisdictionOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
		processor.processBasic(path.newSubPath("priorUSI"), String.class, getPriorUSI(), this);
		processor.processBasic(path.newSubPath("interAffiliateIndicator"), Boolean.class, getInterAffiliateIndicator(), this);
		processor.processBasic(path.newSubPath("platformAnonymousExecutionIndicator"), Boolean.class, getPlatformAnonymousExecutionIndicator(), this);
		processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
		processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
		processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, getClearingAccountOrigin(), this);
		processor.processBasic(path.newSubPath("clearingMemberIdentifier"), String.class, getClearingMemberIdentifier(), this);
		processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
		processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty1(), this);
		processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty2(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
		processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
		processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
		processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicatorLeg1"), Boolean.class, getCryptoAssetUnderlyingIndicatorLeg1(), this);
		processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicatorLeg2"), Boolean.class, getCryptoAssetUnderlyingIndicatorLeg2(), this);
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
		processor.processBasic(path.newSubPath("underlierIDOtherLeg1"), String.class, getUnderlierIDOtherLeg1(), this);
		processor.processBasic(path.newSubPath("underlierIDOtherLeg2"), String.class, getUnderlierIDOtherLeg2(), this);
		processor.processBasic(path.newSubPath("underlierIDOtherSourceLeg1"), String.class, getUnderlierIDOtherSourceLeg1(), this);
		processor.processBasic(path.newSubPath("underlierIDOtherSourceLeg2"), String.class, getUnderlierIDOtherSourceLeg2(), this);
		processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifierLeg1"), String.class, getUnderlyingAssetTradingPlatformIdentifierLeg1(), this);
		processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifierLeg2"), String.class, getUnderlyingAssetTradingPlatformIdentifierLeg2(), this);
		processor.processBasic(path.newSubPath("underlyingAssetPriceSourceLeg1"), String.class, getUnderlyingAssetPriceSourceLeg1(), this);
		processor.processBasic(path.newSubPath("underlyingAssetPriceSourceLeg2"), String.class, getUnderlyingAssetPriceSourceLeg2(), this);
		processor.processBasic(path.newSubPath("settlementLocation"), String.class, getSettlementLocation(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasisLeg1"), String.class, getExchangeRateBasisLeg1(), this);
		processRosetta(path.newSubPath("nonReportable"), processor, CSANonReportable.class, getNonReportable());
		processRosetta(path.newSubPath("dtccAdditionalFields"), processor, DTCCAdditionalFields.class, getDtccAdditionalFields());
	}
	

	/*********************** Builder Interface  ***********************/
	interface CSATransactionReportBuilder extends CSATransactionReport, CommonTransactionReport.CommonTransactionReportBuilder {
		CSANonReportable.CSANonReportableBuilder getOrCreateNonReportable();
		@Override
		CSANonReportable.CSANonReportableBuilder getNonReportable();
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getOrCreateDtccAdditionalFields();
		@Override
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getDtccAdditionalFields();
		@Override
		CSATransactionReport.CSATransactionReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setEventType(EventTypeEnum eventType);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setEventIdentifier(String eventIdentifier);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setEffectiveDate(Date effectiveDate);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setExpirationDate(Date expirationDate);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCounterparty1(String counterparty1);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCounterparty2(String counterparty2);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setBeneficiary1(String beneficiary1);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCleared(ClearedEnum cleared);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setClearingMember(String clearingMember);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setConfirmed(ConfirmationEnum confirmed);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCallAmount(BigDecimal callAmount);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPutAmount(BigDecimal putAmount);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule, int _idx);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule, int _idx);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPrice(PriceFormat price);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPriceNotation(PriceNotationEnum priceNotation);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPackageTransactionPrice(PriceFormat packageTransactionPrice);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPackageTransactionSpread(PriceFormat packageTransactionSpread);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setStrikePrice(PriceFormat strikePrice);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addOtherPayment(OtherPayment otherPayment);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addOtherPayment(OtherPayment otherPayment, int _idx);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setLeg1(Leg leg1);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setLeg2(Leg leg2);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setLeg1(CommonLeg leg1);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setLeg2(CommonLeg leg2);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setExecutionAgentCounterparty1(String executionAgentCounterparty1);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setExecutionAgentCounterparty2DTCC(String executionAgentCounterparty2DTCC);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPriorUTI(String priorUTI);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setContractType(CommonContractType contractType);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setAssetClass(CommonAssetClass assetClass);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setDirection1(Direction1Enum direction1);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setDirection2Leg1(Direction2Enum direction2Leg1);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setDirection2Leg2(Direction2Enum direction2Leg2);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier barrier);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int _idx);
		@Override
		CSATransactionReport.CSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setUnderlying(UnderlyingIdentifier underlying);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setOptionType(OptionTypeCode optionType);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setOptionStyle(OptionStyleEnum optionStyle);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setDeliveryType(DeliveryTypeEnum deliveryType);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum countryOfTheCounterparty2);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum bookingLocation);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum traderLocation);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setTradingCapacity(TradingCapacity7Code tradingCapacity);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum embeddedOptionType);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setSeniority(SeniorityEnum seniority);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setSeries(Integer series);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		@Override
		CSATransactionReport.CSATransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		CSATransactionReport.CSATransactionReportBuilder setCounterparty2IdentifierSource(String counterparty2IdentifierSource);
		CSATransactionReport.CSATransactionReportBuilder setBuyerIdentifier(String buyerIdentifier);
		CSATransactionReport.CSATransactionReportBuilder setSellerIdentifier(String sellerIdentifier);
		CSATransactionReport.CSATransactionReportBuilder setPayerIdentifierLeg1(String payerIdentifierLeg1);
		CSATransactionReport.CSATransactionReportBuilder setPayerIdentifierLeg2(String payerIdentifierLeg2);
		CSATransactionReport.CSATransactionReportBuilder setReceiverIdentifierLeg1(String receiverIdentifierLeg1);
		CSATransactionReport.CSATransactionReportBuilder setReceiverIdentifierLeg2(String receiverIdentifierLeg2);
		CSATransactionReport.CSATransactionReportBuilder setBrokerIdentifier(String brokerIdentifier);
		CSATransactionReport.CSATransactionReportBuilder setCountryAndProvinceOrTerritoryOfIndividual(String countryAndProvinceOrTerritoryOfIndividual);
		CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty1(String jurisdictionOfCounterparty1);
		CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty1(String jurisdictionOfCounterparty1, int _idx);
		CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty1(List<String> jurisdictionOfCounterparty1);
		CSATransactionReport.CSATransactionReportBuilder setJurisdictionOfCounterparty1(List<String> jurisdictionOfCounterparty1);
		CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty2(String jurisdictionOfCounterparty2);
		CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty2(String jurisdictionOfCounterparty2, int _idx);
		CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty2(List<String> jurisdictionOfCounterparty2);
		CSATransactionReport.CSATransactionReportBuilder setJurisdictionOfCounterparty2(List<String> jurisdictionOfCounterparty2);
		CSATransactionReport.CSATransactionReportBuilder setSubsequentPositionUTI(String subsequentPositionUTI);
		CSATransactionReport.CSATransactionReportBuilder setPriorUSI(String priorUSI);
		CSATransactionReport.CSATransactionReportBuilder setInterAffiliateIndicator(Boolean interAffiliateIndicator);
		CSATransactionReport.CSATransactionReportBuilder setPlatformAnonymousExecutionIndicator(Boolean platformAnonymousExecutionIndicator);
		CSATransactionReport.CSATransactionReportBuilder setMasterAgreementType(String masterAgreementType);
		CSATransactionReport.CSATransactionReportBuilder setMasterAgreementVersion(Integer masterAgreementVersion);
		CSATransactionReport.CSATransactionReportBuilder setNonStandardizedTermIndicator(Boolean nonStandardizedTermIndicator);
		CSATransactionReport.CSATransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum clearingAccountOrigin);
		CSATransactionReport.CSATransactionReportBuilder setClearingMemberIdentifier(String clearingMemberIdentifier);
		CSATransactionReport.CSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime clearingReceiptTimestamp);
		CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty1);
		CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty1, int _idx);
		CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1);
		CSATransactionReport.CSATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1);
		CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty2);
		CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty2, int _idx);
		CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2);
		CSATransactionReport.CSATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2);
		CSATransactionReport.CSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		CSATransactionReport.CSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		CSATransactionReport.CSATransactionReportBuilder setLevel(ReportLevelEnum level);
		CSATransactionReport.CSATransactionReportBuilder setAmendmentIndicator(Boolean amendmentIndicator);
		CSATransactionReport.CSATransactionReportBuilder setPackageIndicator(Boolean packageIndicator);
		CSATransactionReport.CSATransactionReportBuilder setCryptoAssetUnderlyingIndicatorLeg1(Boolean cryptoAssetUnderlyingIndicatorLeg1);
		CSATransactionReport.CSATransactionReportBuilder setCryptoAssetUnderlyingIndicatorLeg2(Boolean cryptoAssetUnderlyingIndicatorLeg2);
		CSATransactionReport.CSATransactionReportBuilder setCustomBasketCode(String customBasketCode);
		CSATransactionReport.CSATransactionReportBuilder setCustomBasketIndicator(Boolean customBasketIndicator);
		CSATransactionReport.CSATransactionReportBuilder setUnderlierIDOtherLeg1(String underlierIDOtherLeg1);
		CSATransactionReport.CSATransactionReportBuilder setUnderlierIDOtherLeg2(String underlierIDOtherLeg2);
		CSATransactionReport.CSATransactionReportBuilder setUnderlierIDOtherSourceLeg1(String underlierIDOtherSourceLeg1);
		CSATransactionReport.CSATransactionReportBuilder setUnderlierIDOtherSourceLeg2(String underlierIDOtherSourceLeg2);
		CSATransactionReport.CSATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifierLeg1(String underlyingAssetTradingPlatformIdentifierLeg1);
		CSATransactionReport.CSATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifierLeg2(String underlyingAssetTradingPlatformIdentifierLeg2);
		CSATransactionReport.CSATransactionReportBuilder setUnderlyingAssetPriceSourceLeg1(String underlyingAssetPriceSourceLeg1);
		CSATransactionReport.CSATransactionReportBuilder setUnderlyingAssetPriceSourceLeg2(String underlyingAssetPriceSourceLeg2);
		CSATransactionReport.CSATransactionReportBuilder setSettlementLocation(String settlementLocation);
		CSATransactionReport.CSATransactionReportBuilder setExchangeRateBasisLeg1(String exchangeRateBasisLeg1);
		CSATransactionReport.CSATransactionReportBuilder setNonReportable(CSANonReportable nonReportable);
		CSATransactionReport.CSATransactionReportBuilder setDtccAdditionalFields(DTCCAdditionalFields dtccAdditionalFields);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getStrikePriceSchedule());
			processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, getLeg1());
			processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, getLeg2());
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
			processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
			processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.UnderlyingIdentifierBuilder.class, getUnderlying());
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, getCounterparty2IdentifierSource(), this);
			processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, getBuyerIdentifier(), this);
			processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, getSellerIdentifier(), this);
			processor.processBasic(path.newSubPath("payerIdentifierLeg1"), String.class, getPayerIdentifierLeg1(), this);
			processor.processBasic(path.newSubPath("payerIdentifierLeg2"), String.class, getPayerIdentifierLeg2(), this);
			processor.processBasic(path.newSubPath("receiverIdentifierLeg1"), String.class, getReceiverIdentifierLeg1(), this);
			processor.processBasic(path.newSubPath("receiverIdentifierLeg2"), String.class, getReceiverIdentifierLeg2(), this);
			processor.processBasic(path.newSubPath("brokerIdentifier"), String.class, getBrokerIdentifier(), this);
			processor.processBasic(path.newSubPath("countryAndProvinceOrTerritoryOfIndividual"), String.class, getCountryAndProvinceOrTerritoryOfIndividual(), this);
			processor.processBasic(path.newSubPath("jurisdictionOfCounterparty1"), String.class, getJurisdictionOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("jurisdictionOfCounterparty2"), String.class, getJurisdictionOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
			processor.processBasic(path.newSubPath("priorUSI"), String.class, getPriorUSI(), this);
			processor.processBasic(path.newSubPath("interAffiliateIndicator"), Boolean.class, getInterAffiliateIndicator(), this);
			processor.processBasic(path.newSubPath("platformAnonymousExecutionIndicator"), Boolean.class, getPlatformAnonymousExecutionIndicator(), this);
			processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
			processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
			processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, getClearingAccountOrigin(), this);
			processor.processBasic(path.newSubPath("clearingMemberIdentifier"), String.class, getClearingMemberIdentifier(), this);
			processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
			processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty1(), this);
			processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty2(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
			processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
			processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
			processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicatorLeg1"), Boolean.class, getCryptoAssetUnderlyingIndicatorLeg1(), this);
			processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicatorLeg2"), Boolean.class, getCryptoAssetUnderlyingIndicatorLeg2(), this);
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
			processor.processBasic(path.newSubPath("underlierIDOtherLeg1"), String.class, getUnderlierIDOtherLeg1(), this);
			processor.processBasic(path.newSubPath("underlierIDOtherLeg2"), String.class, getUnderlierIDOtherLeg2(), this);
			processor.processBasic(path.newSubPath("underlierIDOtherSourceLeg1"), String.class, getUnderlierIDOtherSourceLeg1(), this);
			processor.processBasic(path.newSubPath("underlierIDOtherSourceLeg2"), String.class, getUnderlierIDOtherSourceLeg2(), this);
			processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifierLeg1"), String.class, getUnderlyingAssetTradingPlatformIdentifierLeg1(), this);
			processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifierLeg2"), String.class, getUnderlyingAssetTradingPlatformIdentifierLeg2(), this);
			processor.processBasic(path.newSubPath("underlyingAssetPriceSourceLeg1"), String.class, getUnderlyingAssetPriceSourceLeg1(), this);
			processor.processBasic(path.newSubPath("underlyingAssetPriceSourceLeg2"), String.class, getUnderlyingAssetPriceSourceLeg2(), this);
			processor.processBasic(path.newSubPath("settlementLocation"), String.class, getSettlementLocation(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasisLeg1"), String.class, getExchangeRateBasisLeg1(), this);
			processRosetta(path.newSubPath("nonReportable"), processor, CSANonReportable.CSANonReportableBuilder.class, getNonReportable());
			processRosetta(path.newSubPath("dtccAdditionalFields"), processor, DTCCAdditionalFields.DTCCAdditionalFieldsBuilder.class, getDtccAdditionalFields());
		}
		

		CSATransactionReport.CSATransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of CSATransactionReport  ***********************/
	class CSATransactionReportImpl extends CommonTransactionReport.CommonTransactionReportImpl implements CSATransactionReport {
		private final String counterparty2IdentifierSource;
		private final String buyerIdentifier;
		private final String sellerIdentifier;
		private final String payerIdentifierLeg1;
		private final String payerIdentifierLeg2;
		private final String receiverIdentifierLeg1;
		private final String receiverIdentifierLeg2;
		private final String brokerIdentifier;
		private final String countryAndProvinceOrTerritoryOfIndividual;
		private final List<String> jurisdictionOfCounterparty1;
		private final List<String> jurisdictionOfCounterparty2;
		private final String subsequentPositionUTI;
		private final String priorUSI;
		private final Boolean interAffiliateIndicator;
		private final Boolean platformAnonymousExecutionIndicator;
		private final String masterAgreementType;
		private final Integer masterAgreementVersion;
		private final Boolean nonStandardizedTermIndicator;
		private final ClearingAccountOriginEnum clearingAccountOrigin;
		private final String clearingMemberIdentifier;
		private final ZonedDateTime clearingReceiptTimestamp;
		private final List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1;
		private final List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2;
		private final String variationMarginCollateralPortfolioCode;
		private final String initialMarginCollateralPortfolioCode;
		private final ReportLevelEnum level;
		private final Boolean amendmentIndicator;
		private final Boolean packageIndicator;
		private final Boolean cryptoAssetUnderlyingIndicatorLeg1;
		private final Boolean cryptoAssetUnderlyingIndicatorLeg2;
		private final String customBasketCode;
		private final Boolean customBasketIndicator;
		private final String underlierIDOtherLeg1;
		private final String underlierIDOtherLeg2;
		private final String underlierIDOtherSourceLeg1;
		private final String underlierIDOtherSourceLeg2;
		private final String underlyingAssetTradingPlatformIdentifierLeg1;
		private final String underlyingAssetTradingPlatformIdentifierLeg2;
		private final String underlyingAssetPriceSourceLeg1;
		private final String underlyingAssetPriceSourceLeg2;
		private final String settlementLocation;
		private final String exchangeRateBasisLeg1;
		private final CSANonReportable nonReportable;
		private final DTCCAdditionalFields dtccAdditionalFields;
		
		protected CSATransactionReportImpl(CSATransactionReport.CSATransactionReportBuilder builder) {
			super(builder);
			this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
			this.buyerIdentifier = builder.getBuyerIdentifier();
			this.sellerIdentifier = builder.getSellerIdentifier();
			this.payerIdentifierLeg1 = builder.getPayerIdentifierLeg1();
			this.payerIdentifierLeg2 = builder.getPayerIdentifierLeg2();
			this.receiverIdentifierLeg1 = builder.getReceiverIdentifierLeg1();
			this.receiverIdentifierLeg2 = builder.getReceiverIdentifierLeg2();
			this.brokerIdentifier = builder.getBrokerIdentifier();
			this.countryAndProvinceOrTerritoryOfIndividual = builder.getCountryAndProvinceOrTerritoryOfIndividual();
			this.jurisdictionOfCounterparty1 = ofNullable(builder.getJurisdictionOfCounterparty1()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.jurisdictionOfCounterparty2 = ofNullable(builder.getJurisdictionOfCounterparty2()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.subsequentPositionUTI = builder.getSubsequentPositionUTI();
			this.priorUSI = builder.getPriorUSI();
			this.interAffiliateIndicator = builder.getInterAffiliateIndicator();
			this.platformAnonymousExecutionIndicator = builder.getPlatformAnonymousExecutionIndicator();
			this.masterAgreementType = builder.getMasterAgreementType();
			this.masterAgreementVersion = builder.getMasterAgreementVersion();
			this.nonStandardizedTermIndicator = builder.getNonStandardizedTermIndicator();
			this.clearingAccountOrigin = builder.getClearingAccountOrigin();
			this.clearingMemberIdentifier = builder.getClearingMemberIdentifier();
			this.clearingReceiptTimestamp = builder.getClearingReceiptTimestamp();
			this.clearingExceptionsAndExemptionsCounterparty1 = ofNullable(builder.getClearingExceptionsAndExemptionsCounterparty1()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.clearingExceptionsAndExemptionsCounterparty2 = ofNullable(builder.getClearingExceptionsAndExemptionsCounterparty2()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.level = builder.getLevel();
			this.amendmentIndicator = builder.getAmendmentIndicator();
			this.packageIndicator = builder.getPackageIndicator();
			this.cryptoAssetUnderlyingIndicatorLeg1 = builder.getCryptoAssetUnderlyingIndicatorLeg1();
			this.cryptoAssetUnderlyingIndicatorLeg2 = builder.getCryptoAssetUnderlyingIndicatorLeg2();
			this.customBasketCode = builder.getCustomBasketCode();
			this.customBasketIndicator = builder.getCustomBasketIndicator();
			this.underlierIDOtherLeg1 = builder.getUnderlierIDOtherLeg1();
			this.underlierIDOtherLeg2 = builder.getUnderlierIDOtherLeg2();
			this.underlierIDOtherSourceLeg1 = builder.getUnderlierIDOtherSourceLeg1();
			this.underlierIDOtherSourceLeg2 = builder.getUnderlierIDOtherSourceLeg2();
			this.underlyingAssetTradingPlatformIdentifierLeg1 = builder.getUnderlyingAssetTradingPlatformIdentifierLeg1();
			this.underlyingAssetTradingPlatformIdentifierLeg2 = builder.getUnderlyingAssetTradingPlatformIdentifierLeg2();
			this.underlyingAssetPriceSourceLeg1 = builder.getUnderlyingAssetPriceSourceLeg1();
			this.underlyingAssetPriceSourceLeg2 = builder.getUnderlyingAssetPriceSourceLeg2();
			this.settlementLocation = builder.getSettlementLocation();
			this.exchangeRateBasisLeg1 = builder.getExchangeRateBasisLeg1();
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
			this.dtccAdditionalFields = ofNullable(builder.getDtccAdditionalFields()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierSource")
		@RuneAttribute("counterparty2IdentifierSource")
		public String getCounterparty2IdentifierSource() {
			return counterparty2IdentifierSource;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		public String getBuyerIdentifier() {
			return buyerIdentifier;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		public String getSellerIdentifier() {
			return sellerIdentifier;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		public String getPayerIdentifierLeg1() {
			return payerIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		public String getPayerIdentifierLeg2() {
			return payerIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		public String getReceiverIdentifierLeg1() {
			return receiverIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		public String getReceiverIdentifierLeg2() {
			return receiverIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("brokerIdentifier")
		@RuneAttribute("brokerIdentifier")
		public String getBrokerIdentifier() {
			return brokerIdentifier;
		}
		
		@Override
		@RosettaAttribute("countryAndProvinceOrTerritoryOfIndividual")
		@RuneAttribute("countryAndProvinceOrTerritoryOfIndividual")
		public String getCountryAndProvinceOrTerritoryOfIndividual() {
			return countryAndProvinceOrTerritoryOfIndividual;
		}
		
		@Override
		@RosettaAttribute("jurisdictionOfCounterparty1")
		@RuneAttribute("jurisdictionOfCounterparty1")
		public List<String> getJurisdictionOfCounterparty1() {
			return jurisdictionOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("jurisdictionOfCounterparty2")
		@RuneAttribute("jurisdictionOfCounterparty2")
		public List<String> getJurisdictionOfCounterparty2() {
			return jurisdictionOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public String getSubsequentPositionUTI() {
			return subsequentPositionUTI;
		}
		
		@Override
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		public String getPriorUSI() {
			return priorUSI;
		}
		
		@Override
		@RosettaAttribute("interAffiliateIndicator")
		@RuneAttribute("interAffiliateIndicator")
		public Boolean getInterAffiliateIndicator() {
			return interAffiliateIndicator;
		}
		
		@Override
		@RosettaAttribute("platformAnonymousExecutionIndicator")
		@RuneAttribute("platformAnonymousExecutionIndicator")
		public Boolean getPlatformAnonymousExecutionIndicator() {
			return platformAnonymousExecutionIndicator;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public Integer getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public Boolean getNonStandardizedTermIndicator() {
			return nonStandardizedTermIndicator;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public ClearingAccountOriginEnum getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("clearingMemberIdentifier")
		@RuneAttribute("clearingMemberIdentifier")
		public String getClearingMemberIdentifier() {
			return clearingMemberIdentifier;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty1() {
			return clearingExceptionsAndExemptionsCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty2() {
			return clearingExceptionsAndExemptionsCounterparty2;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public ReportLevelEnum getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public Boolean getAmendmentIndicator() {
			return amendmentIndicator;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public Boolean getPackageIndicator() {
			return packageIndicator;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicatorLeg1")
		@RuneAttribute("cryptoAssetUnderlyingIndicatorLeg1")
		public Boolean getCryptoAssetUnderlyingIndicatorLeg1() {
			return cryptoAssetUnderlyingIndicatorLeg1;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicatorLeg2")
		@RuneAttribute("cryptoAssetUnderlyingIndicatorLeg2")
		public Boolean getCryptoAssetUnderlyingIndicatorLeg2() {
			return cryptoAssetUnderlyingIndicatorLeg2;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public Boolean getCustomBasketIndicator() {
			return customBasketIndicator;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherLeg1")
		@RuneAttribute("underlierIDOtherLeg1")
		public String getUnderlierIDOtherLeg1() {
			return underlierIDOtherLeg1;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherLeg2")
		@RuneAttribute("underlierIDOtherLeg2")
		public String getUnderlierIDOtherLeg2() {
			return underlierIDOtherLeg2;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherSourceLeg1")
		@RuneAttribute("underlierIDOtherSourceLeg1")
		public String getUnderlierIDOtherSourceLeg1() {
			return underlierIDOtherSourceLeg1;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherSourceLeg2")
		@RuneAttribute("underlierIDOtherSourceLeg2")
		public String getUnderlierIDOtherSourceLeg2() {
			return underlierIDOtherSourceLeg2;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifierLeg1")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifierLeg1")
		public String getUnderlyingAssetTradingPlatformIdentifierLeg1() {
			return underlyingAssetTradingPlatformIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifierLeg2")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifierLeg2")
		public String getUnderlyingAssetTradingPlatformIdentifierLeg2() {
			return underlyingAssetTradingPlatformIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSourceLeg1")
		@RuneAttribute("underlyingAssetPriceSourceLeg1")
		public String getUnderlyingAssetPriceSourceLeg1() {
			return underlyingAssetPriceSourceLeg1;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSourceLeg2")
		@RuneAttribute("underlyingAssetPriceSourceLeg2")
		public String getUnderlyingAssetPriceSourceLeg2() {
			return underlyingAssetPriceSourceLeg2;
		}
		
		@Override
		@RosettaAttribute("settlementLocation")
		@RuneAttribute("settlementLocation")
		public String getSettlementLocation() {
			return settlementLocation;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisLeg1")
		@RuneAttribute("exchangeRateBasisLeg1")
		public String getExchangeRateBasisLeg1() {
			return exchangeRateBasisLeg1;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public CSANonReportable getNonReportable() {
			return nonReportable;
		}
		
		@Override
		@RosettaAttribute("dtccAdditionalFields")
		@RuneAttribute("dtccAdditionalFields")
		public DTCCAdditionalFields getDtccAdditionalFields() {
			return dtccAdditionalFields;
		}
		
		@Override
		public CSATransactionReport build() {
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder toBuilder() {
			CSATransactionReport.CSATransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CSATransactionReport.CSATransactionReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSource);
			ofNullable(getBuyerIdentifier()).ifPresent(builder::setBuyerIdentifier);
			ofNullable(getSellerIdentifier()).ifPresent(builder::setSellerIdentifier);
			ofNullable(getPayerIdentifierLeg1()).ifPresent(builder::setPayerIdentifierLeg1);
			ofNullable(getPayerIdentifierLeg2()).ifPresent(builder::setPayerIdentifierLeg2);
			ofNullable(getReceiverIdentifierLeg1()).ifPresent(builder::setReceiverIdentifierLeg1);
			ofNullable(getReceiverIdentifierLeg2()).ifPresent(builder::setReceiverIdentifierLeg2);
			ofNullable(getBrokerIdentifier()).ifPresent(builder::setBrokerIdentifier);
			ofNullable(getCountryAndProvinceOrTerritoryOfIndividual()).ifPresent(builder::setCountryAndProvinceOrTerritoryOfIndividual);
			ofNullable(getJurisdictionOfCounterparty1()).ifPresent(builder::setJurisdictionOfCounterparty1);
			ofNullable(getJurisdictionOfCounterparty2()).ifPresent(builder::setJurisdictionOfCounterparty2);
			ofNullable(getSubsequentPositionUTI()).ifPresent(builder::setSubsequentPositionUTI);
			ofNullable(getPriorUSI()).ifPresent(builder::setPriorUSI);
			ofNullable(getInterAffiliateIndicator()).ifPresent(builder::setInterAffiliateIndicator);
			ofNullable(getPlatformAnonymousExecutionIndicator()).ifPresent(builder::setPlatformAnonymousExecutionIndicator);
			ofNullable(getMasterAgreementType()).ifPresent(builder::setMasterAgreementType);
			ofNullable(getMasterAgreementVersion()).ifPresent(builder::setMasterAgreementVersion);
			ofNullable(getNonStandardizedTermIndicator()).ifPresent(builder::setNonStandardizedTermIndicator);
			ofNullable(getClearingAccountOrigin()).ifPresent(builder::setClearingAccountOrigin);
			ofNullable(getClearingMemberIdentifier()).ifPresent(builder::setClearingMemberIdentifier);
			ofNullable(getClearingReceiptTimestamp()).ifPresent(builder::setClearingReceiptTimestamp);
			ofNullable(getClearingExceptionsAndExemptionsCounterparty1()).ifPresent(builder::setClearingExceptionsAndExemptionsCounterparty1);
			ofNullable(getClearingExceptionsAndExemptionsCounterparty2()).ifPresent(builder::setClearingExceptionsAndExemptionsCounterparty2);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getLevel()).ifPresent(builder::setLevel);
			ofNullable(getAmendmentIndicator()).ifPresent(builder::setAmendmentIndicator);
			ofNullable(getPackageIndicator()).ifPresent(builder::setPackageIndicator);
			ofNullable(getCryptoAssetUnderlyingIndicatorLeg1()).ifPresent(builder::setCryptoAssetUnderlyingIndicatorLeg1);
			ofNullable(getCryptoAssetUnderlyingIndicatorLeg2()).ifPresent(builder::setCryptoAssetUnderlyingIndicatorLeg2);
			ofNullable(getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
			ofNullable(getCustomBasketIndicator()).ifPresent(builder::setCustomBasketIndicator);
			ofNullable(getUnderlierIDOtherLeg1()).ifPresent(builder::setUnderlierIDOtherLeg1);
			ofNullable(getUnderlierIDOtherLeg2()).ifPresent(builder::setUnderlierIDOtherLeg2);
			ofNullable(getUnderlierIDOtherSourceLeg1()).ifPresent(builder::setUnderlierIDOtherSourceLeg1);
			ofNullable(getUnderlierIDOtherSourceLeg2()).ifPresent(builder::setUnderlierIDOtherSourceLeg2);
			ofNullable(getUnderlyingAssetTradingPlatformIdentifierLeg1()).ifPresent(builder::setUnderlyingAssetTradingPlatformIdentifierLeg1);
			ofNullable(getUnderlyingAssetTradingPlatformIdentifierLeg2()).ifPresent(builder::setUnderlyingAssetTradingPlatformIdentifierLeg2);
			ofNullable(getUnderlyingAssetPriceSourceLeg1()).ifPresent(builder::setUnderlyingAssetPriceSourceLeg1);
			ofNullable(getUnderlyingAssetPriceSourceLeg2()).ifPresent(builder::setUnderlyingAssetPriceSourceLeg2);
			ofNullable(getSettlementLocation()).ifPresent(builder::setSettlementLocation);
			ofNullable(getExchangeRateBasisLeg1()).ifPresent(builder::setExchangeRateBasisLeg1);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
			ofNullable(getDtccAdditionalFields()).ifPresent(builder::setDtccAdditionalFields);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CSATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) return false;
			if (!Objects.equals(buyerIdentifier, _that.getBuyerIdentifier())) return false;
			if (!Objects.equals(sellerIdentifier, _that.getSellerIdentifier())) return false;
			if (!Objects.equals(payerIdentifierLeg1, _that.getPayerIdentifierLeg1())) return false;
			if (!Objects.equals(payerIdentifierLeg2, _that.getPayerIdentifierLeg2())) return false;
			if (!Objects.equals(receiverIdentifierLeg1, _that.getReceiverIdentifierLeg1())) return false;
			if (!Objects.equals(receiverIdentifierLeg2, _that.getReceiverIdentifierLeg2())) return false;
			if (!Objects.equals(brokerIdentifier, _that.getBrokerIdentifier())) return false;
			if (!Objects.equals(countryAndProvinceOrTerritoryOfIndividual, _that.getCountryAndProvinceOrTerritoryOfIndividual())) return false;
			if (!ListEquals.listEquals(jurisdictionOfCounterparty1, _that.getJurisdictionOfCounterparty1())) return false;
			if (!ListEquals.listEquals(jurisdictionOfCounterparty2, _that.getJurisdictionOfCounterparty2())) return false;
			if (!Objects.equals(subsequentPositionUTI, _that.getSubsequentPositionUTI())) return false;
			if (!Objects.equals(priorUSI, _that.getPriorUSI())) return false;
			if (!Objects.equals(interAffiliateIndicator, _that.getInterAffiliateIndicator())) return false;
			if (!Objects.equals(platformAnonymousExecutionIndicator, _that.getPlatformAnonymousExecutionIndicator())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!Objects.equals(clearingMemberIdentifier, _that.getClearingMemberIdentifier())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty1, _that.getClearingExceptionsAndExemptionsCounterparty1())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty2, _that.getClearingExceptionsAndExemptionsCounterparty2())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			if (!Objects.equals(amendmentIndicator, _that.getAmendmentIndicator())) return false;
			if (!Objects.equals(packageIndicator, _that.getPackageIndicator())) return false;
			if (!Objects.equals(cryptoAssetUnderlyingIndicatorLeg1, _that.getCryptoAssetUnderlyingIndicatorLeg1())) return false;
			if (!Objects.equals(cryptoAssetUnderlyingIndicatorLeg2, _that.getCryptoAssetUnderlyingIndicatorLeg2())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(customBasketIndicator, _that.getCustomBasketIndicator())) return false;
			if (!Objects.equals(underlierIDOtherLeg1, _that.getUnderlierIDOtherLeg1())) return false;
			if (!Objects.equals(underlierIDOtherLeg2, _that.getUnderlierIDOtherLeg2())) return false;
			if (!Objects.equals(underlierIDOtherSourceLeg1, _that.getUnderlierIDOtherSourceLeg1())) return false;
			if (!Objects.equals(underlierIDOtherSourceLeg2, _that.getUnderlierIDOtherSourceLeg2())) return false;
			if (!Objects.equals(underlyingAssetTradingPlatformIdentifierLeg1, _that.getUnderlyingAssetTradingPlatformIdentifierLeg1())) return false;
			if (!Objects.equals(underlyingAssetTradingPlatformIdentifierLeg2, _that.getUnderlyingAssetTradingPlatformIdentifierLeg2())) return false;
			if (!Objects.equals(underlyingAssetPriceSourceLeg1, _that.getUnderlyingAssetPriceSourceLeg1())) return false;
			if (!Objects.equals(underlyingAssetPriceSourceLeg2, _that.getUnderlyingAssetPriceSourceLeg2())) return false;
			if (!Objects.equals(settlementLocation, _that.getSettlementLocation())) return false;
			if (!Objects.equals(exchangeRateBasisLeg1, _that.getExchangeRateBasisLeg1())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			if (!Objects.equals(dtccAdditionalFields, _that.getDtccAdditionalFields())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (counterparty2IdentifierSource != null ? counterparty2IdentifierSource.hashCode() : 0);
			_result = 31 * _result + (buyerIdentifier != null ? buyerIdentifier.hashCode() : 0);
			_result = 31 * _result + (sellerIdentifier != null ? sellerIdentifier.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg1 != null ? payerIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg2 != null ? payerIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg1 != null ? receiverIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg2 != null ? receiverIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (brokerIdentifier != null ? brokerIdentifier.hashCode() : 0);
			_result = 31 * _result + (countryAndProvinceOrTerritoryOfIndividual != null ? countryAndProvinceOrTerritoryOfIndividual.hashCode() : 0);
			_result = 31 * _result + (jurisdictionOfCounterparty1 != null ? jurisdictionOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (jurisdictionOfCounterparty2 != null ? jurisdictionOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (subsequentPositionUTI != null ? subsequentPositionUTI.hashCode() : 0);
			_result = 31 * _result + (priorUSI != null ? priorUSI.hashCode() : 0);
			_result = 31 * _result + (interAffiliateIndicator != null ? interAffiliateIndicator.hashCode() : 0);
			_result = 31 * _result + (platformAnonymousExecutionIndicator != null ? platformAnonymousExecutionIndicator.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (nonStandardizedTermIndicator != null ? nonStandardizedTermIndicator.hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (clearingMemberIdentifier != null ? clearingMemberIdentifier.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty1 != null ? clearingExceptionsAndExemptionsCounterparty1.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty2 != null ? clearingExceptionsAndExemptionsCounterparty2.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (amendmentIndicator != null ? amendmentIndicator.hashCode() : 0);
			_result = 31 * _result + (packageIndicator != null ? packageIndicator.hashCode() : 0);
			_result = 31 * _result + (cryptoAssetUnderlyingIndicatorLeg1 != null ? cryptoAssetUnderlyingIndicatorLeg1.hashCode() : 0);
			_result = 31 * _result + (cryptoAssetUnderlyingIndicatorLeg2 != null ? cryptoAssetUnderlyingIndicatorLeg2.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (customBasketIndicator != null ? customBasketIndicator.hashCode() : 0);
			_result = 31 * _result + (underlierIDOtherLeg1 != null ? underlierIDOtherLeg1.hashCode() : 0);
			_result = 31 * _result + (underlierIDOtherLeg2 != null ? underlierIDOtherLeg2.hashCode() : 0);
			_result = 31 * _result + (underlierIDOtherSourceLeg1 != null ? underlierIDOtherSourceLeg1.hashCode() : 0);
			_result = 31 * _result + (underlierIDOtherSourceLeg2 != null ? underlierIDOtherSourceLeg2.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetTradingPlatformIdentifierLeg1 != null ? underlyingAssetTradingPlatformIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetTradingPlatformIdentifierLeg2 != null ? underlyingAssetTradingPlatformIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetPriceSourceLeg1 != null ? underlyingAssetPriceSourceLeg1.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetPriceSourceLeg2 != null ? underlyingAssetPriceSourceLeg2.hashCode() : 0);
			_result = 31 * _result + (settlementLocation != null ? settlementLocation.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasisLeg1 != null ? exchangeRateBasisLeg1.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			_result = 31 * _result + (dtccAdditionalFields != null ? dtccAdditionalFields.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CSATransactionReport {" +
				"counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", " +
				"buyerIdentifier=" + this.buyerIdentifier + ", " +
				"sellerIdentifier=" + this.sellerIdentifier + ", " +
				"payerIdentifierLeg1=" + this.payerIdentifierLeg1 + ", " +
				"payerIdentifierLeg2=" + this.payerIdentifierLeg2 + ", " +
				"receiverIdentifierLeg1=" + this.receiverIdentifierLeg1 + ", " +
				"receiverIdentifierLeg2=" + this.receiverIdentifierLeg2 + ", " +
				"brokerIdentifier=" + this.brokerIdentifier + ", " +
				"countryAndProvinceOrTerritoryOfIndividual=" + this.countryAndProvinceOrTerritoryOfIndividual + ", " +
				"jurisdictionOfCounterparty1=" + this.jurisdictionOfCounterparty1 + ", " +
				"jurisdictionOfCounterparty2=" + this.jurisdictionOfCounterparty2 + ", " +
				"subsequentPositionUTI=" + this.subsequentPositionUTI + ", " +
				"priorUSI=" + this.priorUSI + ", " +
				"interAffiliateIndicator=" + this.interAffiliateIndicator + ", " +
				"platformAnonymousExecutionIndicator=" + this.platformAnonymousExecutionIndicator + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"clearingMemberIdentifier=" + this.clearingMemberIdentifier + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"clearingExceptionsAndExemptionsCounterparty1=" + this.clearingExceptionsAndExemptionsCounterparty1 + ", " +
				"clearingExceptionsAndExemptionsCounterparty2=" + this.clearingExceptionsAndExemptionsCounterparty2 + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"level=" + this.level + ", " +
				"amendmentIndicator=" + this.amendmentIndicator + ", " +
				"packageIndicator=" + this.packageIndicator + ", " +
				"cryptoAssetUnderlyingIndicatorLeg1=" + this.cryptoAssetUnderlyingIndicatorLeg1 + ", " +
				"cryptoAssetUnderlyingIndicatorLeg2=" + this.cryptoAssetUnderlyingIndicatorLeg2 + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"customBasketIndicator=" + this.customBasketIndicator + ", " +
				"underlierIDOtherLeg1=" + this.underlierIDOtherLeg1 + ", " +
				"underlierIDOtherLeg2=" + this.underlierIDOtherLeg2 + ", " +
				"underlierIDOtherSourceLeg1=" + this.underlierIDOtherSourceLeg1 + ", " +
				"underlierIDOtherSourceLeg2=" + this.underlierIDOtherSourceLeg2 + ", " +
				"underlyingAssetTradingPlatformIdentifierLeg1=" + this.underlyingAssetTradingPlatformIdentifierLeg1 + ", " +
				"underlyingAssetTradingPlatformIdentifierLeg2=" + this.underlyingAssetTradingPlatformIdentifierLeg2 + ", " +
				"underlyingAssetPriceSourceLeg1=" + this.underlyingAssetPriceSourceLeg1 + ", " +
				"underlyingAssetPriceSourceLeg2=" + this.underlyingAssetPriceSourceLeg2 + ", " +
				"settlementLocation=" + this.settlementLocation + ", " +
				"exchangeRateBasisLeg1=" + this.exchangeRateBasisLeg1 + ", " +
				"nonReportable=" + this.nonReportable + ", " +
				"dtccAdditionalFields=" + this.dtccAdditionalFields +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of CSATransactionReport  ***********************/
	class CSATransactionReportBuilderImpl extends CommonTransactionReport.CommonTransactionReportBuilderImpl implements CSATransactionReport.CSATransactionReportBuilder {
	
		protected String counterparty2IdentifierSource;
		protected String buyerIdentifier;
		protected String sellerIdentifier;
		protected String payerIdentifierLeg1;
		protected String payerIdentifierLeg2;
		protected String receiverIdentifierLeg1;
		protected String receiverIdentifierLeg2;
		protected String brokerIdentifier;
		protected String countryAndProvinceOrTerritoryOfIndividual;
		protected List<String> jurisdictionOfCounterparty1 = new ArrayList<>();
		protected List<String> jurisdictionOfCounterparty2 = new ArrayList<>();
		protected String subsequentPositionUTI;
		protected String priorUSI;
		protected Boolean interAffiliateIndicator;
		protected Boolean platformAnonymousExecutionIndicator;
		protected String masterAgreementType;
		protected Integer masterAgreementVersion;
		protected Boolean nonStandardizedTermIndicator;
		protected ClearingAccountOriginEnum clearingAccountOrigin;
		protected String clearingMemberIdentifier;
		protected ZonedDateTime clearingReceiptTimestamp;
		protected List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<>();
		protected List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<>();
		protected String variationMarginCollateralPortfolioCode;
		protected String initialMarginCollateralPortfolioCode;
		protected ReportLevelEnum level;
		protected Boolean amendmentIndicator;
		protected Boolean packageIndicator;
		protected Boolean cryptoAssetUnderlyingIndicatorLeg1;
		protected Boolean cryptoAssetUnderlyingIndicatorLeg2;
		protected String customBasketCode;
		protected Boolean customBasketIndicator;
		protected String underlierIDOtherLeg1;
		protected String underlierIDOtherLeg2;
		protected String underlierIDOtherSourceLeg1;
		protected String underlierIDOtherSourceLeg2;
		protected String underlyingAssetTradingPlatformIdentifierLeg1;
		protected String underlyingAssetTradingPlatformIdentifierLeg2;
		protected String underlyingAssetPriceSourceLeg1;
		protected String underlyingAssetPriceSourceLeg2;
		protected String settlementLocation;
		protected String exchangeRateBasisLeg1;
		protected CSANonReportable.CSANonReportableBuilder nonReportable;
		protected DTCCAdditionalFields.DTCCAdditionalFieldsBuilder dtccAdditionalFields;
		
		@Override
		@RosettaAttribute("counterparty2IdentifierSource")
		@RuneAttribute("counterparty2IdentifierSource")
		public String getCounterparty2IdentifierSource() {
			return counterparty2IdentifierSource;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		public String getBuyerIdentifier() {
			return buyerIdentifier;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		public String getSellerIdentifier() {
			return sellerIdentifier;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		public String getPayerIdentifierLeg1() {
			return payerIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		public String getPayerIdentifierLeg2() {
			return payerIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		public String getReceiverIdentifierLeg1() {
			return receiverIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		public String getReceiverIdentifierLeg2() {
			return receiverIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("brokerIdentifier")
		@RuneAttribute("brokerIdentifier")
		public String getBrokerIdentifier() {
			return brokerIdentifier;
		}
		
		@Override
		@RosettaAttribute("countryAndProvinceOrTerritoryOfIndividual")
		@RuneAttribute("countryAndProvinceOrTerritoryOfIndividual")
		public String getCountryAndProvinceOrTerritoryOfIndividual() {
			return countryAndProvinceOrTerritoryOfIndividual;
		}
		
		@Override
		@RosettaAttribute("jurisdictionOfCounterparty1")
		@RuneAttribute("jurisdictionOfCounterparty1")
		public List<String> getJurisdictionOfCounterparty1() {
			return jurisdictionOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("jurisdictionOfCounterparty2")
		@RuneAttribute("jurisdictionOfCounterparty2")
		public List<String> getJurisdictionOfCounterparty2() {
			return jurisdictionOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public String getSubsequentPositionUTI() {
			return subsequentPositionUTI;
		}
		
		@Override
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		public String getPriorUSI() {
			return priorUSI;
		}
		
		@Override
		@RosettaAttribute("interAffiliateIndicator")
		@RuneAttribute("interAffiliateIndicator")
		public Boolean getInterAffiliateIndicator() {
			return interAffiliateIndicator;
		}
		
		@Override
		@RosettaAttribute("platformAnonymousExecutionIndicator")
		@RuneAttribute("platformAnonymousExecutionIndicator")
		public Boolean getPlatformAnonymousExecutionIndicator() {
			return platformAnonymousExecutionIndicator;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public Integer getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public Boolean getNonStandardizedTermIndicator() {
			return nonStandardizedTermIndicator;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public ClearingAccountOriginEnum getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("clearingMemberIdentifier")
		@RuneAttribute("clearingMemberIdentifier")
		public String getClearingMemberIdentifier() {
			return clearingMemberIdentifier;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty1() {
			return clearingExceptionsAndExemptionsCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty2() {
			return clearingExceptionsAndExemptionsCounterparty2;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public ReportLevelEnum getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public Boolean getAmendmentIndicator() {
			return amendmentIndicator;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public Boolean getPackageIndicator() {
			return packageIndicator;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicatorLeg1")
		@RuneAttribute("cryptoAssetUnderlyingIndicatorLeg1")
		public Boolean getCryptoAssetUnderlyingIndicatorLeg1() {
			return cryptoAssetUnderlyingIndicatorLeg1;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicatorLeg2")
		@RuneAttribute("cryptoAssetUnderlyingIndicatorLeg2")
		public Boolean getCryptoAssetUnderlyingIndicatorLeg2() {
			return cryptoAssetUnderlyingIndicatorLeg2;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public Boolean getCustomBasketIndicator() {
			return customBasketIndicator;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherLeg1")
		@RuneAttribute("underlierIDOtherLeg1")
		public String getUnderlierIDOtherLeg1() {
			return underlierIDOtherLeg1;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherLeg2")
		@RuneAttribute("underlierIDOtherLeg2")
		public String getUnderlierIDOtherLeg2() {
			return underlierIDOtherLeg2;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherSourceLeg1")
		@RuneAttribute("underlierIDOtherSourceLeg1")
		public String getUnderlierIDOtherSourceLeg1() {
			return underlierIDOtherSourceLeg1;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherSourceLeg2")
		@RuneAttribute("underlierIDOtherSourceLeg2")
		public String getUnderlierIDOtherSourceLeg2() {
			return underlierIDOtherSourceLeg2;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifierLeg1")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifierLeg1")
		public String getUnderlyingAssetTradingPlatformIdentifierLeg1() {
			return underlyingAssetTradingPlatformIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifierLeg2")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifierLeg2")
		public String getUnderlyingAssetTradingPlatformIdentifierLeg2() {
			return underlyingAssetTradingPlatformIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSourceLeg1")
		@RuneAttribute("underlyingAssetPriceSourceLeg1")
		public String getUnderlyingAssetPriceSourceLeg1() {
			return underlyingAssetPriceSourceLeg1;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSourceLeg2")
		@RuneAttribute("underlyingAssetPriceSourceLeg2")
		public String getUnderlyingAssetPriceSourceLeg2() {
			return underlyingAssetPriceSourceLeg2;
		}
		
		@Override
		@RosettaAttribute("settlementLocation")
		@RuneAttribute("settlementLocation")
		public String getSettlementLocation() {
			return settlementLocation;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisLeg1")
		@RuneAttribute("exchangeRateBasisLeg1")
		public String getExchangeRateBasisLeg1() {
			return exchangeRateBasisLeg1;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public CSANonReportable.CSANonReportableBuilder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public CSANonReportable.CSANonReportableBuilder getOrCreateNonReportable() {
			CSANonReportable.CSANonReportableBuilder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = CSANonReportable.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("dtccAdditionalFields")
		@RuneAttribute("dtccAdditionalFields")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getDtccAdditionalFields() {
			return dtccAdditionalFields;
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getOrCreateDtccAdditionalFields() {
			DTCCAdditionalFields.DTCCAdditionalFieldsBuilder result;
			if (dtccAdditionalFields!=null) {
				result = dtccAdditionalFields;
			}
			else {
				result = dtccAdditionalFields = DTCCAdditionalFields.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public CSATransactionReport.CSATransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public CSATransactionReport.CSATransactionReportBuilder setEventType(EventTypeEnum _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public CSATransactionReport.CSATransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public CSATransactionReport.CSATransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public CSATransactionReport.CSATransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public CSATransactionReport.CSATransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public CSATransactionReport.CSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public CSATransactionReport.CSATransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public CSATransactionReport.CSATransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public CSATransactionReport.CSATransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public CSATransactionReport.CSATransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public CSATransactionReport.CSATransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public CSATransactionReport.CSATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public CSATransactionReport.CSATransactionReportBuilder setCleared(ClearedEnum _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public CSATransactionReport.CSATransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public CSATransactionReport.CSATransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public CSATransactionReport.CSATransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public CSATransactionReport.CSATransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public CSATransactionReport.CSATransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public CSATransactionReport.CSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public CSATransactionReport.CSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public CSATransactionReport.CSATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int _idx) {
			getIndex(this.priceSchedule, _idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public CSATransactionReport.CSATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules != null) {
				for (final PricePeriod toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("priceSchedule")
		public CSATransactionReport.CSATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public CSATransactionReport.CSATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int _idx) {
			getIndex(this.strikePriceSchedule, _idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public CSATransactionReport.CSATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final PricePeriod toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("strikePriceSchedule")
		public CSATransactionReport.CSATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public CSATransactionReport.CSATransactionReportBuilder setPrice(PriceFormat _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public CSATransactionReport.CSATransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public CSATransactionReport.CSATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public CSATransactionReport.CSATransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public CSATransactionReport.CSATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public CSATransactionReport.CSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public CSATransactionReport.CSATransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public CSATransactionReport.CSATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public CSATransactionReport.CSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public CSATransactionReport.CSATransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public CSATransactionReport.CSATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public CSATransactionReport.CSATransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public CSATransactionReport.CSATransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public CSATransactionReport.CSATransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public CSATransactionReport.CSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public CSATransactionReport.CSATransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public CSATransactionReport.CSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public CSATransactionReport.CSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public CSATransactionReport.CSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public CSATransactionReport.CSATransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public CSATransactionReport.CSATransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public CSATransactionReport.CSATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int _idx) {
			getIndex(this.otherPayment, _idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override 
		public CSATransactionReport.CSATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPayment toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPayment")
		public CSATransactionReport.CSATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1")
		@RuneAttribute("leg1")
		public CSATransactionReport.CSATransactionReportBuilder setLeg1(CommonLeg _leg1) {
			this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public CSATransactionReport.CSATransactionReportBuilder setLeg1(Leg _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("leg2")
		@RuneAttribute("leg2")
		public CSATransactionReport.CSATransactionReportBuilder setLeg2(CommonLeg _leg2) {
			this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public CSATransactionReport.CSATransactionReportBuilder setLeg2(Leg _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public CSATransactionReport.CSATransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty1")
		@RuneAttribute("executionAgentCounterparty1")
		public CSATransactionReport.CSATransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
			this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty2DTCC")
		@RuneAttribute("executionAgentCounterparty2DTCC")
		public CSATransactionReport.CSATransactionReportBuilder setExecutionAgentCounterparty2DTCC(String _executionAgentCounterparty2DTCC) {
			this.executionAgentCounterparty2DTCC = _executionAgentCounterparty2DTCC == null ? null : _executionAgentCounterparty2DTCC;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportSubmittingEntityID")
		@RuneAttribute("reportSubmittingEntityID")
		public CSATransactionReport.CSATransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public CSATransactionReport.CSATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public CSATransactionReport.CSATransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public CSATransactionReport.CSATransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public CSATransactionReport.CSATransactionReportBuilder setContractType(CommonContractType _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@Override
		@RosettaAttribute("assetClass")
		@RuneAttribute("assetClass")
		public CSATransactionReport.CSATransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public CSATransactionReport.CSATransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public CSATransactionReport.CSATransactionReportBuilder setDirection1(Direction1Enum _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public CSATransactionReport.CSATransactionReportBuilder setDirection2Leg1(Direction2Enum _direction2Leg1) {
			this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public CSATransactionReport.CSATransactionReportBuilder setDirection2Leg2(Direction2Enum _direction2Leg2) {
			this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public CSATransactionReport.CSATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public CSATransactionReport.CSATransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public CSATransactionReport.CSATransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public CSATransactionReport.CSATransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public CSATransactionReport.CSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int _idx) {
			getIndex(this.basketConstituents, _idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override 
		public CSATransactionReport.CSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituents")
		public CSATransactionReport.CSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlying(UnderlyingIdentifier _underlying) {
			this.underlying = _underlying == null ? null : _underlying.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public CSATransactionReport.CSATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public CSATransactionReport.CSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public CSATransactionReport.CSATransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public CSATransactionReport.CSATransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public CSATransactionReport.CSATransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterparty2")
		@RuneAttribute("countryOfTheCounterparty2")
		public CSATransactionReport.CSATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
			this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public CSATransactionReport.CSATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public CSATransactionReport.CSATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradingCapacity")
		@RuneAttribute("tradingCapacity")
		public CSATransactionReport.CSATransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
			this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
			return this;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public CSATransactionReport.CSATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public CSATransactionReport.CSATransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public CSATransactionReport.CSATransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public CSATransactionReport.CSATransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public CSATransactionReport.CSATransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierSource")
		@RuneAttribute("counterparty2IdentifierSource")
		public CSATransactionReport.CSATransactionReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
			this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
			this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
			this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setPayerIdentifierLeg1(String _payerIdentifierLeg1) {
			this.payerIdentifierLeg1 = _payerIdentifierLeg1 == null ? null : _payerIdentifierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		public CSATransactionReport.CSATransactionReportBuilder setPayerIdentifierLeg2(String _payerIdentifierLeg2) {
			this.payerIdentifierLeg2 = _payerIdentifierLeg2 == null ? null : _payerIdentifierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setReceiverIdentifierLeg1(String _receiverIdentifierLeg1) {
			this.receiverIdentifierLeg1 = _receiverIdentifierLeg1 == null ? null : _receiverIdentifierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		public CSATransactionReport.CSATransactionReportBuilder setReceiverIdentifierLeg2(String _receiverIdentifierLeg2) {
			this.receiverIdentifierLeg2 = _receiverIdentifierLeg2 == null ? null : _receiverIdentifierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("brokerIdentifier")
		@RuneAttribute("brokerIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setBrokerIdentifier(String _brokerIdentifier) {
			this.brokerIdentifier = _brokerIdentifier == null ? null : _brokerIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryAndProvinceOrTerritoryOfIndividual")
		@RuneAttribute("countryAndProvinceOrTerritoryOfIndividual")
		public CSATransactionReport.CSATransactionReportBuilder setCountryAndProvinceOrTerritoryOfIndividual(String _countryAndProvinceOrTerritoryOfIndividual) {
			this.countryAndProvinceOrTerritoryOfIndividual = _countryAndProvinceOrTerritoryOfIndividual == null ? null : _countryAndProvinceOrTerritoryOfIndividual;
			return this;
		}
		
		@Override
		@RosettaAttribute("jurisdictionOfCounterparty1")
		@RuneAttribute("jurisdictionOfCounterparty1")
		public CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty1(String _jurisdictionOfCounterparty1) {
			if (_jurisdictionOfCounterparty1 != null) {
				this.jurisdictionOfCounterparty1.add(_jurisdictionOfCounterparty1);
			}
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty1(String _jurisdictionOfCounterparty1, int _idx) {
			getIndex(this.jurisdictionOfCounterparty1, _idx, () -> _jurisdictionOfCounterparty1);
			return this;
		}
		
		@Override 
		public CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty1(List<String> jurisdictionOfCounterparty1s) {
			if (jurisdictionOfCounterparty1s != null) {
				for (final String toAdd : jurisdictionOfCounterparty1s) {
					this.jurisdictionOfCounterparty1.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("jurisdictionOfCounterparty1")
		public CSATransactionReport.CSATransactionReportBuilder setJurisdictionOfCounterparty1(List<String> jurisdictionOfCounterparty1s) {
			if (jurisdictionOfCounterparty1s == null) {
				this.jurisdictionOfCounterparty1 = new ArrayList<>();
			} else {
				this.jurisdictionOfCounterparty1 = jurisdictionOfCounterparty1s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("jurisdictionOfCounterparty2")
		@RuneAttribute("jurisdictionOfCounterparty2")
		public CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty2(String _jurisdictionOfCounterparty2) {
			if (_jurisdictionOfCounterparty2 != null) {
				this.jurisdictionOfCounterparty2.add(_jurisdictionOfCounterparty2);
			}
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty2(String _jurisdictionOfCounterparty2, int _idx) {
			getIndex(this.jurisdictionOfCounterparty2, _idx, () -> _jurisdictionOfCounterparty2);
			return this;
		}
		
		@Override 
		public CSATransactionReport.CSATransactionReportBuilder addJurisdictionOfCounterparty2(List<String> jurisdictionOfCounterparty2s) {
			if (jurisdictionOfCounterparty2s != null) {
				for (final String toAdd : jurisdictionOfCounterparty2s) {
					this.jurisdictionOfCounterparty2.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("jurisdictionOfCounterparty2")
		public CSATransactionReport.CSATransactionReportBuilder setJurisdictionOfCounterparty2(List<String> jurisdictionOfCounterparty2s) {
			if (jurisdictionOfCounterparty2s == null) {
				this.jurisdictionOfCounterparty2 = new ArrayList<>();
			} else {
				this.jurisdictionOfCounterparty2 = jurisdictionOfCounterparty2s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public CSATransactionReport.CSATransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
			this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		public CSATransactionReport.CSATransactionReportBuilder setPriorUSI(String _priorUSI) {
			this.priorUSI = _priorUSI == null ? null : _priorUSI;
			return this;
		}
		
		@Override
		@RosettaAttribute("interAffiliateIndicator")
		@RuneAttribute("interAffiliateIndicator")
		public CSATransactionReport.CSATransactionReportBuilder setInterAffiliateIndicator(Boolean _interAffiliateIndicator) {
			this.interAffiliateIndicator = _interAffiliateIndicator == null ? null : _interAffiliateIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("platformAnonymousExecutionIndicator")
		@RuneAttribute("platformAnonymousExecutionIndicator")
		public CSATransactionReport.CSATransactionReportBuilder setPlatformAnonymousExecutionIndicator(Boolean _platformAnonymousExecutionIndicator) {
			this.platformAnonymousExecutionIndicator = _platformAnonymousExecutionIndicator == null ? null : _platformAnonymousExecutionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public CSATransactionReport.CSATransactionReportBuilder setMasterAgreementType(String _masterAgreementType) {
			this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public CSATransactionReport.CSATransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
			this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public CSATransactionReport.CSATransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
			this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public CSATransactionReport.CSATransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
			this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMemberIdentifier")
		@RuneAttribute("clearingMemberIdentifier")
		public CSATransactionReport.CSATransactionReportBuilder setClearingMemberIdentifier(String _clearingMemberIdentifier) {
			this.clearingMemberIdentifier = _clearingMemberIdentifier == null ? null : _clearingMemberIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public CSATransactionReport.CSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
			this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
			if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
				this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
			}
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int _idx) {
			getIndex(this.clearingExceptionsAndExemptionsCounterparty1, _idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
			return this;
		}
		
		@Override 
		public CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
			if (clearingExceptionsAndExemptionsCounterparty1s != null) {
				for (final ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
					this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public CSATransactionReport.CSATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
			if (clearingExceptionsAndExemptionsCounterparty1s == null) {
				this.clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<>();
			} else {
				this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
			if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
				this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
			}
			return this;
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int _idx) {
			getIndex(this.clearingExceptionsAndExemptionsCounterparty2, _idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
			return this;
		}
		
		@Override 
		public CSATransactionReport.CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
			if (clearingExceptionsAndExemptionsCounterparty2s != null) {
				for (final ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
					this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public CSATransactionReport.CSATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
			if (clearingExceptionsAndExemptionsCounterparty2s == null) {
				this.clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<>();
			} else {
				this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public CSATransactionReport.CSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public CSATransactionReport.CSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public CSATransactionReport.CSATransactionReportBuilder setLevel(ReportLevelEnum _level) {
			this.level = _level == null ? null : _level;
			return this;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public CSATransactionReport.CSATransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
			this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public CSATransactionReport.CSATransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
			this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicatorLeg1")
		@RuneAttribute("cryptoAssetUnderlyingIndicatorLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setCryptoAssetUnderlyingIndicatorLeg1(Boolean _cryptoAssetUnderlyingIndicatorLeg1) {
			this.cryptoAssetUnderlyingIndicatorLeg1 = _cryptoAssetUnderlyingIndicatorLeg1 == null ? null : _cryptoAssetUnderlyingIndicatorLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicatorLeg2")
		@RuneAttribute("cryptoAssetUnderlyingIndicatorLeg2")
		public CSATransactionReport.CSATransactionReportBuilder setCryptoAssetUnderlyingIndicatorLeg2(Boolean _cryptoAssetUnderlyingIndicatorLeg2) {
			this.cryptoAssetUnderlyingIndicatorLeg2 = _cryptoAssetUnderlyingIndicatorLeg2 == null ? null : _cryptoAssetUnderlyingIndicatorLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public CSATransactionReport.CSATransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public CSATransactionReport.CSATransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
			this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherLeg1")
		@RuneAttribute("underlierIDOtherLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlierIDOtherLeg1(String _underlierIDOtherLeg1) {
			this.underlierIDOtherLeg1 = _underlierIDOtherLeg1 == null ? null : _underlierIDOtherLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherLeg2")
		@RuneAttribute("underlierIDOtherLeg2")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlierIDOtherLeg2(String _underlierIDOtherLeg2) {
			this.underlierIDOtherLeg2 = _underlierIDOtherLeg2 == null ? null : _underlierIDOtherLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherSourceLeg1")
		@RuneAttribute("underlierIDOtherSourceLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlierIDOtherSourceLeg1(String _underlierIDOtherSourceLeg1) {
			this.underlierIDOtherSourceLeg1 = _underlierIDOtherSourceLeg1 == null ? null : _underlierIDOtherSourceLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierIDOtherSourceLeg2")
		@RuneAttribute("underlierIDOtherSourceLeg2")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlierIDOtherSourceLeg2(String _underlierIDOtherSourceLeg2) {
			this.underlierIDOtherSourceLeg2 = _underlierIDOtherSourceLeg2 == null ? null : _underlierIDOtherSourceLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifierLeg1")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifierLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifierLeg1(String _underlyingAssetTradingPlatformIdentifierLeg1) {
			this.underlyingAssetTradingPlatformIdentifierLeg1 = _underlyingAssetTradingPlatformIdentifierLeg1 == null ? null : _underlyingAssetTradingPlatformIdentifierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifierLeg2")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifierLeg2")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifierLeg2(String _underlyingAssetTradingPlatformIdentifierLeg2) {
			this.underlyingAssetTradingPlatformIdentifierLeg2 = _underlyingAssetTradingPlatformIdentifierLeg2 == null ? null : _underlyingAssetTradingPlatformIdentifierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSourceLeg1")
		@RuneAttribute("underlyingAssetPriceSourceLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlyingAssetPriceSourceLeg1(String _underlyingAssetPriceSourceLeg1) {
			this.underlyingAssetPriceSourceLeg1 = _underlyingAssetPriceSourceLeg1 == null ? null : _underlyingAssetPriceSourceLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSourceLeg2")
		@RuneAttribute("underlyingAssetPriceSourceLeg2")
		public CSATransactionReport.CSATransactionReportBuilder setUnderlyingAssetPriceSourceLeg2(String _underlyingAssetPriceSourceLeg2) {
			this.underlyingAssetPriceSourceLeg2 = _underlyingAssetPriceSourceLeg2 == null ? null : _underlyingAssetPriceSourceLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementLocation")
		@RuneAttribute("settlementLocation")
		public CSATransactionReport.CSATransactionReportBuilder setSettlementLocation(String _settlementLocation) {
			this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasisLeg1")
		@RuneAttribute("exchangeRateBasisLeg1")
		public CSATransactionReport.CSATransactionReportBuilder setExchangeRateBasisLeg1(String _exchangeRateBasisLeg1) {
			this.exchangeRateBasisLeg1 = _exchangeRateBasisLeg1 == null ? null : _exchangeRateBasisLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public CSATransactionReport.CSATransactionReportBuilder setNonReportable(CSANonReportable _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("dtccAdditionalFields")
		@RuneAttribute("dtccAdditionalFields")
		public CSATransactionReport.CSATransactionReportBuilder setDtccAdditionalFields(DTCCAdditionalFields _dtccAdditionalFields) {
			this.dtccAdditionalFields = _dtccAdditionalFields == null ? null : _dtccAdditionalFields.toBuilder();
			return this;
		}
		
		@Override
		public CSATransactionReport build() {
			return new CSATransactionReport.CSATransactionReportImpl(this);
		}
		
		@Override
		public CSATransactionReport.CSATransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CSATransactionReport.CSATransactionReportBuilder prune() {
			super.prune();
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			if (dtccAdditionalFields!=null && !dtccAdditionalFields.prune().hasData()) dtccAdditionalFields = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getCounterparty2IdentifierSource()!=null) return true;
			if (getBuyerIdentifier()!=null) return true;
			if (getSellerIdentifier()!=null) return true;
			if (getPayerIdentifierLeg1()!=null) return true;
			if (getPayerIdentifierLeg2()!=null) return true;
			if (getReceiverIdentifierLeg1()!=null) return true;
			if (getReceiverIdentifierLeg2()!=null) return true;
			if (getBrokerIdentifier()!=null) return true;
			if (getCountryAndProvinceOrTerritoryOfIndividual()!=null) return true;
			if (getJurisdictionOfCounterparty1()!=null && !getJurisdictionOfCounterparty1().isEmpty()) return true;
			if (getJurisdictionOfCounterparty2()!=null && !getJurisdictionOfCounterparty2().isEmpty()) return true;
			if (getSubsequentPositionUTI()!=null) return true;
			if (getPriorUSI()!=null) return true;
			if (getInterAffiliateIndicator()!=null) return true;
			if (getPlatformAnonymousExecutionIndicator()!=null) return true;
			if (getMasterAgreementType()!=null) return true;
			if (getMasterAgreementVersion()!=null) return true;
			if (getNonStandardizedTermIndicator()!=null) return true;
			if (getClearingAccountOrigin()!=null) return true;
			if (getClearingMemberIdentifier()!=null) return true;
			if (getClearingReceiptTimestamp()!=null) return true;
			if (getClearingExceptionsAndExemptionsCounterparty1()!=null && !getClearingExceptionsAndExemptionsCounterparty1().isEmpty()) return true;
			if (getClearingExceptionsAndExemptionsCounterparty2()!=null && !getClearingExceptionsAndExemptionsCounterparty2().isEmpty()) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getLevel()!=null) return true;
			if (getAmendmentIndicator()!=null) return true;
			if (getPackageIndicator()!=null) return true;
			if (getCryptoAssetUnderlyingIndicatorLeg1()!=null) return true;
			if (getCryptoAssetUnderlyingIndicatorLeg2()!=null) return true;
			if (getCustomBasketCode()!=null) return true;
			if (getCustomBasketIndicator()!=null) return true;
			if (getUnderlierIDOtherLeg1()!=null) return true;
			if (getUnderlierIDOtherLeg2()!=null) return true;
			if (getUnderlierIDOtherSourceLeg1()!=null) return true;
			if (getUnderlierIDOtherSourceLeg2()!=null) return true;
			if (getUnderlyingAssetTradingPlatformIdentifierLeg1()!=null) return true;
			if (getUnderlyingAssetTradingPlatformIdentifierLeg2()!=null) return true;
			if (getUnderlyingAssetPriceSourceLeg1()!=null) return true;
			if (getUnderlyingAssetPriceSourceLeg2()!=null) return true;
			if (getSettlementLocation()!=null) return true;
			if (getExchangeRateBasisLeg1()!=null) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			if (getDtccAdditionalFields()!=null && getDtccAdditionalFields().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CSATransactionReport.CSATransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			CSATransactionReport.CSATransactionReportBuilder o = (CSATransactionReport.CSATransactionReportBuilder) other;
			
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			merger.mergeRosetta(getDtccAdditionalFields(), o.getDtccAdditionalFields(), this::setDtccAdditionalFields);
			
			merger.mergeBasic(getCounterparty2IdentifierSource(), o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSource);
			merger.mergeBasic(getBuyerIdentifier(), o.getBuyerIdentifier(), this::setBuyerIdentifier);
			merger.mergeBasic(getSellerIdentifier(), o.getSellerIdentifier(), this::setSellerIdentifier);
			merger.mergeBasic(getPayerIdentifierLeg1(), o.getPayerIdentifierLeg1(), this::setPayerIdentifierLeg1);
			merger.mergeBasic(getPayerIdentifierLeg2(), o.getPayerIdentifierLeg2(), this::setPayerIdentifierLeg2);
			merger.mergeBasic(getReceiverIdentifierLeg1(), o.getReceiverIdentifierLeg1(), this::setReceiverIdentifierLeg1);
			merger.mergeBasic(getReceiverIdentifierLeg2(), o.getReceiverIdentifierLeg2(), this::setReceiverIdentifierLeg2);
			merger.mergeBasic(getBrokerIdentifier(), o.getBrokerIdentifier(), this::setBrokerIdentifier);
			merger.mergeBasic(getCountryAndProvinceOrTerritoryOfIndividual(), o.getCountryAndProvinceOrTerritoryOfIndividual(), this::setCountryAndProvinceOrTerritoryOfIndividual);
			merger.mergeBasic(getJurisdictionOfCounterparty1(), o.getJurisdictionOfCounterparty1(), (Consumer<String>) this::addJurisdictionOfCounterparty1);
			merger.mergeBasic(getJurisdictionOfCounterparty2(), o.getJurisdictionOfCounterparty2(), (Consumer<String>) this::addJurisdictionOfCounterparty2);
			merger.mergeBasic(getSubsequentPositionUTI(), o.getSubsequentPositionUTI(), this::setSubsequentPositionUTI);
			merger.mergeBasic(getPriorUSI(), o.getPriorUSI(), this::setPriorUSI);
			merger.mergeBasic(getInterAffiliateIndicator(), o.getInterAffiliateIndicator(), this::setInterAffiliateIndicator);
			merger.mergeBasic(getPlatformAnonymousExecutionIndicator(), o.getPlatformAnonymousExecutionIndicator(), this::setPlatformAnonymousExecutionIndicator);
			merger.mergeBasic(getMasterAgreementType(), o.getMasterAgreementType(), this::setMasterAgreementType);
			merger.mergeBasic(getMasterAgreementVersion(), o.getMasterAgreementVersion(), this::setMasterAgreementVersion);
			merger.mergeBasic(getNonStandardizedTermIndicator(), o.getNonStandardizedTermIndicator(), this::setNonStandardizedTermIndicator);
			merger.mergeBasic(getClearingAccountOrigin(), o.getClearingAccountOrigin(), this::setClearingAccountOrigin);
			merger.mergeBasic(getClearingMemberIdentifier(), o.getClearingMemberIdentifier(), this::setClearingMemberIdentifier);
			merger.mergeBasic(getClearingReceiptTimestamp(), o.getClearingReceiptTimestamp(), this::setClearingReceiptTimestamp);
			merger.mergeBasic(getClearingExceptionsAndExemptionsCounterparty1(), o.getClearingExceptionsAndExemptionsCounterparty1(), (Consumer<ClearingExceptionsAndExemptionsEnum>) this::addClearingExceptionsAndExemptionsCounterparty1);
			merger.mergeBasic(getClearingExceptionsAndExemptionsCounterparty2(), o.getClearingExceptionsAndExemptionsCounterparty2(), (Consumer<ClearingExceptionsAndExemptionsEnum>) this::addClearingExceptionsAndExemptionsCounterparty2);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getLevel(), o.getLevel(), this::setLevel);
			merger.mergeBasic(getAmendmentIndicator(), o.getAmendmentIndicator(), this::setAmendmentIndicator);
			merger.mergeBasic(getPackageIndicator(), o.getPackageIndicator(), this::setPackageIndicator);
			merger.mergeBasic(getCryptoAssetUnderlyingIndicatorLeg1(), o.getCryptoAssetUnderlyingIndicatorLeg1(), this::setCryptoAssetUnderlyingIndicatorLeg1);
			merger.mergeBasic(getCryptoAssetUnderlyingIndicatorLeg2(), o.getCryptoAssetUnderlyingIndicatorLeg2(), this::setCryptoAssetUnderlyingIndicatorLeg2);
			merger.mergeBasic(getCustomBasketCode(), o.getCustomBasketCode(), this::setCustomBasketCode);
			merger.mergeBasic(getCustomBasketIndicator(), o.getCustomBasketIndicator(), this::setCustomBasketIndicator);
			merger.mergeBasic(getUnderlierIDOtherLeg1(), o.getUnderlierIDOtherLeg1(), this::setUnderlierIDOtherLeg1);
			merger.mergeBasic(getUnderlierIDOtherLeg2(), o.getUnderlierIDOtherLeg2(), this::setUnderlierIDOtherLeg2);
			merger.mergeBasic(getUnderlierIDOtherSourceLeg1(), o.getUnderlierIDOtherSourceLeg1(), this::setUnderlierIDOtherSourceLeg1);
			merger.mergeBasic(getUnderlierIDOtherSourceLeg2(), o.getUnderlierIDOtherSourceLeg2(), this::setUnderlierIDOtherSourceLeg2);
			merger.mergeBasic(getUnderlyingAssetTradingPlatformIdentifierLeg1(), o.getUnderlyingAssetTradingPlatformIdentifierLeg1(), this::setUnderlyingAssetTradingPlatformIdentifierLeg1);
			merger.mergeBasic(getUnderlyingAssetTradingPlatformIdentifierLeg2(), o.getUnderlyingAssetTradingPlatformIdentifierLeg2(), this::setUnderlyingAssetTradingPlatformIdentifierLeg2);
			merger.mergeBasic(getUnderlyingAssetPriceSourceLeg1(), o.getUnderlyingAssetPriceSourceLeg1(), this::setUnderlyingAssetPriceSourceLeg1);
			merger.mergeBasic(getUnderlyingAssetPriceSourceLeg2(), o.getUnderlyingAssetPriceSourceLeg2(), this::setUnderlyingAssetPriceSourceLeg2);
			merger.mergeBasic(getSettlementLocation(), o.getSettlementLocation(), this::setSettlementLocation);
			merger.mergeBasic(getExchangeRateBasisLeg1(), o.getExchangeRateBasisLeg1(), this::setExchangeRateBasisLeg1);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CSATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) return false;
			if (!Objects.equals(buyerIdentifier, _that.getBuyerIdentifier())) return false;
			if (!Objects.equals(sellerIdentifier, _that.getSellerIdentifier())) return false;
			if (!Objects.equals(payerIdentifierLeg1, _that.getPayerIdentifierLeg1())) return false;
			if (!Objects.equals(payerIdentifierLeg2, _that.getPayerIdentifierLeg2())) return false;
			if (!Objects.equals(receiverIdentifierLeg1, _that.getReceiverIdentifierLeg1())) return false;
			if (!Objects.equals(receiverIdentifierLeg2, _that.getReceiverIdentifierLeg2())) return false;
			if (!Objects.equals(brokerIdentifier, _that.getBrokerIdentifier())) return false;
			if (!Objects.equals(countryAndProvinceOrTerritoryOfIndividual, _that.getCountryAndProvinceOrTerritoryOfIndividual())) return false;
			if (!ListEquals.listEquals(jurisdictionOfCounterparty1, _that.getJurisdictionOfCounterparty1())) return false;
			if (!ListEquals.listEquals(jurisdictionOfCounterparty2, _that.getJurisdictionOfCounterparty2())) return false;
			if (!Objects.equals(subsequentPositionUTI, _that.getSubsequentPositionUTI())) return false;
			if (!Objects.equals(priorUSI, _that.getPriorUSI())) return false;
			if (!Objects.equals(interAffiliateIndicator, _that.getInterAffiliateIndicator())) return false;
			if (!Objects.equals(platformAnonymousExecutionIndicator, _that.getPlatformAnonymousExecutionIndicator())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!Objects.equals(clearingMemberIdentifier, _that.getClearingMemberIdentifier())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty1, _that.getClearingExceptionsAndExemptionsCounterparty1())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty2, _that.getClearingExceptionsAndExemptionsCounterparty2())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			if (!Objects.equals(amendmentIndicator, _that.getAmendmentIndicator())) return false;
			if (!Objects.equals(packageIndicator, _that.getPackageIndicator())) return false;
			if (!Objects.equals(cryptoAssetUnderlyingIndicatorLeg1, _that.getCryptoAssetUnderlyingIndicatorLeg1())) return false;
			if (!Objects.equals(cryptoAssetUnderlyingIndicatorLeg2, _that.getCryptoAssetUnderlyingIndicatorLeg2())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(customBasketIndicator, _that.getCustomBasketIndicator())) return false;
			if (!Objects.equals(underlierIDOtherLeg1, _that.getUnderlierIDOtherLeg1())) return false;
			if (!Objects.equals(underlierIDOtherLeg2, _that.getUnderlierIDOtherLeg2())) return false;
			if (!Objects.equals(underlierIDOtherSourceLeg1, _that.getUnderlierIDOtherSourceLeg1())) return false;
			if (!Objects.equals(underlierIDOtherSourceLeg2, _that.getUnderlierIDOtherSourceLeg2())) return false;
			if (!Objects.equals(underlyingAssetTradingPlatformIdentifierLeg1, _that.getUnderlyingAssetTradingPlatformIdentifierLeg1())) return false;
			if (!Objects.equals(underlyingAssetTradingPlatformIdentifierLeg2, _that.getUnderlyingAssetTradingPlatformIdentifierLeg2())) return false;
			if (!Objects.equals(underlyingAssetPriceSourceLeg1, _that.getUnderlyingAssetPriceSourceLeg1())) return false;
			if (!Objects.equals(underlyingAssetPriceSourceLeg2, _that.getUnderlyingAssetPriceSourceLeg2())) return false;
			if (!Objects.equals(settlementLocation, _that.getSettlementLocation())) return false;
			if (!Objects.equals(exchangeRateBasisLeg1, _that.getExchangeRateBasisLeg1())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			if (!Objects.equals(dtccAdditionalFields, _that.getDtccAdditionalFields())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (counterparty2IdentifierSource != null ? counterparty2IdentifierSource.hashCode() : 0);
			_result = 31 * _result + (buyerIdentifier != null ? buyerIdentifier.hashCode() : 0);
			_result = 31 * _result + (sellerIdentifier != null ? sellerIdentifier.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg1 != null ? payerIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg2 != null ? payerIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg1 != null ? receiverIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg2 != null ? receiverIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (brokerIdentifier != null ? brokerIdentifier.hashCode() : 0);
			_result = 31 * _result + (countryAndProvinceOrTerritoryOfIndividual != null ? countryAndProvinceOrTerritoryOfIndividual.hashCode() : 0);
			_result = 31 * _result + (jurisdictionOfCounterparty1 != null ? jurisdictionOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (jurisdictionOfCounterparty2 != null ? jurisdictionOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (subsequentPositionUTI != null ? subsequentPositionUTI.hashCode() : 0);
			_result = 31 * _result + (priorUSI != null ? priorUSI.hashCode() : 0);
			_result = 31 * _result + (interAffiliateIndicator != null ? interAffiliateIndicator.hashCode() : 0);
			_result = 31 * _result + (platformAnonymousExecutionIndicator != null ? platformAnonymousExecutionIndicator.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (nonStandardizedTermIndicator != null ? nonStandardizedTermIndicator.hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (clearingMemberIdentifier != null ? clearingMemberIdentifier.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty1 != null ? clearingExceptionsAndExemptionsCounterparty1.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty2 != null ? clearingExceptionsAndExemptionsCounterparty2.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (amendmentIndicator != null ? amendmentIndicator.hashCode() : 0);
			_result = 31 * _result + (packageIndicator != null ? packageIndicator.hashCode() : 0);
			_result = 31 * _result + (cryptoAssetUnderlyingIndicatorLeg1 != null ? cryptoAssetUnderlyingIndicatorLeg1.hashCode() : 0);
			_result = 31 * _result + (cryptoAssetUnderlyingIndicatorLeg2 != null ? cryptoAssetUnderlyingIndicatorLeg2.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (customBasketIndicator != null ? customBasketIndicator.hashCode() : 0);
			_result = 31 * _result + (underlierIDOtherLeg1 != null ? underlierIDOtherLeg1.hashCode() : 0);
			_result = 31 * _result + (underlierIDOtherLeg2 != null ? underlierIDOtherLeg2.hashCode() : 0);
			_result = 31 * _result + (underlierIDOtherSourceLeg1 != null ? underlierIDOtherSourceLeg1.hashCode() : 0);
			_result = 31 * _result + (underlierIDOtherSourceLeg2 != null ? underlierIDOtherSourceLeg2.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetTradingPlatformIdentifierLeg1 != null ? underlyingAssetTradingPlatformIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetTradingPlatformIdentifierLeg2 != null ? underlyingAssetTradingPlatformIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetPriceSourceLeg1 != null ? underlyingAssetPriceSourceLeg1.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetPriceSourceLeg2 != null ? underlyingAssetPriceSourceLeg2.hashCode() : 0);
			_result = 31 * _result + (settlementLocation != null ? settlementLocation.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasisLeg1 != null ? exchangeRateBasisLeg1.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			_result = 31 * _result + (dtccAdditionalFields != null ? dtccAdditionalFields.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CSATransactionReportBuilder {" +
				"counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", " +
				"buyerIdentifier=" + this.buyerIdentifier + ", " +
				"sellerIdentifier=" + this.sellerIdentifier + ", " +
				"payerIdentifierLeg1=" + this.payerIdentifierLeg1 + ", " +
				"payerIdentifierLeg2=" + this.payerIdentifierLeg2 + ", " +
				"receiverIdentifierLeg1=" + this.receiverIdentifierLeg1 + ", " +
				"receiverIdentifierLeg2=" + this.receiverIdentifierLeg2 + ", " +
				"brokerIdentifier=" + this.brokerIdentifier + ", " +
				"countryAndProvinceOrTerritoryOfIndividual=" + this.countryAndProvinceOrTerritoryOfIndividual + ", " +
				"jurisdictionOfCounterparty1=" + this.jurisdictionOfCounterparty1 + ", " +
				"jurisdictionOfCounterparty2=" + this.jurisdictionOfCounterparty2 + ", " +
				"subsequentPositionUTI=" + this.subsequentPositionUTI + ", " +
				"priorUSI=" + this.priorUSI + ", " +
				"interAffiliateIndicator=" + this.interAffiliateIndicator + ", " +
				"platformAnonymousExecutionIndicator=" + this.platformAnonymousExecutionIndicator + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"clearingMemberIdentifier=" + this.clearingMemberIdentifier + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"clearingExceptionsAndExemptionsCounterparty1=" + this.clearingExceptionsAndExemptionsCounterparty1 + ", " +
				"clearingExceptionsAndExemptionsCounterparty2=" + this.clearingExceptionsAndExemptionsCounterparty2 + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"level=" + this.level + ", " +
				"amendmentIndicator=" + this.amendmentIndicator + ", " +
				"packageIndicator=" + this.packageIndicator + ", " +
				"cryptoAssetUnderlyingIndicatorLeg1=" + this.cryptoAssetUnderlyingIndicatorLeg1 + ", " +
				"cryptoAssetUnderlyingIndicatorLeg2=" + this.cryptoAssetUnderlyingIndicatorLeg2 + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"customBasketIndicator=" + this.customBasketIndicator + ", " +
				"underlierIDOtherLeg1=" + this.underlierIDOtherLeg1 + ", " +
				"underlierIDOtherLeg2=" + this.underlierIDOtherLeg2 + ", " +
				"underlierIDOtherSourceLeg1=" + this.underlierIDOtherSourceLeg1 + ", " +
				"underlierIDOtherSourceLeg2=" + this.underlierIDOtherSourceLeg2 + ", " +
				"underlyingAssetTradingPlatformIdentifierLeg1=" + this.underlyingAssetTradingPlatformIdentifierLeg1 + ", " +
				"underlyingAssetTradingPlatformIdentifierLeg2=" + this.underlyingAssetTradingPlatformIdentifierLeg2 + ", " +
				"underlyingAssetPriceSourceLeg1=" + this.underlyingAssetPriceSourceLeg1 + ", " +
				"underlyingAssetPriceSourceLeg2=" + this.underlyingAssetPriceSourceLeg2 + ", " +
				"settlementLocation=" + this.settlementLocation + ", " +
				"exchangeRateBasisLeg1=" + this.exchangeRateBasisLeg1 + ", " +
				"nonReportable=" + this.nonReportable + ", " +
				"dtccAdditionalFields=" + this.dtccAdditionalFields +
			'}' + " " + super.toString();
		}
	}
}
