package drr.regulation.csa.rewrite.trade.functions;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.InterestRatePayout.InterestRatePayoutBuilder;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.trade.link.functions.SortIdentifiers;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(InterestRateLeg2TRSDebtandEquitySwap.InterestRateLeg2TRSDebtandEquitySwapDefault.class)
public abstract class InterestRateLeg2TRSDebtandEquitySwap implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected SortIdentifiers sortIdentifiers;

	/**
	* @param product 
	* @return _interestRateLeg2 
	*/
	public InterestRatePayout evaluate(Product product) {
		InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2Builder = doEvaluate(product);
		
		final InterestRatePayout _interestRateLeg2;
		if (interestRateLeg2Builder == null) {
			_interestRateLeg2 = null;
		} else {
			_interestRateLeg2 = interestRateLeg2Builder.build();
			objectValidator.validate(InterestRatePayout.class, _interestRateLeg2);
		}
		
		return _interestRateLeg2;
	}

	protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product);

	protected abstract MapperC<? extends InterestRatePayout> interestRateLegs(Product product);

	protected abstract MapperC<? extends InterestRatePayout> fixedRateLegs(Product product);

	protected abstract MapperC<? extends InterestRatePayout> floatingRateLegs(Product product);

	protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product);

	public static class InterestRateLeg2TRSDebtandEquitySwapDefault extends InterestRateLeg2TRSDebtandEquitySwap {
		@Override
		protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
			InterestRatePayout.InterestRatePayoutBuilder _interestRateLeg2 = InterestRatePayout.builder();
			return assignOutput(_interestRateLeg2, product);
		}
		
		protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder _interestRateLeg2, Product product) {
			if (notExists(MapperS.of(sortIdentifiers.evaluate(product, true))).getOrDefault(false)) {
				_interestRateLeg2 = toBuilder(interestRateLeg2.evaluate(product));
			} else {
				final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum = floatingRateIndexes(product).get();
				if (greaterThan(MapperS.of(floatingRateLegs(product).resultCount()), MapperS.of(0), CardinalityOperator.All).and(areEqual((fieldWithMetaFloatingRateIndexEnum == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(sortIdentifiers.evaluate(product, false)), CardinalityOperator.All)).getOrDefault(false)) {
					_interestRateLeg2 = toBuilder(floatingRateLegs(product).get());
				} else {
					_interestRateLeg2 = null;
				}
			}
			
			return Optional.ofNullable(_interestRateLeg2)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> interestRateLegs(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> fixedRateLegs(Product product) {
			return interestRateLegs(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> floatingRateLegs(Product product) {
			return interestRateLegs(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
		}
	}
}
