package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsDividendSwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsCSALeg1Aligned.IsCSALeg1AlignedDefault.class)
public abstract class IsCSALeg1Aligned implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg10;
	@Inject protected drr.regulation.csa.rewrite.trade.functions.CommodityLeg1 commodityLeg11;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected InterestRateLeg1 interestRateLeg10;
	@Inject protected drr.regulation.csa.rewrite.trade.functions.InterestRateLeg1 interestRateLeg11;
	@Inject protected IsDividendSwap isDividendSwap;
	@Inject protected PayoutMatches payoutMatches;
	@Inject protected PerformanceLeg1 performanceLeg1;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param transactionReportInstruction 
	* @return result 
	*/
	public Boolean evaluate(TransactionReportInstruction transactionReportInstruction) {
		Boolean result = doEvaluate(transactionReportInstruction);
		
		return result;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends Product> product(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends InterestRatePayout> csaInterestRateLeg1(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends InterestRatePayout> drrInterestRateLeg1(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends CommodityPayout> csaCommodityLeg1(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends CommodityPayout> drrCommodityLeg1(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends PerformancePayout> csaPerformanceLeg1(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends PerformancePayout> drrPerformanceLeg1(TransactionReportInstruction transactionReportInstruction);

	public static class IsCSALeg1AlignedDefault extends IsCSALeg1Aligned {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction transactionReportInstruction) {
			Boolean result = null;
			return assignOutput(result, transactionReportInstruction);
		}
		
		protected Boolean assignOutput(Boolean result, TransactionReportInstruction transactionReportInstruction) {
			if (ComparisonResult.of(MapperS.of(qualify_AssetClass_InterestRate.evaluate(economicTerms(transactionReportInstruction).get()))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTerms(transactionReportInstruction).get()))).and(areEqual(MapperS.of(isDividendSwap.evaluate(product(transactionReportInstruction).get())), MapperS.of(false), CardinalityOperator.All))).getOrDefault(false)) {
				result = ComparisonResult.of(MapperS.of(payoutMatches.evaluate(csaInterestRateLeg1(transactionReportInstruction).get(), drrInterestRateLeg1(transactionReportInstruction).get()))).and(ComparisonResult.of(MapperS.of(payoutMatches.evaluate(csaPerformanceLeg1(transactionReportInstruction).get(), drrPerformanceLeg1(transactionReportInstruction).get())))).get();
			} else {
				final Boolean _boolean = qualify_AssetClass_Commodity.evaluate(economicTerms(transactionReportInstruction).get());
				if ((_boolean == null ? false : _boolean)) {
					result = payoutMatches.evaluate(csaCommodityLeg1(transactionReportInstruction).get(), drrCommodityLeg1(transactionReportInstruction).get());
				} else {
					result = true;
				}
			}
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> product(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(transactionReportInstruction)));
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(economicTermsForProduct.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends InterestRatePayout> csaInterestRateLeg1(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(interestRateLeg11.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends InterestRatePayout> drrInterestRateLeg1(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(interestRateLeg10.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends CommodityPayout> csaCommodityLeg1(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(commodityLeg11.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends CommodityPayout> drrCommodityLeg1(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(commodityLeg10.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends PerformancePayout> csaPerformanceLeg1(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(performanceLeg1.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends PerformancePayout> drrPerformanceLeg1(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(economicTerms(transactionReportInstruction).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get());
		}
	}
}
