package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.PerformancePayout.PerformancePayoutBuilder;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsDividendSwap;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsTotalReturnSwapDebtUnderlier;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PerformanceLeg1.PerformanceLeg1Default.class)
public abstract class PerformanceLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsDividendSwap isDividendSwap;
	@Inject protected IsEquity isEquity;
	@Inject protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
	@Inject protected PerformanceLeg1TRSDebtandEquitySwap performanceLeg1TRSDebtandEquitySwap;

	/**
	* @param product 
	* @return performanceLeg1 
	*/
	public PerformancePayout evaluate(Product product) {
		PerformancePayout.PerformancePayoutBuilder performanceLeg1Builder = doEvaluate(product);
		
		final PerformancePayout performanceLeg1;
		if (performanceLeg1Builder == null) {
			performanceLeg1 = null;
		} else {
			performanceLeg1 = performanceLeg1Builder.build();
			objectValidator.validate(PerformancePayout.class, performanceLeg1);
		}
		
		return performanceLeg1;
	}

	protected abstract PerformancePayout.PerformancePayoutBuilder doEvaluate(Product product);

	public static class PerformanceLeg1Default extends PerformanceLeg1 {
		@Override
		protected PerformancePayout.PerformancePayoutBuilder doEvaluate(Product product) {
			PerformancePayout.PerformancePayoutBuilder performanceLeg1 = PerformancePayout.builder();
			return assignOutput(performanceLeg1, product);
		}
		
		protected PerformancePayout.PerformancePayoutBuilder assignOutput(PerformancePayout.PerformancePayoutBuilder performanceLeg1, Product product) {
			if (ComparisonResult.of(MapperS.of(isTotalReturnSwapDebtUnderlier.evaluate(product))).or(ComparisonResult.of(MapperS.of(isEquity.evaluate(product))).and(areEqual(MapperS.of(isDividendSwap.evaluate(product)), MapperS.of(false), CardinalityOperator.All))).getOrDefault(false)) {
				performanceLeg1 = toBuilder(performanceLeg1TRSDebtandEquitySwap.evaluate(product));
			} else {
				performanceLeg1 = toBuilder(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get());
			}
			
			return Optional.ofNullable(performanceLeg1)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
