package drr.regulation.csa.rewrite.trade.functions;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.PerformancePayout.PerformancePayoutBuilder;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.trade.link.functions.SortIdentifiers;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PerformanceLeg1TRSDebtandEquitySwap.PerformanceLeg1TRSDebtandEquitySwapDefault.class)
public abstract class PerformanceLeg1TRSDebtandEquitySwap implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected SortIdentifiers sortIdentifiers;

	/**
	* @param product 
	* @return performanceLeg1 
	*/
	public PerformancePayout evaluate(Product product) {
		PerformancePayout.PerformancePayoutBuilder performanceLeg1Builder = doEvaluate(product);
		
		final PerformancePayout performanceLeg1;
		if (performanceLeg1Builder == null) {
			performanceLeg1 = null;
		} else {
			performanceLeg1 = performanceLeg1Builder.build();
			objectValidator.validate(PerformancePayout.class, performanceLeg1);
		}
		
		return performanceLeg1;
	}

	protected abstract PerformancePayout.PerformancePayoutBuilder doEvaluate(Product product);

	protected abstract MapperC<? extends InterestRatePayout> interestRateLegs(Product product);

	protected abstract MapperC<? extends InterestRatePayout> fixedRateLegs(Product product);

	protected abstract MapperC<? extends InterestRatePayout> floatingRateLegs(Product product);

	protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product);

	public static class PerformanceLeg1TRSDebtandEquitySwapDefault extends PerformanceLeg1TRSDebtandEquitySwap {
		@Override
		protected PerformancePayout.PerformancePayoutBuilder doEvaluate(Product product) {
			PerformancePayout.PerformancePayoutBuilder performanceLeg1 = PerformancePayout.builder();
			return assignOutput(performanceLeg1, product);
		}
		
		protected PerformancePayout.PerformancePayoutBuilder assignOutput(PerformancePayout.PerformancePayoutBuilder performanceLeg1, Product product) {
			if (notExists(MapperS.of(sortIdentifiers.evaluate(product, true))).getOrDefault(false)) {
				performanceLeg1 = toBuilder(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get());
			} else if (greaterThan(MapperS.of(fixedRateLegs(product).resultCount()), MapperS.of(0), CardinalityOperator.All).getOrDefault(false)) {
				performanceLeg1 = null;
			} else {
				final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum = floatingRateIndexes(product).get();
				if (greaterThan(MapperS.of(floatingRateLegs(product).resultCount()), MapperS.of(0), CardinalityOperator.All).and(areEqual((fieldWithMetaFloatingRateIndexEnum == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(sortIdentifiers.evaluate(product, true)), CardinalityOperator.All)).getOrDefault(false)) {
					performanceLeg1 = null;
				} else {
					performanceLeg1 = toBuilder(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get());
				}
			}
			
			return Optional.ofNullable(performanceLeg1)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> interestRateLegs(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> fixedRateLegs(Product product) {
			return interestRateLegs(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> floatingRateLegs(Product product) {
			return interestRateLegs(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
		}
	}
}
