package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.template.PerformancePayout;
import cdm.product.template.PerformancePayout.PerformancePayoutBuilder;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.IsDividendSwap;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsTotalReturnSwapDebtUnderlier;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PerformanceLeg2.PerformanceLeg2Default.class)
public abstract class PerformanceLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected IsDividendSwap isDividendSwap;
	@Inject protected IsEquity isEquity;
	@Inject protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
	@Inject protected PerformanceLeg2TRSDebtandEquitySwap performanceLeg2TRSDebtandEquitySwap;

	/**
	* @param product 
	* @return performanceLeg2 
	*/
	public PerformancePayout evaluate(Product product) {
		PerformancePayout.PerformancePayoutBuilder performanceLeg2Builder = doEvaluate(product);
		
		final PerformancePayout performanceLeg2;
		if (performanceLeg2Builder == null) {
			performanceLeg2 = null;
		} else {
			performanceLeg2 = performanceLeg2Builder.build();
			objectValidator.validate(PerformancePayout.class, performanceLeg2);
		}
		
		return performanceLeg2;
	}

	protected abstract PerformancePayout.PerformancePayoutBuilder doEvaluate(Product product);

	public static class PerformanceLeg2Default extends PerformanceLeg2 {
		@Override
		protected PerformancePayout.PerformancePayoutBuilder doEvaluate(Product product) {
			PerformancePayout.PerformancePayoutBuilder performanceLeg2 = PerformancePayout.builder();
			return assignOutput(performanceLeg2, product);
		}
		
		protected PerformancePayout.PerformancePayoutBuilder assignOutput(PerformancePayout.PerformancePayoutBuilder performanceLeg2, Product product) {
			if (ComparisonResult.of(MapperS.of(isTotalReturnSwapDebtUnderlier.evaluate(product))).or(ComparisonResult.of(MapperS.of(isEquity.evaluate(product))).and(areEqual(MapperS.of(isDividendSwap.evaluate(product)), MapperS.of(false), CardinalityOperator.All))).getOrDefault(false)) {
				performanceLeg2 = toBuilder(performanceLeg2TRSDebtandEquitySwap.evaluate(product));
			} else {
				performanceLeg2 = null;
			}
			
			return Optional.ofNullable(performanceLeg2)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
