package drr.regulation.csa.rewrite.trade.functions;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.PerformancePayout.PerformancePayoutBuilder;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.trade.link.functions.SortIdentifiers;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PerformanceLeg2TRSDebtandEquitySwap.PerformanceLeg2TRSDebtandEquitySwapDefault.class)
public abstract class PerformanceLeg2TRSDebtandEquitySwap implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected SortIdentifiers sortIdentifiers;

	/**
	* @param product 
	* @return performanceLeg2 
	*/
	public PerformancePayout evaluate(Product product) {
		PerformancePayout.PerformancePayoutBuilder performanceLeg2Builder = doEvaluate(product);
		
		final PerformancePayout performanceLeg2;
		if (performanceLeg2Builder == null) {
			performanceLeg2 = null;
		} else {
			performanceLeg2 = performanceLeg2Builder.build();
			objectValidator.validate(PerformancePayout.class, performanceLeg2);
		}
		
		return performanceLeg2;
	}

	protected abstract PerformancePayout.PerformancePayoutBuilder doEvaluate(Product product);

	protected abstract MapperC<? extends InterestRatePayout> interestRateLegs(Product product);

	protected abstract MapperC<? extends InterestRatePayout> fixedRateLegs(Product product);

	protected abstract MapperC<? extends InterestRatePayout> floatingRateLegs(Product product);

	protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product);

	public static class PerformanceLeg2TRSDebtandEquitySwapDefault extends PerformanceLeg2TRSDebtandEquitySwap {
		@Override
		protected PerformancePayout.PerformancePayoutBuilder doEvaluate(Product product) {
			PerformancePayout.PerformancePayoutBuilder performanceLeg2 = PerformancePayout.builder();
			return assignOutput(performanceLeg2, product);
		}
		
		protected PerformancePayout.PerformancePayoutBuilder assignOutput(PerformancePayout.PerformancePayoutBuilder performanceLeg2, Product product) {
			if (notExists(MapperS.of(sortIdentifiers.evaluate(product, true))).getOrDefault(false)) {
				performanceLeg2 = null;
			} else {
				final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum = floatingRateIndexes(product).get();
				if (greaterThan(MapperS.of(floatingRateLegs(product).resultCount()), MapperS.of(0), CardinalityOperator.All).and(areEqual((fieldWithMetaFloatingRateIndexEnum == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), MapperS.of(sortIdentifiers.evaluate(product, false)), CardinalityOperator.All)).getOrDefault(false)) {
					performanceLeg2 = null;
				} else {
					performanceLeg2 = toBuilder(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get());
				}
			}
			
			return Optional.ofNullable(performanceLeg2)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> interestRateLegs(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> fixedRateLegs(Product product) {
			return interestRateLegs(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> floatingRateLegs(Product product) {
			return interestRateLegs(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
		}
	}
}
