package drr.regulation.csa.rewrite.trade.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class CSAPPDLabelProvider extends GraphBasedLabelProvider {
	public CSAPPDLabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("actionType"), "98 Action Type");
		startNode.addLabel(Arrays.asList("eventType"), "99 Event type");
		startNode.addLabel(Arrays.asList("effectiveDate"), "12 Effective date");
		startNode.addLabel(Arrays.asList("eventTimestamp"), "95 Event Timestamp");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "15 Reporting timestamp");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "14 Execution Timestamp");
		startNode.addLabel(Arrays.asList("expirationDate"), "13 Expiration date");
		startNode.addLabel(Arrays.asList("counterparty1"), "1 Counterparty 1 (reporting counterparty)");
		startNode.addLabel(Arrays.asList("counterparty2"), "2 Counterparty 2 (non-reporting counterparty)");
		startNode.addLabel(Arrays.asList("cleared"), "72 Cleared");
		startNode.addLabel(Arrays.asList("callAmount"), "28 Call amount");
		startNode.addLabel(Arrays.asList("putAmount"), "30 Put Amount");
		startNode.addLabel(Arrays.asList("callCurrency"), "29 Call currency");
		startNode.addLabel(Arrays.asList("putCurrency"), "31 Put currency");
		startNode.addLabel(Arrays.asList("priceSchedule", "price", "monetary"), "50/52-$ 52 Price in effect between the unadjusted effective and end date");
		startNode.addLabel(Arrays.asList("priceSchedule", "price", "decimal"), "50/52-$ 52 Price in effect between the unadjusted effective and end date");
		startNode.addLabel(Arrays.asList("priceSchedule", "effectiveDate"), "50/52-$ 50 Unadjusted effective date of the price");
		startNode.addLabel(Arrays.asList("priceSchedule", "endDate"), "50/52-$ 51 Unadjusted end date of the price");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "price", "monetary"), "65/67-$ 67 Strike price in effect on associated effective date");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "price", "decimal"), "65/67-$ 67 Strike price in effect on associated effective date");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "effectiveDate"), "65/67-$ 65 Effective date of the strike price");
		startNode.addLabel(Arrays.asList("strikePriceSchedule", "endDate"), "65/67-$ 66 End date of the strike price");
		startNode.addLabel(Arrays.asList("price", "decimal"), "46 Price");
		startNode.addLabel(Arrays.asList("price", "monetary"), "46 Price");
		startNode.addLabel(Arrays.asList("priceNotation"), "48 Price notation");
		startNode.addLabel(Arrays.asList("priceCurrency"), "47 Price currency");
		startNode.addLabel(Arrays.asList("packageTransactionPrice", "decimal"), "111 Package Transaction Price");
		startNode.addLabel(Arrays.asList("packageTransactionPrice", "monetary"), "111 Package Transaction Price");
		startNode.addLabel(Arrays.asList("packageTransactionPriceNotation"), "116 Package Transaction Price Notation");
		startNode.addLabel(Arrays.asList("packageTransactionPriceCurrency"), "112 Package Transaction Price Currency");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "decimal"), "113 Package Transaction Spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "monetary"), "113 Package Transaction Spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpread", "basis"), "113 Package Transaction Spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadNotation"), "115 Package Transaction Spread Notation");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadCurrency"), "114 Package Transaction Spread Currency");
		startNode.addLabel(Arrays.asList("strikePrice", "decimal"), "56 Strike price");
		startNode.addLabel(Arrays.asList("strikePrice", "monetary"), "56 Strike price");
		startNode.addLabel(Arrays.asList("strikePriceNotation"), "58 Strike price notation");
		startNode.addLabel(Arrays.asList("strikePriceCurrency"), "57 Strike price currency/currency pair");
		startNode.addLabel(Arrays.asList("priceUnitOfMeasure"), "49 Price unit of measure");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "144 Option Premium Amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "145 Option Premium Currency");
		startNode.addLabel(Arrays.asList("otherPayment", "paymentType"), "141 Other Payment Type");
		startNode.addLabel(Arrays.asList("otherPayment", "amount"), "136 Other Payment Amount");
		startNode.addLabel(Arrays.asList("otherPayment", "currency"), "137 Other Payment Currency");
		startNode.addLabel(Arrays.asList("otherPayment", "date"), "138 Other Payment Date");
		startNode.addLabel(Arrays.asList("otherPayment", "payer"), "139 Other Payment Payer");
		startNode.addLabel(Arrays.asList("otherPayment", "payerFormat"), "139 Other payment payer format (non-reportable)");
		startNode.addLabel(Arrays.asList("otherPayment", "receiver"), "140 Other Payment Receiver");
		startNode.addLabel(Arrays.asList("otherPayment", "receiverFormat"), "140 Other payment receiver format (non-reportable)");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRateDayCountConvention"), "69 Fixed Rate Day Count Convention-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateDayCountConvention"), "69 Floating Rate Day Count Convention-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "142 Fixed Rate Payment Frequency Period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "142 Floating Rate Payment Frequency Period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "143 Fixed Rate Payment Frequency Period Multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "143 Floating Rate Payment Frequency Period Multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyPeriod"), "70 Floating Rate Reset Frequency Period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "71 Floating Rate Reset Frequency Period Multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmount"), "26 Notional amount-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "effectiveDate"), "37 Effective date of the notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "endDate"), "38 End date of the notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantitySchedule", "value"), "39 Notional quantity in effect onsociated effective date-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "value"), "40 Notional amount in effect onsociated effective date-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "effectiveDate"), "41 Effective date of the notional amount-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "endDate"), "42 End date of the notional amount-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "totalNotionalQuantity"), "36 Total Notional Quantity-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantity"), "32 Notional Quantity-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixedRate"), "45 Fixed Rate-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixingDate"), "148 Fixing date-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "quantityFrequency"), "33 Quantity Frequency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "quantityFrequencyMultiplier"), "34 Quantity Frequency Multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalCurrency"), "27 Notional currency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "settlementCurrency"), "135 Settlement Currency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread", "monetary"), "53 Spread-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread", "decimal"), "53 Spread-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread", "basis"), "53 Spread-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spreadNotation"), "55 Spread Notation-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spreadCurrency"), "54 Spread Currency-Leg 1");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRateDayCountConvention"), "69 Fixed Rate Day Count Convention-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateDayCountConvention"), "69 Floating Rate Day Count Convention-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "142 Fixed Rate Payment Frequency Period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "142 Floating Rate Payment Frequency Period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "143 Fixed Rate Payment Frequency Period Multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "143 Floating Rate Payment Frequency Period Multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyPeriod"), "70 Floating Rate Reset Frequency Period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "71 Floating Rate Reset Frequency Period Multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmount"), "26 Notional amount-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "effectiveDate"), "37 Effective date of the notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "endDate"), "38 End date of the notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantitySchedule", "value"), "39 Notional quantity in effect onsociated effective date-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "value"), "40 Notional amount in effect onsociated effective date-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "effectiveDate"), "41 Effective date of the notional amount-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "endDate"), "42 End date of the notional amount-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "totalNotionalQuantity"), "36 Total Notional Quantity-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantity"), "32 Notional Quantity-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixedRate"), "45 Fixed Rate-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixingDate"), "148 Fixing date-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityFrequency"), "33 Quantity frequency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityFrequencyMultiplier"), "34 Quantity Frequency Multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalCurrency"), "27 Notional currency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "settlementCurrency"), "135 Settlement Currency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "monetary"), "53 Spread-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "decimal"), "53 Spread-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread", "basis"), "53 Spread-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spreadNotation"), "55 Spread Notation-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spreadCurrency"), "54 Spread Currency-Leg 2");
		startNode.addLabel(Arrays.asList("reportSubmittingEntityID"), "21 Submitter identifier");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifier"), "16 Unique Transaction Identifier (UTI)");
		startNode.addLabel(Arrays.asList("uniqueProductIdentifier"), "117 Unique Product Identifier");
		startNode.addLabel(Arrays.asList("platformIdentifier"), "22 Platform Identifier");
		startNode.addLabel(Arrays.asList("exchangeRate"), "43 Exchange rate");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg1"), "35 Quantity Unit of Measure-Leg 1");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg2"), "35 Quantity Unit of Measure-Leg 2");
		startNode.addLabel(Arrays.asList("embeddedOptionType"), "132 Embedded Option Type");
		startNode.addLabel(Arrays.asList("indexFactor"), "120 Index factor");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierSource"), "3 Counterparty 2 identifier source");
		startNode.addLabel(Arrays.asList("subsequentPositionUTI"), "18 Subsequent Position UTI");
		startNode.addLabel(Arrays.asList("platformAnonymousExecutionIndicator"), "23 Platform Anonymous Execution Indicator");
		startNode.addLabel(Arrays.asList("nonStandardizedTermIndicator"), "68 Non-standardized Term Indicator");
		startNode.addLabel(Arrays.asList("clearingExceptionsAndExemptionsCounterparty1"), "77-$ Clearing exceptions and exemptions - Counterparty 1");
		startNode.addLabel(Arrays.asList("amendmentIndicator"), "100 Amendment Indicator");
		startNode.addLabel(Arrays.asList("packageIndicator"), "109 Package Indicator");
		startNode.addLabel(Arrays.asList("customBasketIndicator"), "123 Custom Basket Indicator");
		startNode.addLabel(Arrays.asList("settlementLocation"), "134 Settlement Location");
		startNode.addLabel(Arrays.asList("exchangeRateBasisLeg1"), "44 Exchange rate basis");
		
		LabelNode cSANonReportableNode = new LabelNode();
		cSANonReportableNode.addLabel(Arrays.asList("enrichment"), "Enrichment Data");
		cSANonReportableNode.addLabel(Arrays.asList("preUpiData"), "Upi Pre-Enrichment Data");
		cSANonReportableNode.addLabel(Arrays.asList("postUpiData"), "Upi Post-Enrichment Data");
		cSANonReportableNode.addLabel(Arrays.asList("instrumentType"), "Instrument Type (non-reportable)");
		cSANonReportableNode.addLabel(Arrays.asList("notionalSchedule"), "Notional Schedule (non-reportable)");
		cSANonReportableNode.addLabel(Arrays.asList("underlyingAssetType"), "Underlying Asset Type (non-reportable)");
		cSANonReportableNode.addLabel(Arrays.asList("returnorPayoutTrigger"), "Return or Payout Trigger (non-reportable)");
		
		LabelNode dTCCAdditionalFieldsNode = new LabelNode();
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1IDType"), "Trade Party 1 - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("submittingPartyIDType"), "Submitting Party - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("usiID"), "USI ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("usiIDPrefix"), "USI ID Prefix");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("submittedForParty"), "Submitted For Party");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeLegTypes"), "Trade Leg Types");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1ReportingDestination"), "Trade Party 1 - Reporting Destination");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("primaryAssetClass"), "Primary Asset Class");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("comment1"), "Comment 1");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("messageID"), "Message ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("messageTypePPD"), "Message Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("optionStyle"), "Option Style");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("optionType"), "Option Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("productID"), "Product ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty2ExecutionAgentID"), "Trade Party 2 - Execution Agent ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty2ExecutionAgentIDType"), "Trade Party 2 - Execution Agent ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1ExecutionAgentID"), "Trade Party 1 - Execution Agent ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1ExecutionAgentIDType"), "Trade Party 1 - Execution Agent ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1TransactionID"), "Trade Party 1 - Transaction ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("versionPPD"), "Version (PPD report)");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("leg1CommodityUnderlyerID"), "Leg 1 - Commodity Underlyer ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("leg2CommodityUnderlyerID"), "Leg 2 - Commodity Underlyer ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("leg1FloatingRateIndex"), "Leg 1 - Floating Rate Index");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("leg2FloatingRateIndex"), "Leg 2 - Floating Rate Index");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("underlyingAssetName"), "Underlying Asset Name");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("settlementType"), "Settlement Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("deliveryLocation"), "Delivery Location");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("leg1CommodityInstrumentID"), "Leg 1 - Commodity Instrument ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("leg2CommodityInstrumentID"), "Leg 2 - Commodity Instrument ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("responsibleDataSubmitterIDType"), "Responsible Data Submitter - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("responsibleDataSubmitterID"), "Responsible Data Submitter - ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("maturityDateOfTheUnderlying"), "Maturity Date of the Underlier");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("corporateActionNewTradeParty1Lei"), "Corporate Action - New Trade Party 1 LEI");
		
		startNode.addOutgoingEdge("nonReportable", cSANonReportableNode);
		startNode.addOutgoingEdge("dtccAdditionalFields", dTCCAdditionalFieldsNode);
	}
}
