package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iso.ActionTypeEnum;
import javax.inject.Inject;


@ImplementedBy(ActionTypeRule.ActionTypeRuleDefault.class)
public abstract class ActionTypeRule implements ReportFunction<TransactionReportInstruction, ActionTypeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.event.reports.ActionTypeRule actionTypeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ActionTypeEnum evaluate(TransactionReportInstruction input) {
		ActionTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ActionTypeEnum doEvaluate(TransactionReportInstruction input);

	public static class ActionTypeRuleDefault extends ActionTypeRule {
		@Override
		protected ActionTypeEnum doEvaluate(TransactionReportInstruction input) {
			ActionTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ActionTypeEnum assignOutput(ActionTypeEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(actionTypeRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
