package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(CDSIndexDetachmentPointRule.CDSIndexDetachmentPointRuleDefault.class)
public abstract class CDSIndexDetachmentPointRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.index.reports.CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class CDSIndexDetachmentPointRuleDefault extends CDSIndexDetachmentPointRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCreditDefaultSwap.evaluate(productForEvent.evaluate(item.get()));
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(cDSIndexDetachmentPointRule.evaluate(item.get()));
					}
					return MapperS.<BigDecimal>ofNull();
				}).get();
			
			return output;
		}
	}
}
