package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_AllocationTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ClearingVenueIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Comment1Rule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_CorporateActionNewTradeParty1LEIRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_DeliveryLocationRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ExecutionVenueIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ExecutionVenueIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1CommodityInstrumentIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1CommodityUnderlyerIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1FloatingRateIndexRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1SettlementPeriodRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2CommodityInstrumentIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2CommodityUnderlyerIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg2FloatingRateIndexRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_LoadTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_MaturityDateOfTheUnderlyingRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_MessageIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_MessageTypeTransactionRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_NewSDRIdentifierRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_OptionStyleRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_OptionTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_OtherPaymentPayerIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_OtherPaymentReceiverIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_PrimaryAssetClassRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ProductGradeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ProductIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ResponsibleDataSubmitterIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ResponsibleDataSubmitterIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_SecondaryAssetClassRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_SettlementTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_SubmittedForPartyRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_SubmittingPartyIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeLegTypesRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1BrokerIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1ClearingBrokerIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1ExecutionAgentIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1ExecutionAgentIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1IDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1ReportingDestinationRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1TransactionIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty2ExecutionAgentIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty2ExecutionAgentIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty2ReportingDestinationRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_USIIDPrefixRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_USIIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_UnderlyingAssetNameRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_UnderlyingAssetReportRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_VersionTransactionRule;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.regulation.csa.rewrite.trade.CSATransactionReport.CSATransactionReportBuilder;
import drr.regulation.csa.rewrite.trade.labels.CSATradeLabelProvider;
import drr.standards.iosco.cde.price.reports.FirstExerciseDateRule;
import drr.standards.iosco.cde.settlement.reports.FinalContractualSettlementDateRule;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.csa.rewrite.trade", body="CSA", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=CSATradeLabelProvider.class)
@ImplementedBy(CSATradeReportFunction.CSATradeReportFunctionDefault.class)
public abstract class CSATradeReportFunction implements ReportFunction<TransactionReportInstruction, CSATransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AmendmentIndicatorRule amendmentIndicatorRule;
	@Inject protected BasketConstituentsRule basketConstituentsRule;
	@Inject protected BrokerIdentifierRule brokerIdentifierRule;
	@Inject protected BuyerIdentifierRule buyerIdentifierRule;
	@Inject protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
	@Inject protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected CentralCounterpartyIdentifierRule centralCounterpartyIdentifierRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingAccountOriginRule clearingAccountOriginRule;
	@Inject protected ClearingExceptionsAndExemptionsCounterparty1Rule clearingExceptionsAndExemptionsCounterparty1Rule;
	@Inject protected ClearingExceptionsAndExemptionsCounterparty2Rule clearingExceptionsAndExemptionsCounterparty2Rule;
	@Inject protected ClearingMemberIdentifierRule clearingMemberIdentifierRule;
	@Inject protected ClearingReceiptTimestampRule clearingReceiptTimestampRule;
	@Inject protected ContractPriceScheduleRule contractPriceScheduleRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CountryAndProvinceOrTerritoryOfIndividualRule countryAndProvinceOrTerritoryOfIndividualRule;
	@Inject protected CryptoAssetUnderlyingIndicatorLeg1Rule cryptoAssetUnderlyingIndicatorLeg1Rule;
	@Inject protected CryptoAssetUnderlyingIndicatorLeg2Rule cryptoAssetUnderlyingIndicatorLeg2Rule;
	@Inject protected CustomBasketCodeRule customBasketCodeRule;
	@Inject protected CustomBasketIndicatorRule customBasketIndicatorRule;
	@Inject protected DTCC_AllocationTypeRule dTCC_AllocationTypeRule;
	@Inject protected DTCC_ClearingVenueIDTypeRule dTCC_ClearingVenueIDTypeRule;
	@Inject protected DTCC_Comment1Rule dTCC_Comment1Rule;
	@Inject protected DTCC_CorporateActionNewTradeParty1LEIRule dTCC_CorporateActionNewTradeParty1LEIRule;
	@Inject protected DTCC_DeliveryLocationRule dTCC_DeliveryLocationRule;
	@Inject protected DTCC_ExecutionVenueIDRule dTCC_ExecutionVenueIDRule;
	@Inject protected DTCC_ExecutionVenueIDTypeRule dTCC_ExecutionVenueIDTypeRule;
	@Inject protected DTCC_Leg1CommodityInstrumentIDRule dTCC_Leg1CommodityInstrumentIDRule;
	@Inject protected DTCC_Leg1CommodityUnderlyerIDRule dTCC_Leg1CommodityUnderlyerIDRule;
	@Inject protected DTCC_Leg1FloatingRateIndexRule dTCC_Leg1FloatingRateIndexRule;
	@Inject protected DTCC_Leg1SettlementPeriodRule dTCC_Leg1SettlementPeriodRule;
	@Inject protected DTCC_Leg2CommodityInstrumentIDRule dTCC_Leg2CommodityInstrumentIDRule;
	@Inject protected DTCC_Leg2CommodityUnderlyerIDRule dTCC_Leg2CommodityUnderlyerIDRule;
	@Inject protected DTCC_Leg2FloatingRateIndexRule dTCC_Leg2FloatingRateIndexRule;
	@Inject protected DTCC_LoadTypeRule dTCC_LoadTypeRule;
	@Inject protected DTCC_MaturityDateOfTheUnderlyingRule dTCC_MaturityDateOfTheUnderlyingRule;
	@Inject protected DTCC_MessageIDRule dTCC_MessageIDRule;
	@Inject protected DTCC_MessageTypeTransactionRule dTCC_MessageTypeTransactionRule;
	@Inject protected DTCC_NewSDRIdentifierRule dTCC_NewSDRIdentifierRule;
	@Inject protected DTCC_OptionStyleRule dTCC_OptionStyleRule;
	@Inject protected DTCC_OptionTypeRule dTCC_OptionTypeRule;
	@Inject protected DTCC_OtherPaymentPayerIDTypeRule dTCC_OtherPaymentPayerIDTypeRule;
	@Inject protected DTCC_OtherPaymentReceiverIDTypeRule dTCC_OtherPaymentReceiverIDTypeRule;
	@Inject protected DTCC_PrimaryAssetClassRule dTCC_PrimaryAssetClassRule;
	@Inject protected DTCC_ProductGradeRule dTCC_ProductGradeRule;
	@Inject protected DTCC_ProductIDRule dTCC_ProductIDRule;
	@Inject protected DTCC_ResponsibleDataSubmitterIDRule dTCC_ResponsibleDataSubmitterIDRule;
	@Inject protected DTCC_ResponsibleDataSubmitterIDTypeRule dTCC_ResponsibleDataSubmitterIDTypeRule;
	@Inject protected DTCC_SecondaryAssetClassRule dTCC_SecondaryAssetClassRule;
	@Inject protected DTCC_SettlementTypeRule dTCC_SettlementTypeRule;
	@Inject protected DTCC_SubmittedForPartyRule dTCC_SubmittedForPartyRule;
	@Inject protected DTCC_SubmittingPartyIDTypeRule dTCC_SubmittingPartyIDTypeRule;
	@Inject protected DTCC_TradeLegTypesRule dTCC_TradeLegTypesRule;
	@Inject protected DTCC_TradeParty1BrokerIDTypeRule dTCC_TradeParty1BrokerIDTypeRule;
	@Inject protected DTCC_TradeParty1ClearingBrokerIDTypeRule dTCC_TradeParty1ClearingBrokerIDTypeRule;
	@Inject protected DTCC_TradeParty1ExecutionAgentIDRule dTCC_TradeParty1ExecutionAgentIDRule;
	@Inject protected DTCC_TradeParty1ExecutionAgentIDTypeRule dTCC_TradeParty1ExecutionAgentIDTypeRule;
	@Inject protected DTCC_TradeParty1IDTypeRule dTCC_TradeParty1IDTypeRule;
	@Inject protected DTCC_TradeParty1ReportingDestinationRule dTCC_TradeParty1ReportingDestinationRule;
	@Inject protected DTCC_TradeParty1TransactionIDRule dTCC_TradeParty1TransactionIDRule;
	@Inject protected DTCC_TradeParty2ExecutionAgentIDRule dTCC_TradeParty2ExecutionAgentIDRule;
	@Inject protected DTCC_TradeParty2ExecutionAgentIDTypeRule dTCC_TradeParty2ExecutionAgentIDTypeRule;
	@Inject protected DTCC_TradeParty2ReportingDestinationRule dTCC_TradeParty2ReportingDestinationRule;
	@Inject protected DTCC_USIIDPrefixRule dTCC_USIIDPrefixRule;
	@Inject protected DTCC_USIIDRule dTCC_USIIDRule;
	@Inject protected DTCC_UnderlyingAssetNameRule dTCC_UnderlyingAssetNameRule;
	@Inject protected DTCC_UnderlyingAssetReportRule dTCC_UnderlyingAssetReportRule;
	@Inject protected DTCC_VersionTransactionRule dTCC_VersionTransactionRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EmbeddedOptionTypeRule embeddedOptionTypeRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EventIdentifierRule eventIdentifierRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected InstrumentTypeRule instrumentTypeRule;
	@Inject protected InterAffiliateIndicatorRule interAffiliateIndicatorRule;
	@Inject protected JurisdictionOfCounterparty1Rule jurisdictionOfCounterparty1Rule;
	@Inject protected JurisdictionOfCounterparty2Rule jurisdictionOfCounterparty2Rule;
	@Inject protected Leg1ReportRule leg1ReportRule;
	@Inject protected Leg2ReportRule leg2ReportRule;
	@Inject protected LevelRule levelRule;
	@Inject protected MasterAgreementTypeRule masterAgreementTypeRule;
	@Inject protected MasterAgreementVersionRule masterAgreementVersionRule;
	@Inject protected NonStandardizedTermIndicatorRule nonStandardizedTermIndicatorRule;
	@Inject protected NotionalScheduleRule notionalScheduleRule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PackageIndicatorRule packageIndicatorRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionPriceRule packageTransactionPriceRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PackageTransactionSpreadRule packageTransactionSpreadRule;
	@Inject protected PayerIdentifierLeg1Rule payerIdentifierLeg1Rule;
	@Inject protected PayerIdentifierLeg2Rule payerIdentifierLeg2Rule;
	@Inject protected PlatformAnonymousExecutionIndicatorRule platformAnonymousExecutionIndicatorRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceRule priceRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PriorUSIRule priorUSIRule;
	@Inject protected PriorUTIRule priorUTIRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected ReceiverIdentifierLeg1Rule receiverIdentifierLeg1Rule;
	@Inject protected ReceiverIdentifierLeg2Rule receiverIdentifierLeg2Rule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected ReturnorPayoutTriggerRule returnorPayoutTriggerRule;
	@Inject protected SellerIdentifierRule sellerIdentifierRule;
	@Inject protected SettlementLocationRule settlementLocationRule;
	@Inject protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceRule strikePriceRule;
	@Inject protected StrikePriceScheduleRule strikePriceScheduleRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected SubsequentPositionUTIRule subsequentPositionUTIRule;
	@Inject protected UnderlierIDOtherLeg1Rule underlierIDOtherLeg1Rule;
	@Inject protected UnderlierIDOtherLeg2Rule underlierIDOtherLeg2Rule;
	@Inject protected UnderlierIDOtherSourceLeg1Rule underlierIDOtherSourceLeg1Rule;
	@Inject protected UnderlierIDOtherSourceLeg2Rule underlierIDOtherSourceLeg2Rule;
	@Inject protected UnderlyingAssetPriceSourceLeg1Rule underlyingAssetPriceSourceLeg1Rule;
	@Inject protected UnderlyingAssetPriceSourceLeg2Rule underlyingAssetPriceSourceLeg2Rule;
	@Inject protected UnderlyingAssetTradingPlatformIdentifierLeg1Rule underlyingAssetTradingPlatformIdentifierLeg1Rule;
	@Inject protected UnderlyingAssetTradingPlatformIdentifierLeg2Rule underlyingAssetTradingPlatformIdentifierLeg2Rule;
	@Inject protected UnderlyingAssetTypeRule underlyingAssetTypeRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
	@Inject protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CSATransactionReport evaluate(TransactionReportInstruction input) {
		CSATransactionReport.CSATransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final CSATransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CSATransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract CSATransactionReport.CSATransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class CSATradeReportFunctionDefault extends CSATradeReportFunction {
		@Override
		protected CSATransactionReport.CSATransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			CSATransactionReport.CSATransactionReportBuilder output = CSATransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected CSATransactionReport.CSATransactionReportBuilder assignOutput(CSATransactionReport.CSATransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEventIdentifier(eventIdentifierRule.evaluate(input));
			
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyIdentifierRule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setPriceSchedule(contractPriceScheduleRule.evaluate(input));
			
			output
				.setStrikePriceSchedule(strikePriceScheduleRule.evaluate(input));
			
			output
				.setPrice(priceRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPrice(packageTransactionPriceRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpread(packageTransactionSpreadRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyCurrencyPairRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setOptionPremiumPaymentDate(optionPremiumPaymentDateRule.evaluate(input));
			
			output
				.setCdSIndexAttachmentPoint(cDSIndexAttachmentPointRule.evaluate(input));
			
			output
				.setCdSIndexDetachmentPoint(cDSIndexDetachmentPointRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setFinalContractualSettlementDate(finalContractualSettlementDateRule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.setLeg1(leg1ReportRule.evaluate(input));
			
			output
				.setLeg2(leg2ReportRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(submitterIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setPriorUTI(priorUTIRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setBasketConstituents(basketConstituentsRule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg1(quantityUnitOfMeasureLeg1Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg2(quantityUnitOfMeasureLeg2Rule.evaluate(input));
			
			output
				.setEmbeddedOptionType(embeddedOptionTypeRule.evaluate(input));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			output
				.setCounterparty2IdentifierSource(counterparty2IdentifierSourceRule.evaluate(input));
			
			output
				.setBuyerIdentifier(buyerIdentifierRule.evaluate(input));
			
			output
				.setSellerIdentifier(sellerIdentifierRule.evaluate(input));
			
			output
				.setPayerIdentifierLeg1(payerIdentifierLeg1Rule.evaluate(input));
			
			output
				.setPayerIdentifierLeg2(payerIdentifierLeg2Rule.evaluate(input));
			
			output
				.setReceiverIdentifierLeg1(receiverIdentifierLeg1Rule.evaluate(input));
			
			output
				.setReceiverIdentifierLeg2(receiverIdentifierLeg2Rule.evaluate(input));
			
			output
				.setBrokerIdentifier(brokerIdentifierRule.evaluate(input));
			
			output
				.setCountryAndProvinceOrTerritoryOfIndividual(countryAndProvinceOrTerritoryOfIndividualRule.evaluate(input));
			
			output
				.setJurisdictionOfCounterparty1(jurisdictionOfCounterparty1Rule.evaluate(input));
			
			output
				.setJurisdictionOfCounterparty2(jurisdictionOfCounterparty2Rule.evaluate(input));
			
			output
				.setSubsequentPositionUTI(subsequentPositionUTIRule.evaluate(input));
			
			output
				.setPriorUSI(priorUSIRule.evaluate(input));
			
			output
				.setInterAffiliateIndicator(interAffiliateIndicatorRule.evaluate(input));
			
			output
				.setPlatformAnonymousExecutionIndicator(platformAnonymousExecutionIndicatorRule.evaluate(input));
			
			output
				.setMasterAgreementType(masterAgreementTypeRule.evaluate(input));
			
			output
				.setMasterAgreementVersion(masterAgreementVersionRule.evaluate(input));
			
			output
				.setNonStandardizedTermIndicator(nonStandardizedTermIndicatorRule.evaluate(input));
			
			output
				.setClearingAccountOrigin(clearingAccountOriginRule.evaluate(input));
			
			output
				.setClearingMemberIdentifier(clearingMemberIdentifierRule.evaluate(input));
			
			output
				.setClearingReceiptTimestamp(clearingReceiptTimestampRule.evaluate(input));
			
			output
				.setClearingExceptionsAndExemptionsCounterparty1(clearingExceptionsAndExemptionsCounterparty1Rule.evaluate(input));
			
			output
				.setClearingExceptionsAndExemptionsCounterparty2(clearingExceptionsAndExemptionsCounterparty2Rule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setLevel(levelRule.evaluate(input));
			
			output
				.setAmendmentIndicator(amendmentIndicatorRule.evaluate(input));
			
			output
				.setPackageIndicator(packageIndicatorRule.evaluate(input));
			
			output
				.setCryptoAssetUnderlyingIndicatorLeg1(cryptoAssetUnderlyingIndicatorLeg1Rule.evaluate(input));
			
			output
				.setCryptoAssetUnderlyingIndicatorLeg2(cryptoAssetUnderlyingIndicatorLeg2Rule.evaluate(input));
			
			output
				.setCustomBasketCode(customBasketCodeRule.evaluate(input));
			
			output
				.setCustomBasketIndicator(customBasketIndicatorRule.evaluate(input));
			
			output
				.setUnderlierIDOtherLeg1(underlierIDOtherLeg1Rule.evaluate(input));
			
			output
				.setUnderlierIDOtherLeg2(underlierIDOtherLeg2Rule.evaluate(input));
			
			output
				.setUnderlierIDOtherSourceLeg1(underlierIDOtherSourceLeg1Rule.evaluate(input));
			
			output
				.setUnderlierIDOtherSourceLeg2(underlierIDOtherSourceLeg2Rule.evaluate(input));
			
			output
				.setUnderlyingAssetTradingPlatformIdentifierLeg1(underlyingAssetTradingPlatformIdentifierLeg1Rule.evaluate(input));
			
			output
				.setUnderlyingAssetTradingPlatformIdentifierLeg2(underlyingAssetTradingPlatformIdentifierLeg2Rule.evaluate(input));
			
			output
				.setUnderlyingAssetPriceSourceLeg1(underlyingAssetPriceSourceLeg1Rule.evaluate(input));
			
			output
				.setUnderlyingAssetPriceSourceLeg2(underlyingAssetPriceSourceLeg2Rule.evaluate(input));
			
			output
				.setSettlementLocation(settlementLocationRule.evaluate(input));
			
			output
				.setExchangeRateBasisLeg1(exchangeRateBasisRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPreUpiData(upiPreEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPostUpiData(upiPostEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setInstrumentType(instrumentTypeRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setNotionalSchedule(notionalScheduleRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setUnderlyingAssetType(underlyingAssetTypeRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setReturnorPayoutTrigger(returnorPayoutTriggerRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setClearingVenueIDType(dTCC_ClearingVenueIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ClearingBrokerIDType(dTCC_TradeParty1ClearingBrokerIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1IDType(dTCC_TradeParty1IDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSubmittingPartyIDType(dTCC_SubmittingPartyIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setAllocationType(dTCC_AllocationTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUsiID(dTCC_USIIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUsiIDPrefix(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setNewSDRIdentifier(dTCC_NewSDRIdentifierRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSubmittedForParty(dTCC_SubmittedForPartyRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeLegTypes(dTCC_TradeLegTypesRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ReportingDestination(dTCC_TradeParty1ReportingDestinationRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty2ReportingDestination(dTCC_TradeParty2ReportingDestinationRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setPrimaryAssetClass(dTCC_PrimaryAssetClassRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSecondaryAssetClass(dTCC_SecondaryAssetClassRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setComment1(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setMessageID(dTCC_MessageIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setMessageTypeTransaction(dTCC_MessageTypeTransactionRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOptionStyle(dTCC_OptionStyleRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOptionType(dTCC_OptionTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setProductID(dTCC_ProductIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty2ExecutionAgentID(dTCC_TradeParty2ExecutionAgentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty2ExecutionAgentIDType(dTCC_TradeParty2ExecutionAgentIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ExecutionAgentID(dTCC_TradeParty1ExecutionAgentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ExecutionAgentIDType(dTCC_TradeParty1ExecutionAgentIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1TransactionID(dTCC_TradeParty1TransactionIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setVersionTransaction(dTCC_VersionTransactionRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg1CommodityUnderlyerID(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg2CommodityUnderlyerID(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg1FloatingRateIndex(dTCC_Leg1FloatingRateIndexRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg2FloatingRateIndex(dTCC_Leg2FloatingRateIndexRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUnderlyingAsset(dTCC_UnderlyingAssetReportRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUnderlyingAssetName(dTCC_UnderlyingAssetNameRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSettlementType(dTCC_SettlementTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setExecutionVenueID(dTCC_ExecutionVenueIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setExecutionVenueIDType(dTCC_ExecutionVenueIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setProductGrade(Collections.<String>emptyList());
			
			output
				.getOrCreateDtccAdditionalFields()
				.setDeliveryLocation(dTCC_DeliveryLocationRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg1SettlementPeriod(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLoadType(dTCC_LoadTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1BrokerIDType(dTCC_TradeParty1BrokerIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg1CommodityInstrumentID(dTCC_Leg1CommodityInstrumentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg2CommodityInstrumentID(dTCC_Leg2CommodityInstrumentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setResponsibleDataSubmitterIDType(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setResponsibleDataSubmitterID(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setMaturityDateOfTheUnderlying(dTCC_MaturityDateOfTheUnderlyingRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setCorporateActionNewTradeParty1Lei(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOtherPaymentPayerIDType(dTCC_OtherPaymentPayerIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOtherPaymentReceiverIDType(dTCC_OtherPaymentReceiverIDTypeRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
