package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg1Aligned;
import drr.standards.iosco.cde.party.reports.Counterparty2Rule;
import javax.inject.Inject;


@ImplementedBy(Counterparty1Rule.Counterparty1RuleDefault.class)
public abstract class Counterparty1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.party.reports.Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected IsCSALeg1Aligned isCSALeg1Aligned;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class Counterparty1RuleDefault extends Counterparty1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final Boolean _boolean = isCSALeg1Aligned.evaluate(input);
			if ((_boolean == null ? false : _boolean)) {
				output = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of(counterparty1Rule.evaluate(item.get()))).get();
			} else {
				output = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of(counterparty2Rule.evaluate(item.get()))).get();
			}
			
			return output;
		}
	}
}
