package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg2Aligned;
import drr.standards.iosco.cde.party.reports.Counterparty1Rule;
import javax.inject.Inject;


@ImplementedBy(Counterparty2Rule.Counterparty2RuleDefault.class)
public abstract class Counterparty2Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected drr.standards.iosco.cde.party.reports.Counterparty2Rule counterparty2Rule;
	@Inject protected IsCSALeg2Aligned isCSALeg2Aligned;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class Counterparty2RuleDefault extends Counterparty2Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final Boolean _boolean = isCSALeg2Aligned.evaluate(input);
			if ((_boolean == null ? false : _boolean)) {
				output = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of(counterparty2Rule.evaluate(item.get()))).get();
			} else {
				output = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of(counterparty1Rule.evaluate(item.get()))).get();
			}
			
			return output;
		}
	}
}
