package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CSAPartyInformation;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.SupervisoryBodyForCSA;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(JurisdictionOfCounterparty1Rule.JurisdictionOfCounterparty1RuleDefault.class)
public abstract class JurisdictionOfCounterparty1Rule implements ReportFunction<TransactionReportInstruction, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected SupervisoryBodyForCSA supervisoryBodyForCSA;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(TransactionReportInstruction input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(TransactionReportInstruction input);

	public static class JurisdictionOfCounterparty1RuleDefault extends JurisdictionOfCounterparty1Rule {
		@Override
		protected List<String> doEvaluate(TransactionReportInstruction input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			output = thenArg
				.mapSingleToList(transactionReportInstruction -> {
					final MapperC<PartyInformation> thenArg0 = thenArg.<ReportableInformation>map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation());
					final MapperC<PartyInformation> thenArg1 = thenArg0
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), transactionReportInstruction.<ReportingSide>map("getReportingSide", _transactionReportInstruction -> _transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					final MapperC<String> ifThenElseResult;
					if (notEqual(thenArg1.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<CSAPartyInformation>map("getCsaPartyInformation", reportingRegime -> reportingRegime.getCsaPartyInformation()).<Boolean>map("getLocalCounterparty", cSAPartyInformation -> cSAPartyInformation.getLocalCounterparty()), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult = thenArg1
							.mapItem(item -> MapperS.of("NON-CA"));
					} else {
						final MapperC<ReportingRegime> thenArg2 = thenArg1.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation());
						final MapperC<String> thenArg3 = thenArg2
							.mapItem(item -> {
								if (areEqual(item.<CSAPartyInformation>map("getCsaPartyInformation", reportingRegime -> reportingRegime.getCsaPartyInformation()).<Boolean>map("getLocalCounterparty", cSAPartyInformation -> cSAPartyInformation.getLocalCounterparty()), MapperS.of(true), CardinalityOperator.All).and(areEqual(MapperC.<SupervisoryBodyEnum>of(supervisoryBodyForCSA.evaluate()), item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), CardinalityOperator.Any)).getOrDefault(false)) {
									return item
										.mapSingleToItem(_item -> _item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", _fieldWithMetaSupervisoryBodyEnum -> _fieldWithMetaSupervisoryBodyEnum == null ? null : _fieldWithMetaSupervisoryBodyEnum.getValue()).map("to-string", SupervisoryBodyEnum::toDisplayString));
								}
								return MapperS.<String>ofNull();
							});
						ifThenElseResult = distinct(thenArg3);
					}
					return ifThenElseResult;
				}).getMulti();
			
			return output;
		}
	}
}
