package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg1Rule;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg2Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodLeg1Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodLeg2Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierLeg1Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierLeg2Rule;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg1;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg2;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg1Rule;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg2Rule;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg2Aligned;
import drr.standards.iosco.cde.functions.Leg1;
import drr.standards.iosco.cde.functions.Leg2;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountScheduleLeg2Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalQuantityScheduleLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalQuantityScheduleLeg2Rule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Leg2ReportRule.Leg2ReportRuleDefault.class)
public abstract class Leg2ReportRule implements ReportFunction<TransactionReportInstruction, CommonLeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FixingDateLeg1Rule fixingDateLeg1Rule;
	@Inject protected FixingDateLeg2Rule fixingDateLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg1Rule floatingRateResetFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg2Rule floatingRateResetFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg1Rule floatingRateResetFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg2Rule floatingRateResetFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSALeg2Aligned isCSALeg2Aligned;
	@Inject protected Leg1 leg1;
	@Inject protected Leg2 leg2;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
	@Inject protected QuantityFrequencyLeg1 quantityFrequencyLeg1;
	@Inject protected QuantityFrequencyLeg2 quantityFrequencyLeg2;
	@Inject protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonLeg evaluate(TransactionReportInstruction input) {
		CommonLeg.CommonLegBuilder outputBuilder = doEvaluate(input);
		
		final CommonLeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CommonLeg.class, output);
		}
		
		return output;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg2ReportRuleDefault extends Leg2ReportRule {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
			CommonLeg.CommonLegBuilder output = CommonLeg.builder();
			return assignOutput(output, input);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final Boolean _boolean = isCSALeg2Aligned.evaluate(thenArg.get());
			final MapperS<CommonLeg> ifThenElseResult;
			if ((_boolean == null ? false : _boolean)) {
				ifThenElseResult = MapperS.of(legEnrichment.evaluate(leg2.evaluate(thenArg.get(), spreadNotationLeg2Rule.evaluate(thenArg.get())), notionalAmountScheduleLeg2Rule.evaluate(thenArg.get()), notionalQuantityScheduleLeg2Rule.evaluate(thenArg.get()), notionalQuantityLeg2Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodLeg2Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodMultiplierLeg2Rule.evaluate(thenArg.get()), fixingDateLeg2Rule.evaluate(thenArg.get()), MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, null, null, null, null));
			} else {
				ifThenElseResult = MapperS.of(legEnrichment.evaluate(leg1.evaluate(thenArg.get(), spreadNotationLeg2Rule.evaluate(thenArg.get())), notionalAmountScheduleLeg1Rule.evaluate(thenArg.get()), notionalQuantityScheduleLeg1Rule.evaluate(thenArg.get()), notionalQuantityLeg1Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodLeg1Rule.evaluate(thenArg.get()), floatingRateResetFrequencyPeriodMultiplierLeg1Rule.evaluate(thenArg.get()), fixingDateLeg1Rule.evaluate(thenArg.get()), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, null, null, null, null));
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
