package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.standards.iso.ReportLevelEnum;
import javax.inject.Inject;


@ImplementedBy(LevelRule.LevelRuleDefault.class)
public abstract class LevelRule implements ReportFunction<ReportableEvent, ReportLevelEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected drr.standards.iosco.cde.event.reports.LevelRule levelRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ReportLevelEnum evaluate(ReportableEvent input) {
		ReportLevelEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ReportLevelEnum doEvaluate(ReportableEvent input);

	public static class LevelRuleDefault extends LevelRule {
		@Override
		protected ReportLevelEnum doEvaluate(ReportableEvent input) {
			ReportLevelEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ReportLevelEnum assignOutput(ReportLevelEnum output, ReportableEvent input) {
			final MapperS<ReportableEvent> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(levelRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
