package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PartyLeiAndPersonByRoles;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg1Aligned;
import drr.standards.iosco.cde.party.functions.Direction2PayerPartyLeg1;
import drr.standards.iosco.cde.party.functions.Direction2PayerPartyLeg2;
import javax.inject.Inject;


@ImplementedBy(PayerIdentifierLeg1Rule.PayerIdentifierLeg1RuleDefault.class)
public abstract class PayerIdentifierLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Direction2PayerPartyLeg1 direction2PayerPartyLeg1;
	@Inject protected Direction2PayerPartyLeg2 direction2PayerPartyLeg2;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSALeg1Aligned isCSALeg1Aligned;
	@Inject protected PartyLeiAndPersonByRoles partyLeiAndPersonByRoles;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PayerIdentifierLeg1RuleDefault extends PayerIdentifierLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCSALeg1Aligned.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						final ReferenceWithMetaParty referenceWithMetaParty0 = item.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
						return MapperS.of(partyLeiAndPersonByRoles.evaluate(direction2PayerPartyLeg1.evaluate(item.get()), (referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue())));
					}
					final ReferenceWithMetaParty referenceWithMetaParty1 = item.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
					return MapperS.of(partyLeiAndPersonByRoles.evaluate(direction2PayerPartyLeg2.evaluate(item.get()), (referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue())));
				}).get();
			
			return output;
		}
	}
}
