package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg1Aligned;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.reports.SpreadLeg1NotationEnumRule;
import drr.standards.iosco.cde.price.reports.SpreadLeg2NotationEnumRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SpreadNotationLeg1Rule.SpreadNotationLeg1RuleDefault.class)
public abstract class SpreadNotationLeg1Rule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCSALeg1Aligned isCSALeg1Aligned;
	@Inject protected SpreadLeg1NotationEnumRule spreadLeg1NotationEnumRule;
	@Inject protected SpreadLeg2NotationEnumRule spreadLeg2NotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadNotationLeg1RuleDefault extends SpreadNotationLeg1Rule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCSALeg1Aligned.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						if (areEqual(MapperS.of(spreadLeg1NotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of(PriceNotationEnum.DECIMAL);
						}
						return MapperS.of(spreadLeg1NotationEnumRule.evaluate(item.get()));
					}
					if (areEqual(MapperS.of(spreadLeg2NotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(PriceNotationEnum.DECIMAL);
					}
					return MapperS.of(spreadLeg2NotationEnumRule.evaluate(item.get()));
				}).get();
			
			return output;
		}
	}
}
