package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg2Aligned;
import drr.standards.iosco.cde.underlier.reports.UnderlierIDOtherLeg1Rule;
import javax.inject.Inject;


@ImplementedBy(UnderlierIDOtherLeg2Rule.UnderlierIDOtherLeg2RuleDefault.class)
public abstract class UnderlierIDOtherLeg2Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSALeg2Aligned isCSALeg2Aligned;
	@Inject protected UnderlierIDOtherLeg1Rule underlierIDOtherLeg1Rule;
	@Inject protected drr.standards.iosco.cde.underlier.reports.UnderlierIDOtherLeg2Rule underlierIDOtherLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class UnderlierIDOtherLeg2RuleDefault extends UnderlierIDOtherLeg2Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCSALeg2Aligned.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(underlierIDOtherLeg2Rule.evaluate(item.get()));
					}
					return MapperS.of(underlierIDOtherLeg1Rule.evaluate(item.get()));
				}).get();
			
			return output;
		}
	}
}
