package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg1Aligned;
import drr.standards.iosco.cde.underlier.reports.UnderlierIDOtherSourceLeg2Rule;
import javax.inject.Inject;


@ImplementedBy(UnderlierIDOtherSourceLeg1Rule.UnderlierIDOtherSourceLeg1RuleDefault.class)
public abstract class UnderlierIDOtherSourceLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSALeg1Aligned isCSALeg1Aligned;
	@Inject protected drr.standards.iosco.cde.underlier.reports.UnderlierIDOtherSourceLeg1Rule underlierIDOtherSourceLeg1Rule;
	@Inject protected UnderlierIDOtherSourceLeg2Rule underlierIDOtherSourceLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class UnderlierIDOtherSourceLeg1RuleDefault extends UnderlierIDOtherSourceLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCSALeg1Aligned.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(underlierIDOtherSourceLeg1Rule.evaluate(item.get()));
					}
					return MapperS.of(underlierIDOtherSourceLeg2Rule.evaluate(item.get()));
				}).get();
			
			return output;
		}
	}
}
