package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.quantity.functions.NotionalAmountScheduleCount_Validation;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.cde.quantity.NotionalPeriod;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CSATransactionReportCSA_VR_0040_01b")
@ImplementedBy(CSATransactionReportCSA_VR_0040_01b.Default.class)
public interface CSATransactionReportCSA_VR_0040_01b extends Validator<CSATransactionReport> {
	
	String NAME = "CSATransactionReportCSA_VR_0040_01b";
	String DEFINITION = "common.quantity.NotionalAmountScheduleCount_Validation( leg1 -> notionalAmountSchedule ) and common.quantity.NotionalAmountScheduleCount_Validation( leg2 -> notionalAmountSchedule )";
	
	class Default implements CSATransactionReportCSA_VR_0040_01b {
	
		@Inject protected NotionalAmountScheduleCount_Validation notionalAmountScheduleCount_Validation;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			ComparisonResult result = executeDataRule(cSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
			try {
				return ComparisonResult.of(MapperS.of(notionalAmountScheduleCount_Validation.evaluate(MapperS.of(cSATransactionReport).<CommonLeg>map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).<NotionalPeriod>mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).getMulti()))).and(ComparisonResult.of(MapperS.of(notionalAmountScheduleCount_Validation.evaluate(MapperS.of(cSATransactionReport).<CommonLeg>map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).<NotionalPeriod>mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).getMulti()))));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportCSA_VR_0040_01b {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
