package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetReport;
import drr.regulation.csa.rewrite.trade.CSANonReportable;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbAttributesRecord;
import drr.standards.iosco.upi.AnnaDsbUpiRecord;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CSATransactionReportCSA_VR_0128_01")
@ImplementedBy(CSATransactionReportCSA_VR_0128_01.Default.class)
public interface CSATransactionReportCSA_VR_0128_01 extends Validator<CSATransactionReport> {
	
	String NAME = "CSATransactionReportCSA_VR_0128_01";
	String DEFINITION = "if dtccAdditionalFields -> messageTypeTransaction exists then (if nonReportable -> postUpiData -> Attributes -> UnderlierID = \"Other\" or dtccAdditionalFields -> underlyingAsset -> underlyingAssetIDType all <> \"ISIN\" then underlierIDOtherLeg1 exists or underlierIDOtherLeg2 exists else underlierIDOtherLeg1 is absent and underlierIDOtherLeg2 is absent)";
	
	class Default implements CSATransactionReportCSA_VR_0128_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			ComparisonResult result = executeDataRule(cSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
			try {
				if (exists(MapperS.of(cSATransactionReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).<String>map("getMessageTypeTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getMessageTypeTransaction())).getOrDefault(false)) {
					if (areEqual(MapperS.of(cSATransactionReport).<CSANonReportable>map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).<AnnaDsbAttributesRecord>map("getAttributes", annaDsbUpiRecord -> annaDsbUpiRecord.getAttributes()).<String>map("getUnderlierID", annaDsbAttributesRecord -> annaDsbAttributesRecord.getUnderlierID()), MapperS.of("Other"), CardinalityOperator.All).or(notEqual(MapperS.of(cSATransactionReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).<UnderlyingAssetReport>mapC("getUnderlyingAsset", dTCCAdditionalFields -> dTCCAdditionalFields.getUnderlyingAsset()).<String>map("getUnderlyingAssetIDType", underlyingAssetReport -> underlyingAssetReport.getUnderlyingAssetIDType()), MapperS.of("ISIN"), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(cSATransactionReport).<String>map("getUnderlierIDOtherLeg1", _cSATransactionReport -> _cSATransactionReport.getUnderlierIDOtherLeg1())).or(exists(MapperS.of(cSATransactionReport).<String>map("getUnderlierIDOtherLeg2", _cSATransactionReport -> _cSATransactionReport.getUnderlierIDOtherLeg2())));
					}
					return notExists(MapperS.of(cSATransactionReport).<String>map("getUnderlierIDOtherLeg1", _cSATransactionReport -> _cSATransactionReport.getUnderlierIDOtherLeg1())).and(notExists(MapperS.of(cSATransactionReport).<String>map("getUnderlierIDOtherLeg2", _cSATransactionReport -> _cSATransactionReport.getUnderlierIDOtherLeg2())));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportCSA_VR_0128_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
