package drr.regulation.csa.rewrite.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.trade.CSANonReportable;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class CSATransactionReportOnlyExistsValidator implements ValidatorWithArg<CSATransactionReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends CSATransactionReport> ValidationResult<CSATransactionReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("actionType", ExistenceChecker.isSet((ActionTypeEnum) o.getActionType()))
				.put("eventType", ExistenceChecker.isSet((EventTypeEnum) o.getEventType()))
				.put("eventIdentifier", ExistenceChecker.isSet((String) o.getEventIdentifier()))
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.put("earlyTerminationDate", ExistenceChecker.isSet((Date) o.getEarlyTerminationDate()))
				.put("eventTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getEventTimestamp()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("executionTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getExecutionTimestamp()))
				.put("expirationDate", ExistenceChecker.isSet((Date) o.getExpirationDate()))
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2IdentifierType", ExistenceChecker.isSet((Boolean) o.getCounterparty2IdentifierType()))
				.put("beneficiary1", ExistenceChecker.isSet((String) o.getBeneficiary1()))
				.put("beneficiary1IdentifierTypeIndicator", ExistenceChecker.isSet((Boolean) o.getBeneficiary1IdentifierTypeIndicator()))
				.put("cleared", ExistenceChecker.isSet((ClearedEnum) o.getCleared()))
				.put("centralCounterparty", ExistenceChecker.isSet((String) o.getCentralCounterparty()))
				.put("clearingMember", ExistenceChecker.isSet((String) o.getClearingMember()))
				.put("confirmed", ExistenceChecker.isSet((ConfirmationEnum) o.getConfirmed()))
				.put("callAmount", ExistenceChecker.isSet((BigDecimal) o.getCallAmount()))
				.put("putAmount", ExistenceChecker.isSet((BigDecimal) o.getPutAmount()))
				.put("callCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCallCurrency()))
				.put("putCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPutCurrency()))
				.put("priceSchedule", ExistenceChecker.isSet((List<? extends PricePeriod>) o.getPriceSchedule()))
				.put("strikePriceSchedule", ExistenceChecker.isSet((List<? extends PricePeriod>) o.getStrikePriceSchedule()))
				.put("price", ExistenceChecker.isSet((PriceFormat) o.getPrice()))
				.put("priceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getPriceNotation()))
				.put("priceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPriceCurrency()))
				.put("packageTransactionPrice", ExistenceChecker.isSet((PriceFormat) o.getPackageTransactionPrice()))
				.put("packageTransactionPriceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getPackageTransactionPriceNotation()))
				.put("packageTransactionPriceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPackageTransactionPriceCurrency()))
				.put("packageTransactionSpread", ExistenceChecker.isSet((PriceFormat) o.getPackageTransactionSpread()))
				.put("packageTransactionSpreadNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getPackageTransactionSpreadNotation()))
				.put("packageTransactionSpreadCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPackageTransactionSpreadCurrency()))
				.put("strikePrice", ExistenceChecker.isSet((PriceFormat) o.getStrikePrice()))
				.put("strikePriceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getStrikePriceNotation()))
				.put("strikePriceCurrency", ExistenceChecker.isSet((String) o.getStrikePriceCurrency()))
				.put("priceUnitOfMeasure", ExistenceChecker.isSet((String) o.getPriceUnitOfMeasure()))
				.put("optionPremiumAmount", ExistenceChecker.isSet((BigDecimal) o.getOptionPremiumAmount()))
				.put("optionPremiumCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getOptionPremiumCurrency()))
				.put("optionPremiumPaymentDate", ExistenceChecker.isSet((Date) o.getOptionPremiumPaymentDate()))
				.put("cdSIndexAttachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCdSIndexAttachmentPoint()))
				.put("cdSIndexDetachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCdSIndexDetachmentPoint()))
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("firstExerciseDate", ExistenceChecker.isSet((Date) o.getFirstExerciseDate()))
				.put("finalContractualSettlementDate", ExistenceChecker.isSet((Date) o.getFinalContractualSettlementDate()))
				.put("otherPayment", ExistenceChecker.isSet((List<? extends OtherPayment>) o.getOtherPayment()))
				.put("leg1", ExistenceChecker.isSet((CommonLeg) o.getLeg1()))
				.put("leg2", ExistenceChecker.isSet((CommonLeg) o.getLeg2()))
				.put("counterparty2Name", ExistenceChecker.isSet((String) o.getCounterparty2Name()))
				.put("executionAgentCounterparty1", ExistenceChecker.isSet((String) o.getExecutionAgentCounterparty1()))
				.put("executionAgentCounterparty2DTCC", ExistenceChecker.isSet((String) o.getExecutionAgentCounterparty2DTCC()))
				.put("reportSubmittingEntityID", ExistenceChecker.isSet((String) o.getReportSubmittingEntityID()))
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("uniqueTransactionIdentifierProprietary", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifierProprietary()))
				.put("priorUTI", ExistenceChecker.isSet((String) o.getPriorUTI()))
				.put("priorUTIProprietary", ExistenceChecker.isSet((String) o.getPriorUTIProprietary()))
				.put("uniqueProductIdentifier", ExistenceChecker.isSet((String) o.getUniqueProductIdentifier()))
				.put("contractType", ExistenceChecker.isSet((CommonContractType) o.getContractType()))
				.put("assetClass", ExistenceChecker.isSet((CommonAssetClass) o.getAssetClass()))
				.put("clearingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getClearingTimestamp()))
				.put("platformIdentifier", ExistenceChecker.isSet((String) o.getPlatformIdentifier()))
				.put("direction1", ExistenceChecker.isSet((Direction1Enum) o.getDirection1()))
				.put("direction2Leg1", ExistenceChecker.isSet((Direction2Enum) o.getDirection2Leg1()))
				.put("direction2Leg2", ExistenceChecker.isSet((Direction2Enum) o.getDirection2Leg2()))
				.put("packageIdentifier", ExistenceChecker.isSet((String) o.getPackageIdentifier()))
				.put("barrier", ExistenceChecker.isSet((SingleOrUpperAndLowerBarrier) o.getBarrier()))
				.put("exchangeRate", ExistenceChecker.isSet((BigDecimal) o.getExchangeRate()))
				.put("exchangeRateBasis", ExistenceChecker.isSet((String) o.getExchangeRateBasis()))
				.put("nameOfTheUnderlyingIndex", ExistenceChecker.isSet((String) o.getNameOfTheUnderlyingIndex()))
				.put("basketConstituents", ExistenceChecker.isSet((List<? extends BasketConstituentsReport>) o.getBasketConstituents()))
				.put("underlying", ExistenceChecker.isSet((UnderlyingIdentifier) o.getUnderlying()))
				.put("quantityUnitOfMeasureLeg1", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg1()))
				.put("quantityUnitOfMeasureLeg2", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg2()))
				.put("maturityDateOfTheUnderlying", ExistenceChecker.isSet((Date) o.getMaturityDateOfTheUnderlying()))
				.put("optionType", ExistenceChecker.isSet((OptionTypeCode) o.getOptionType()))
				.put("optionStyle", ExistenceChecker.isSet((OptionStyleEnum) o.getOptionStyle()))
				.put("deliveryType", ExistenceChecker.isSet((DeliveryTypeEnum) o.getDeliveryType()))
				.put("countryOfTheCounterparty2", ExistenceChecker.isSet((ISOCountryCodeEnum) o.getCountryOfTheCounterparty2()))
				.put("bookingLocation", ExistenceChecker.isSet((ISOCountryCodeEnum) o.getBookingLocation()))
				.put("traderLocation", ExistenceChecker.isSet((ISOCountryCodeEnum) o.getTraderLocation()))
				.put("tradingCapacity", ExistenceChecker.isSet((TradingCapacity7Code) o.getTradingCapacity()))
				.put("embeddedOptionType", ExistenceChecker.isSet((EmbeddedOptionTypeEnum) o.getEmbeddedOptionType()))
				.put("seniority", ExistenceChecker.isSet((SeniorityEnum) o.getSeniority()))
				.put("series", ExistenceChecker.isSet((Integer) o.getSeries()))
				.put("indexFactor", ExistenceChecker.isSet((BigDecimal) o.getIndexFactor()))
				.put("technicalRecordId", ExistenceChecker.isSet((String) o.getTechnicalRecordId()))
				.put("counterparty2IdentifierSource", ExistenceChecker.isSet((String) o.getCounterparty2IdentifierSource()))
				.put("buyerIdentifier", ExistenceChecker.isSet((String) o.getBuyerIdentifier()))
				.put("sellerIdentifier", ExistenceChecker.isSet((String) o.getSellerIdentifier()))
				.put("payerIdentifierLeg1", ExistenceChecker.isSet((String) o.getPayerIdentifierLeg1()))
				.put("payerIdentifierLeg2", ExistenceChecker.isSet((String) o.getPayerIdentifierLeg2()))
				.put("receiverIdentifierLeg1", ExistenceChecker.isSet((String) o.getReceiverIdentifierLeg1()))
				.put("receiverIdentifierLeg2", ExistenceChecker.isSet((String) o.getReceiverIdentifierLeg2()))
				.put("brokerIdentifier", ExistenceChecker.isSet((String) o.getBrokerIdentifier()))
				.put("countryAndProvinceOrTerritoryOfIndividual", ExistenceChecker.isSet((String) o.getCountryAndProvinceOrTerritoryOfIndividual()))
				.put("jurisdictionOfCounterparty1", ExistenceChecker.isSet((List<String>) o.getJurisdictionOfCounterparty1()))
				.put("jurisdictionOfCounterparty2", ExistenceChecker.isSet((List<String>) o.getJurisdictionOfCounterparty2()))
				.put("subsequentPositionUTI", ExistenceChecker.isSet((String) o.getSubsequentPositionUTI()))
				.put("priorUSI", ExistenceChecker.isSet((String) o.getPriorUSI()))
				.put("interAffiliateIndicator", ExistenceChecker.isSet((Boolean) o.getInterAffiliateIndicator()))
				.put("platformAnonymousExecutionIndicator", ExistenceChecker.isSet((Boolean) o.getPlatformAnonymousExecutionIndicator()))
				.put("masterAgreementType", ExistenceChecker.isSet((String) o.getMasterAgreementType()))
				.put("masterAgreementVersion", ExistenceChecker.isSet((Integer) o.getMasterAgreementVersion()))
				.put("nonStandardizedTermIndicator", ExistenceChecker.isSet((Boolean) o.getNonStandardizedTermIndicator()))
				.put("clearingAccountOrigin", ExistenceChecker.isSet((ClearingAccountOriginEnum) o.getClearingAccountOrigin()))
				.put("clearingMemberIdentifier", ExistenceChecker.isSet((String) o.getClearingMemberIdentifier()))
				.put("clearingReceiptTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getClearingReceiptTimestamp()))
				.put("clearingExceptionsAndExemptionsCounterparty1", ExistenceChecker.isSet((List<ClearingExceptionsAndExemptionsEnum>) o.getClearingExceptionsAndExemptionsCounterparty1()))
				.put("clearingExceptionsAndExemptionsCounterparty2", ExistenceChecker.isSet((List<ClearingExceptionsAndExemptionsEnum>) o.getClearingExceptionsAndExemptionsCounterparty2()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("level", ExistenceChecker.isSet((ReportLevelEnum) o.getLevel()))
				.put("amendmentIndicator", ExistenceChecker.isSet((Boolean) o.getAmendmentIndicator()))
				.put("packageIndicator", ExistenceChecker.isSet((Boolean) o.getPackageIndicator()))
				.put("cryptoAssetUnderlyingIndicatorLeg1", ExistenceChecker.isSet((Boolean) o.getCryptoAssetUnderlyingIndicatorLeg1()))
				.put("cryptoAssetUnderlyingIndicatorLeg2", ExistenceChecker.isSet((Boolean) o.getCryptoAssetUnderlyingIndicatorLeg2()))
				.put("customBasketCode", ExistenceChecker.isSet((String) o.getCustomBasketCode()))
				.put("customBasketIndicator", ExistenceChecker.isSet((Boolean) o.getCustomBasketIndicator()))
				.put("underlierIDOtherLeg1", ExistenceChecker.isSet((String) o.getUnderlierIDOtherLeg1()))
				.put("underlierIDOtherLeg2", ExistenceChecker.isSet((String) o.getUnderlierIDOtherLeg2()))
				.put("underlierIDOtherSourceLeg1", ExistenceChecker.isSet((String) o.getUnderlierIDOtherSourceLeg1()))
				.put("underlierIDOtherSourceLeg2", ExistenceChecker.isSet((String) o.getUnderlierIDOtherSourceLeg2()))
				.put("underlyingAssetTradingPlatformIdentifierLeg1", ExistenceChecker.isSet((String) o.getUnderlyingAssetTradingPlatformIdentifierLeg1()))
				.put("underlyingAssetTradingPlatformIdentifierLeg2", ExistenceChecker.isSet((String) o.getUnderlyingAssetTradingPlatformIdentifierLeg2()))
				.put("underlyingAssetPriceSourceLeg1", ExistenceChecker.isSet((String) o.getUnderlyingAssetPriceSourceLeg1()))
				.put("underlyingAssetPriceSourceLeg2", ExistenceChecker.isSet((String) o.getUnderlyingAssetPriceSourceLeg2()))
				.put("settlementLocation", ExistenceChecker.isSet((String) o.getSettlementLocation()))
				.put("exchangeRateBasisLeg1", ExistenceChecker.isSet((String) o.getExchangeRateBasisLeg1()))
				.put("nonReportable", ExistenceChecker.isSet((CSANonReportable) o.getNonReportable()))
				.put("dtccAdditionalFields", ExistenceChecker.isSet((DTCCAdditionalFields) o.getDtccAdditionalFields()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("CSATransactionReport", ValidationType.ONLY_EXISTS, "CSATransactionReport", path, "");
		}
		return failure("CSATransactionReport", ValidationType.ONLY_EXISTS, "CSATransactionReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
