package drr.regulation.esma.emir.refit.margin;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.esma.emir.refit.margin.CollateralReport;
import drr.regulation.esma.emir.refit.margin.CollateralReport.CollateralReportBuilder;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilderImpl;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport.ESMAEMIRMarginReportImpl;
import drr.regulation.esma.emir.refit.margin.PartiesToTheDerivative;
import drr.regulation.esma.emir.refit.margin.PartiesToTheDerivative.PartiesToTheDerivativeBuilder;
import drr.regulation.esma.emir.refit.margin.meta.ESMAEMIRMarginReportMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="ESMAEMIRMarginReport", builder=ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="ESMAEMIRMarginReport", model="drr", builder=ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilderImpl.class, version="6.0.0-dev.128")
public interface ESMAEMIRMarginReport extends RosettaModelObject {

	ESMAEMIRMarginReportMeta metaData = new ESMAEMIRMarginReportMeta();

	/*********************** Getter Methods  ***********************/
	PartiesToTheDerivative getPartiesToTheDerivative();
	CollateralReport getCollateral();

	/*********************** Build Methods  ***********************/
	ESMAEMIRMarginReport build();
	
	ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder toBuilder();
	
	static ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder builder() {
		return new ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ESMAEMIRMarginReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ESMAEMIRMarginReport> getType() {
		return ESMAEMIRMarginReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("partiesToTheDerivative"), processor, PartiesToTheDerivative.class, getPartiesToTheDerivative());
		processRosetta(path.newSubPath("collateral"), processor, CollateralReport.class, getCollateral());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ESMAEMIRMarginReportBuilder extends ESMAEMIRMarginReport, RosettaModelObjectBuilder {
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder getOrCreatePartiesToTheDerivative();
		@Override
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder getPartiesToTheDerivative();
		CollateralReport.CollateralReportBuilder getOrCreateCollateral();
		@Override
		CollateralReport.CollateralReportBuilder getCollateral();
		ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder setPartiesToTheDerivative(PartiesToTheDerivative partiesToTheDerivative);
		ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder setCollateral(CollateralReport collateral);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("partiesToTheDerivative"), processor, PartiesToTheDerivative.PartiesToTheDerivativeBuilder.class, getPartiesToTheDerivative());
			processRosetta(path.newSubPath("collateral"), processor, CollateralReport.CollateralReportBuilder.class, getCollateral());
		}
		

		ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder prune();
	}

	/*********************** Immutable Implementation of ESMAEMIRMarginReport  ***********************/
	class ESMAEMIRMarginReportImpl implements ESMAEMIRMarginReport {
		private final PartiesToTheDerivative partiesToTheDerivative;
		private final CollateralReport collateral;
		
		protected ESMAEMIRMarginReportImpl(ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder builder) {
			this.partiesToTheDerivative = ofNullable(builder.getPartiesToTheDerivative()).map(f->f.build()).orElse(null);
			this.collateral = ofNullable(builder.getCollateral()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("partiesToTheDerivative")
		@RuneAttribute("partiesToTheDerivative")
		public PartiesToTheDerivative getPartiesToTheDerivative() {
			return partiesToTheDerivative;
		}
		
		@Override
		@RosettaAttribute("collateral")
		@RuneAttribute("collateral")
		public CollateralReport getCollateral() {
			return collateral;
		}
		
		@Override
		public ESMAEMIRMarginReport build() {
			return this;
		}
		
		@Override
		public ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder toBuilder() {
			ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder builder) {
			ofNullable(getPartiesToTheDerivative()).ifPresent(builder::setPartiesToTheDerivative);
			ofNullable(getCollateral()).ifPresent(builder::setCollateral);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ESMAEMIRMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(partiesToTheDerivative, _that.getPartiesToTheDerivative())) return false;
			if (!Objects.equals(collateral, _that.getCollateral())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (partiesToTheDerivative != null ? partiesToTheDerivative.hashCode() : 0);
			_result = 31 * _result + (collateral != null ? collateral.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ESMAEMIRMarginReport {" +
				"partiesToTheDerivative=" + this.partiesToTheDerivative + ", " +
				"collateral=" + this.collateral +
			'}';
		}
	}

	/*********************** Builder Implementation of ESMAEMIRMarginReport  ***********************/
	class ESMAEMIRMarginReportBuilderImpl implements ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder {
	
		protected PartiesToTheDerivative.PartiesToTheDerivativeBuilder partiesToTheDerivative;
		protected CollateralReport.CollateralReportBuilder collateral;
		
		@Override
		@RosettaAttribute("partiesToTheDerivative")
		@RuneAttribute("partiesToTheDerivative")
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder getPartiesToTheDerivative() {
			return partiesToTheDerivative;
		}
		
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder getOrCreatePartiesToTheDerivative() {
			PartiesToTheDerivative.PartiesToTheDerivativeBuilder result;
			if (partiesToTheDerivative!=null) {
				result = partiesToTheDerivative;
			}
			else {
				result = partiesToTheDerivative = PartiesToTheDerivative.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("collateral")
		@RuneAttribute("collateral")
		public CollateralReport.CollateralReportBuilder getCollateral() {
			return collateral;
		}
		
		@Override
		public CollateralReport.CollateralReportBuilder getOrCreateCollateral() {
			CollateralReport.CollateralReportBuilder result;
			if (collateral!=null) {
				result = collateral;
			}
			else {
				result = collateral = CollateralReport.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("partiesToTheDerivative")
		@RuneAttribute("partiesToTheDerivative")
		public ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder setPartiesToTheDerivative(PartiesToTheDerivative _partiesToTheDerivative) {
			this.partiesToTheDerivative = _partiesToTheDerivative == null ? null : _partiesToTheDerivative.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("collateral")
		@RuneAttribute("collateral")
		public ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder setCollateral(CollateralReport _collateral) {
			this.collateral = _collateral == null ? null : _collateral.toBuilder();
			return this;
		}
		
		@Override
		public ESMAEMIRMarginReport build() {
			return new ESMAEMIRMarginReport.ESMAEMIRMarginReportImpl(this);
		}
		
		@Override
		public ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder prune() {
			if (partiesToTheDerivative!=null && !partiesToTheDerivative.prune().hasData()) partiesToTheDerivative = null;
			if (collateral!=null && !collateral.prune().hasData()) collateral = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPartiesToTheDerivative()!=null && getPartiesToTheDerivative().hasData()) return true;
			if (getCollateral()!=null && getCollateral().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder o = (ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder) other;
			
			merger.mergeRosetta(getPartiesToTheDerivative(), o.getPartiesToTheDerivative(), this::setPartiesToTheDerivative);
			merger.mergeRosetta(getCollateral(), o.getCollateral(), this::setCollateral);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ESMAEMIRMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(partiesToTheDerivative, _that.getPartiesToTheDerivative())) return false;
			if (!Objects.equals(collateral, _that.getCollateral())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (partiesToTheDerivative != null ? partiesToTheDerivative.hashCode() : 0);
			_result = 31 * _result + (collateral != null ? collateral.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ESMAEMIRMarginReportBuilder {" +
				"partiesToTheDerivative=" + this.partiesToTheDerivative + ", " +
				"collateral=" + this.collateral +
			'}';
		}
	}
}
