package drr.regulation.esma.emir.refit.margin.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.esma.emir.refit.margin.CollateralReport;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport;
import drr.regulation.esma.emir.refit.margin.PartiesToTheDerivative;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ESMAEMIRMarginReportOnlyExistsValidator implements ValidatorWithArg<ESMAEMIRMarginReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ESMAEMIRMarginReport> ValidationResult<ESMAEMIRMarginReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("partiesToTheDerivative", ExistenceChecker.isSet((PartiesToTheDerivative) o.getPartiesToTheDerivative()))
				.put("collateral", ExistenceChecker.isSet((CollateralReport) o.getCollateral()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ESMAEMIRMarginReport", ValidationType.ONLY_EXISTS, "ESMAEMIRMarginReport", path, "");
		}
		return failure("ESMAEMIRMarginReport", ValidationType.ONLY_EXISTS, "ESMAEMIRMarginReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
