package drr.regulation.esma.emir.refit.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.ReportableDelivery.ReportableDeliveryBuilder;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.EMIRTransactionReport;
import drr.regulation.common.trade.EMIRTransactionReport.EMIRTransactionReportBuilder;
import drr.regulation.common.trade.EMIRTransactionReport.EMIRTransactionReportBuilderImpl;
import drr.regulation.common.trade.EMIRTransactionReport.EMIRTransactionReportImpl;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.common.trade.basket.BasketConstituentsReport.BasketConstituentsReportBuilder;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilder;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRNonReportable;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRNonReportable.ESMAEMIRNonReportableBuilder;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilderImpl;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport.ESMAEMIRTransactionReportImpl;
import drr.regulation.esma.emir.refit.trade.meta.ESMAEMIRTransactionReportMeta;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.payment.OtherPayment.OtherPaymentBuilder;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceFormat.PriceFormatBuilder;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.price.PricePeriod.PricePeriodBuilder;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EnergyLoadType1Code;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.IndexEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="ESMAEMIRTransactionReport", builder=ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="ESMAEMIRTransactionReport", model="drr", builder=ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilderImpl.class, version="6.0.0-dev.128")
public interface ESMAEMIRTransactionReport extends EMIRTransactionReport {

	ESMAEMIRTransactionReportMeta metaData = new ESMAEMIRTransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	ESMAEMIRNonReportable getNonReportable();

	/*********************** Build Methods  ***********************/
	ESMAEMIRTransactionReport build();
	
	ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder toBuilder();
	
	static ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder builder() {
		return new ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ESMAEMIRTransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ESMAEMIRTransactionReport> getType() {
		return ESMAEMIRTransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, getStrikePriceSchedule());
		processRosetta(path.newSubPath("price"), processor, PriceFormat.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, getOtherPayment());
		processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, getLeg1());
		processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, getLeg2());
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
		processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
		processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, getBarrier());
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.class, getUnderlying());
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty1"), String.class, getNatureOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty2"), String.class, getNatureOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
		processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
		processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
		processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
		processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
		processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
		processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
		processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, getIndicatorOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
		processor.processBasic(path.newSubPath("clearingObligation"), String.class, getClearingObligation(), this);
		processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
		processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
		processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
		processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), String.class, getTypeOfPTRRTechnique(), this);
		processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
		processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
		processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
		processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
		processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
		processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
		processor.processBasic(path.newSubPath("deliveryPoint"), String.class, getDeliveryPoint(), this);
		processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
		processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, getLoadType(), this);
		processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.class, getDeliveryReport());
		processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
		processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
		processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
		processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
		processRosetta(path.newSubPath("nonReportable"), processor, ESMAEMIRNonReportable.class, getNonReportable());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ESMAEMIRTransactionReportBuilder extends ESMAEMIRTransactionReport, EMIRTransactionReport.EMIRTransactionReportBuilder {
		ESMAEMIRNonReportable.ESMAEMIRNonReportableBuilder getOrCreateNonReportable();
		@Override
		ESMAEMIRNonReportable.ESMAEMIRNonReportableBuilder getNonReportable();
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventType(EventTypeEnum eventType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventIdentifier(String eventIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEffectiveDate(Date effectiveDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExpirationDate(Date expirationDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty1(String counterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2(String counterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBeneficiary1(String beneficiary1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCleared(ClearedEnum cleared);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingMember(String clearingMember);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setConfirmed(ConfirmationEnum confirmed);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCallAmount(BigDecimal callAmount);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPutAmount(BigDecimal putAmount);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPrice(PriceFormat price);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum priceNotation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat packageTransactionPrice);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat packageTransactionSpread);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePrice(PriceFormat strikePrice);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment otherPayment);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment otherPayment, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(Leg leg1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(Leg leg2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(CommonLeg leg1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(CommonLeg leg2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty1(String executionAgentCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty2DTCC(String executionAgentCounterparty2DTCC);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUTI(String priorUTI);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setContractType(CommonContractType contractType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setAssetClass(CommonAssetClass assetClass);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirection1(Direction1Enum direction1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirection2Leg1(Direction2Enum direction2Leg1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirection2Leg2(Direction2Enum direction2Leg2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier barrier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlying(UnderlyingIdentifier underlying);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionType(OptionTypeCode optionType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum optionStyle);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum deliveryType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum countryOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum bookingLocation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum traderLocation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code tradingCapacity);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum embeddedOptionType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeniority(SeniorityEnum seniority);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeries(Integer series);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1(String natureOfCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean clearingThresholdOfCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum countryOfTheCounterParty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty2(String natureOfCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean clearingThresholdOfCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean reportingObligationOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBrokerID(String brokerID);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportTrackingNumber(String reportTrackingNumber);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrrId(String ptrrId);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSubsequentPositionUTI(String subsequentPositionUTI);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIsin(String isin);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setProductClassification(String productClassification);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIsCrypto(Boolean isCrypto);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum indicatorOfTheUnderlyingIndex);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum indicatorOfTheUnderlyingIndex, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndex);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndex);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCustomBasketCode(String customBasketCode);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDelta(BigDecimal delta);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime confirmationTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingObligation(String clearingObligation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementType(String masterAgreementType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOtherMasterAgreementType(String otherMasterAgreementType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementVersion(Integer masterAgreementVersion);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIntragroup(Boolean intragroup);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrr(Boolean ptrr);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTypeOfPTRRTechnique(String typeOfPTRRTechnique);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrrServiceProvider(String ptrrServiceProvider);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setVenueOfExecution(String venueOfExecution);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal forwardExchangeRate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBaseProduct(String baseProduct);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSubProduct(String subProduct);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFurtherSubProduct(String furtherSubProduct);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(String deliveryPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(String deliveryPoint, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setInterconnectionPoint(String interconnectionPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code loadType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery deliveryReport);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery deliveryReport, int _idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> deliveryReport);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> deliveryReport);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReferenceEntity(String referenceEntity);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setVersion(Integer version);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTranche(Boolean tranche);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCollateralPortfolioCode(String collateralPortfolioCode);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventDate(Date eventDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLevel(ReportLevelEnum level);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNonReportable(ESMAEMIRNonReportable nonReportable);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getStrikePriceSchedule());
			processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, getLeg1());
			processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, getLeg2());
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
			processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
			processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.UnderlyingIdentifierBuilder.class, getUnderlying());
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty1"), String.class, getNatureOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty2"), String.class, getNatureOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
			processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
			processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
			processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
			processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
			processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
			processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
			processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, getIndicatorOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
			processor.processBasic(path.newSubPath("clearingObligation"), String.class, getClearingObligation(), this);
			processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
			processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
			processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
			processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), String.class, getTypeOfPTRRTechnique(), this);
			processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
			processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
			processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
			processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
			processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
			processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
			processor.processBasic(path.newSubPath("deliveryPoint"), String.class, getDeliveryPoint(), this);
			processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
			processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, getLoadType(), this);
			processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.ReportableDeliveryBuilder.class, getDeliveryReport());
			processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
			processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
			processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
			processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
			processRosetta(path.newSubPath("nonReportable"), processor, ESMAEMIRNonReportable.ESMAEMIRNonReportableBuilder.class, getNonReportable());
		}
		

		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of ESMAEMIRTransactionReport  ***********************/
	class ESMAEMIRTransactionReportImpl extends EMIRTransactionReport.EMIRTransactionReportImpl implements ESMAEMIRTransactionReport {
		private final ESMAEMIRNonReportable nonReportable;
		
		protected ESMAEMIRTransactionReportImpl(ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder builder) {
			super(builder);
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public ESMAEMIRNonReportable getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public ESMAEMIRTransactionReport build() {
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder toBuilder() {
			ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			ESMAEMIRTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ESMAEMIRTransactionReport {" +
				"nonReportable=" + this.nonReportable +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of ESMAEMIRTransactionReport  ***********************/
	class ESMAEMIRTransactionReportBuilderImpl extends EMIRTransactionReport.EMIRTransactionReportBuilderImpl implements ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder {
	
		protected ESMAEMIRNonReportable.ESMAEMIRNonReportableBuilder nonReportable;
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public ESMAEMIRNonReportable.ESMAEMIRNonReportableBuilder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public ESMAEMIRNonReportable.ESMAEMIRNonReportableBuilder getOrCreateNonReportable() {
			ESMAEMIRNonReportable.ESMAEMIRNonReportableBuilder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = ESMAEMIRNonReportable.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventType(EventTypeEnum _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCleared(ClearedEnum _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int _idx) {
			getIndex(this.priceSchedule, _idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules != null) {
				for (final PricePeriod toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("priceSchedule")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int _idx) {
			getIndex(this.strikePriceSchedule, _idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final PricePeriod toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("strikePriceSchedule")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPrice(PriceFormat _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int _idx) {
			getIndex(this.otherPayment, _idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPayment toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPayment")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1")
		@RuneAttribute("leg1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(CommonLeg _leg1) {
			this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(Leg _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("leg2")
		@RuneAttribute("leg2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(CommonLeg _leg2) {
			this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(Leg _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty1")
		@RuneAttribute("executionAgentCounterparty1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
			this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty2DTCC")
		@RuneAttribute("executionAgentCounterparty2DTCC")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty2DTCC(String _executionAgentCounterparty2DTCC) {
			this.executionAgentCounterparty2DTCC = _executionAgentCounterparty2DTCC == null ? null : _executionAgentCounterparty2DTCC;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportSubmittingEntityID")
		@RuneAttribute("reportSubmittingEntityID")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setContractType(CommonContractType _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@Override
		@RosettaAttribute("assetClass")
		@RuneAttribute("assetClass")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirection1(Direction1Enum _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirection2Leg1(Direction2Enum _direction2Leg1) {
			this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirection2Leg2(Direction2Enum _direction2Leg2) {
			this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int _idx) {
			getIndex(this.basketConstituents, _idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituents")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlying(UnderlyingIdentifier _underlying) {
			this.underlying = _underlying == null ? null : _underlying.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterparty2")
		@RuneAttribute("countryOfTheCounterparty2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
			this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradingCapacity")
		@RuneAttribute("tradingCapacity")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
			this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
			return this;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty1")
		@RuneAttribute("natureOfCounterparty1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1(String _natureOfCounterparty1) {
			this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
			if (_corporateSectorOfTheCounterparty1 != null) {
				this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int _idx) {
			getIndex(this.corporateSectorOfTheCounterparty1, _idx, () -> _corporateSectorOfTheCounterparty1);
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
			if (corporateSectorOfTheCounterparty1s != null) {
				for (final String toAdd : corporateSectorOfTheCounterparty1s) {
					this.corporateSectorOfTheCounterparty1.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
			if (corporateSectorOfTheCounterparty1s == null) {
				this.corporateSectorOfTheCounterparty1 = new ArrayList<>();
			} else {
				this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean _clearingThresholdOfCounterparty1) {
			this.clearingThresholdOfCounterparty1 = _clearingThresholdOfCounterparty1 == null ? null : _clearingThresholdOfCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum _countryOfTheCounterParty2) {
			this.countryOfTheCounterParty2 = _countryOfTheCounterParty2 == null ? null : _countryOfTheCounterParty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty2(String _natureOfCounterparty2) {
			this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
			if (_corporateSectorOfTheCounterparty2 != null) {
				this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int _idx) {
			getIndex(this.corporateSectorOfTheCounterparty2, _idx, () -> _corporateSectorOfTheCounterparty2);
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
			if (corporateSectorOfTheCounterparty2s != null) {
				for (final String toAdd : corporateSectorOfTheCounterparty2s) {
					this.corporateSectorOfTheCounterparty2.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
			if (corporateSectorOfTheCounterparty2s == null) {
				this.corporateSectorOfTheCounterparty2 = new ArrayList<>();
			} else {
				this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean _clearingThresholdOfCounterparty2) {
			this.clearingThresholdOfCounterparty2 = _clearingThresholdOfCounterparty2 == null ? null : _clearingThresholdOfCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingObligationOfTheCounterparty2")
		@RuneAttribute("reportingObligationOfTheCounterparty2")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean _reportingObligationOfTheCounterparty2) {
			this.reportingObligationOfTheCounterparty2 = _reportingObligationOfTheCounterparty2 == null ? null : _reportingObligationOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBrokerID(String _brokerID) {
			this.brokerID = _brokerID == null ? null : _brokerID;
			return this;
		}
		
		@Override
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean _directlyLinkedToCommercialActivityOrTreasuryFinancing) {
			this.directlyLinkedToCommercialActivityOrTreasuryFinancing = _directlyLinkedToCommercialActivityOrTreasuryFinancing == null ? null : _directlyLinkedToCommercialActivityOrTreasuryFinancing;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportTrackingNumber(String _reportTrackingNumber) {
			this.reportTrackingNumber = _reportTrackingNumber == null ? null : _reportTrackingNumber;
			return this;
		}
		
		@Override
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrrId(String _ptrrId) {
			this.ptrrId = _ptrrId == null ? null : _ptrrId;
			return this;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
			this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIsin(String _isin) {
			this.isin = _isin == null ? null : _isin;
			return this;
		}
		
		@Override
		@RosettaAttribute("productClassification")
		@RuneAttribute("productClassification")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setProductClassification(String _productClassification) {
			this.productClassification = _productClassification == null ? null : _productClassification;
			return this;
		}
		
		@Override
		@RosettaAttribute("isCrypto")
		@RuneAttribute("isCrypto")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIsCrypto(Boolean _isCrypto) {
			this.isCrypto = _isCrypto == null ? null : _isCrypto;
			return this;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheUnderlyingIndex")
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex) {
			if (_indicatorOfTheUnderlyingIndex != null) {
				this.indicatorOfTheUnderlyingIndex.add(_indicatorOfTheUnderlyingIndex);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex, int _idx) {
			getIndex(this.indicatorOfTheUnderlyingIndex, _idx, () -> _indicatorOfTheUnderlyingIndex);
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
			if (indicatorOfTheUnderlyingIndexs != null) {
				for (final IndexEnum toAdd : indicatorOfTheUnderlyingIndexs) {
					this.indicatorOfTheUnderlyingIndex.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
			if (indicatorOfTheUnderlyingIndexs == null) {
				this.indicatorOfTheUnderlyingIndex = new ArrayList<>();
			} else {
				this.indicatorOfTheUnderlyingIndex = indicatorOfTheUnderlyingIndexs.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
			this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingObligation(String _clearingObligation) {
			this.clearingObligation = _clearingObligation == null ? null : _clearingObligation;
			return this;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementType(String _masterAgreementType) {
			this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOtherMasterAgreementType(String _otherMasterAgreementType) {
			this.otherMasterAgreementType = _otherMasterAgreementType == null ? null : _otherMasterAgreementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
			this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
			return this;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIntragroup(Boolean _intragroup) {
			this.intragroup = _intragroup == null ? null : _intragroup;
			return this;
		}
		
		@Override
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrr(Boolean _ptrr) {
			this.ptrr = _ptrr == null ? null : _ptrr;
			return this;
		}
		
		@Override
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTypeOfPTRRTechnique(String _typeOfPTRRTechnique) {
			this.typeOfPTRRTechnique = _typeOfPTRRTechnique == null ? null : _typeOfPTRRTechnique;
			return this;
		}
		
		@Override
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrrServiceProvider(String _ptrrServiceProvider) {
			this.ptrrServiceProvider = _ptrrServiceProvider == null ? null : _ptrrServiceProvider;
			return this;
		}
		
		@Override
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setVenueOfExecution(String _venueOfExecution) {
			this.venueOfExecution = _venueOfExecution == null ? null : _venueOfExecution;
			return this;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal _forwardExchangeRate) {
			this.forwardExchangeRate = _forwardExchangeRate == null ? null : _forwardExchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBaseProduct(String _baseProduct) {
			this.baseProduct = _baseProduct == null ? null : _baseProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSubProduct(String _subProduct) {
			this.subProduct = _subProduct == null ? null : _subProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
			this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryPoint")
		@RuneAttribute("deliveryPoint")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint) {
			if (_deliveryPoint != null) {
				this.deliveryPoint.add(_deliveryPoint);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint, int _idx) {
			getIndex(this.deliveryPoint, _idx, () -> _deliveryPoint);
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoints) {
			if (deliveryPoints != null) {
				for (final String toAdd : deliveryPoints) {
					this.deliveryPoint.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("deliveryPoint")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoints) {
			if (deliveryPoints == null) {
				this.deliveryPoint = new ArrayList<>();
			} else {
				this.deliveryPoint = deliveryPoints.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setInterconnectionPoint(String _interconnectionPoint) {
			this.interconnectionPoint = _interconnectionPoint == null ? null : _interconnectionPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code _loadType) {
			this.loadType = _loadType == null ? null : _loadType;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryReport")
		@RuneAttribute("deliveryReport")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport) {
			if (_deliveryReport != null) {
				this.deliveryReport.add(_deliveryReport.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport, int _idx) {
			getIndex(this.deliveryReport, _idx, () -> _deliveryReport.toBuilder());
			return this;
		}
		
		@Override 
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
			if (deliveryReports != null) {
				for (final ReportableDelivery toAdd : deliveryReports) {
					this.deliveryReport.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("deliveryReport")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
			if (deliveryReports == null) {
				this.deliveryReport = new ArrayList<>();
			} else {
				this.deliveryReport = deliveryReports.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
			this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
			return this;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setVersion(Integer _version) {
			this.version = _version == null ? null : _version;
			return this;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTranche(Boolean _tranche) {
			this.tranche = _tranche == null ? null : _tranche;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
			this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventDate(Date _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLevel(ReportLevelEnum _level) {
			this.level = _level == null ? null : _level;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNonReportable(ESMAEMIRNonReportable _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport build() {
			return new ESMAEMIRTransactionReport.ESMAEMIRTransactionReportImpl(this);
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder prune() {
			super.prune();
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder o = (ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder) other;
			
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			ESMAEMIRTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ESMAEMIRTransactionReportBuilder {" +
				"nonReportable=" + this.nonReportable +
			'}' + " " + super.toString();
		}
	}
}
