package drr.regulation.esma.emir.refit.trade.reports;

import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.MandatorilyClearableEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsCleared;
import drr.regulation.common.functions.IsRegulatedMarketOrThirdCountryEquivalentMarket;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ClearingObligationRule.ClearingObligationRuleDefault.class)
public abstract class ClearingObligationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsCleared isCleared;
	@Inject protected IsRegulatedMarketOrThirdCountryEquivalentMarket isRegulatedMarketOrThirdCountryEquivalentMarket;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class ClearingObligationRuleDefault extends ClearingObligationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCleared.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of("UKWN");
					}
					if (areEqual(MapperS.of(isRegulatedMarketOrThirdCountryEquivalentMarket.evaluate(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get(), RegimeNameEnum.EMIR)), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
						final MapperC<ReportingRegime> thenArg0 = item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation());
						final MapperC<ReportingRegime> thenArg1 = thenArg0
							.filterItemNullSafe(_item -> areEqual(_item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.ESMA), CardinalityOperator.All).and(areEqual(_item.<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(RegimeNameEnum.EMIR), CardinalityOperator.All)).get());
						final MapperS<ReportingRegime> thenArg2 = thenArg1
							.last();
						return thenArg2
							.mapSingleToItem(_item -> {
								if (areEqual(_item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_AND_CPTY_MANDATORY), CardinalityOperator.All).getOrDefault(false)) {
									return MapperS.of("TRUE");
								}
								if (areEqual(_item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_MANDATORY_BUT_NOT_CPTY), CardinalityOperator.All).getOrDefault(false)) {
									return MapperS.of("FLSE");
								}
								if (areEqual(_item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_NOT_MANDATORY), CardinalityOperator.All).getOrDefault(false)) {
									return MapperS.of("UKWN");
								}
								return MapperS.<String>ofNull();
							});
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
