package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.contract.reports.EmbeddedOptionTypeRule;
import drr.regulation.common.trade.execution.reports.BookingLocationRule;
import drr.regulation.common.trade.execution.reports.TraderLocationRule;
import drr.regulation.common.trade.execution.reports.TradingCapacityRule;
import drr.regulation.common.trade.party.reports.Counterparty2NameRule;
import drr.regulation.common.trade.party.reports.CountryOfCounterparty2Rule;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty1Rule;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty2DTCCRule;
import drr.regulation.common.trade.party.reports.ReportSubmittingEntityRule;
import drr.regulation.common.trade.price.reports.SingleOrUpperAndLowerBarrierRule;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder;
import drr.regulation.esma.emir.refit.trade.labels.ESMAEMIRTradeLabelProvider;
import drr.standards.iosco.cde.datetime.reports.ReportingTimestampRule;
import drr.standards.iosco.cde.event.reports.ActionTypeRule;
import drr.standards.iosco.cde.event.reports.EventTypeRule;
import drr.standards.iosco.cde.party.reports.Counterparty1Rule;
import drr.standards.iosco.cde.party.reports.Counterparty2IdentifierTypeRule;
import drr.standards.iosco.cde.party.reports.Counterparty2Rule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.esma.emir.refit.trade", body="ESMA", corpusList={"EMIR", "Trade"})
@RuneLabelProvider(labelProvider=ESMAEMIRTradeLabelProvider.class)
@ImplementedBy(ESMAEMIRTradeReportFunction.ESMAEMIRTradeReportFunctionDefault.class)
public abstract class ESMAEMIRTradeReportFunction implements ReportFunction<TransactionReportInstruction, ESMAEMIRTransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected BaseProductRule baseProductRule;
	@Inject protected BookingLocationRule bookingLocationRule;
	@Inject protected BrokerIDRule brokerIDRule;
	@Inject protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
	@Inject protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
	@Inject protected CentralCounterpartyRule centralCounterpartyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingMemberRule clearingMemberRule;
	@Inject protected ClearingObligationRule clearingObligationRule;
	@Inject protected ClearingThresholdOfCounterparty1Rule clearingThresholdOfCounterparty1Rule;
	@Inject protected ClearingThresholdOfCounterparty2Rule clearingThresholdOfCounterparty2Rule;
	@Inject protected ClearingTimestampRule clearingTimestampRule;
	@Inject protected CollateralPortfolioCodeRule collateralPortfolioCodeRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected ConfirmationTimestampRule confirmationTimestampRule;
	@Inject protected ConfirmedRule confirmedRule;
	@Inject protected ContractPriceScheduleRule contractPriceScheduleRule;
	@Inject protected ContractTypeRule contractTypeRule;
	@Inject protected CorporateSectorOfTheCounterparty1Rule corporateSectorOfTheCounterparty1Rule;
	@Inject protected CorporateSectorOfTheCounterparty2Rule corporateSectorOfTheCounterparty2Rule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
	@Inject protected Counterparty2NameRule counterparty2NameRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CountryOfCounterparty2Rule countryOfCounterparty2Rule;
	@Inject protected CountryOfTheCounterParty2Rule countryOfTheCounterParty2Rule;
	@Inject protected CustomBasketCodeRule customBasketCodeRule;
	@Inject protected DeliveryPointOrZoneRule deliveryPointOrZoneRule;
	@Inject protected DeliveryRule deliveryRule;
	@Inject protected DeliveryTypeRule deliveryTypeRule;
	@Inject protected DeltaRule deltaRule;
	@Inject protected DerivativeBasedOnCryptoAssetsRule derivativeBasedOnCryptoAssetsRule;
	@Inject protected DirectionOfLeg1Rule directionOfLeg1Rule;
	@Inject protected DirectionOfLeg2Rule directionOfLeg2Rule;
	@Inject protected DirectionRule directionRule;
	@Inject protected DirectlyLinkedToCommercialActivityOrTreasuryFinancingRule directlyLinkedToCommercialActivityOrTreasuryFinancingRule;
	@Inject protected EarlyTerminationDateRule earlyTerminationDateRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EmbeddedOptionTypeRule embeddedOptionTypeRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
	@Inject protected EventDateRule eventDateRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionAgentCounterparty1Rule executionAgentCounterparty1Rule;
	@Inject protected ExecutionAgentCounterparty2DTCCRule executionAgentCounterparty2DTCCRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
	@Inject protected FixedRateDayCountConventionLeg2Rule fixedRateDayCountConventionLeg2Rule;
	@Inject protected FixedRateOfLeg1OrCouponRule fixedRateOfLeg1OrCouponRule;
	@Inject protected FixedRateOfLeg2Rule fixedRateOfLeg2Rule;
	@Inject protected FixedRateOrCouponDayCountConventionLeg1Rule fixedRateOrCouponDayCountConventionLeg1Rule;
	@Inject protected FixedRateOrCouponPaymentFrequencyPeriodLeg1Rule fixedRateOrCouponPaymentFrequencyPeriodLeg1Rule;
	@Inject protected FixedRateOrCouponPaymentFrequencyPeriodMultiplierLeg1Rule fixedRateOrCouponPaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg2Rule fixedRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected FloatingRateDayCountConventionOfLeg1Rule floatingRateDayCountConventionOfLeg1Rule;
	@Inject protected FloatingRateDayCountConventionOfLeg2Rule floatingRateDayCountConventionOfLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierOfLeg1Rule floatingRatePaymentFrequencyPeriodMultiplierOfLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierOfLeg2Rule floatingRatePaymentFrequencyPeriodMultiplierOfLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodOfLeg1Rule floatingRatePaymentFrequencyPeriodOfLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodOfLeg2Rule floatingRatePaymentFrequencyPeriodOfLeg2Rule;
	@Inject protected FloatingRateReferencePeriodOfLeg1MultiplierRule floatingRateReferencePeriodOfLeg1MultiplierRule;
	@Inject protected FloatingRateReferencePeriodOfLeg1TimePeriodRule floatingRateReferencePeriodOfLeg1TimePeriodRule;
	@Inject protected FloatingRateReferencePeriodOfLeg2MultiplierRule floatingRateReferencePeriodOfLeg2MultiplierRule;
	@Inject protected FloatingRateReferencePeriodOfLeg2TimePeriodRule floatingRateReferencePeriodOfLeg2TimePeriodRule;
	@Inject protected FloatingRateResetFrequencyMultiplierOfLeg1Rule floatingRateResetFrequencyMultiplierOfLeg1Rule;
	@Inject protected FloatingRateResetFrequencyMultiplierOfLeg2Rule floatingRateResetFrequencyMultiplierOfLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodOfLeg1Rule floatingRateResetFrequencyPeriodOfLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodOfLeg2Rule floatingRateResetFrequencyPeriodOfLeg2Rule;
	@Inject protected ForwardExchangeRateRule forwardExchangeRateRule;
	@Inject protected FurtherSubProductRule furtherSubProductRule;
	@Inject protected ISINRule iSINRule;
	@Inject protected IdentifierOfBasketConstituentsRule identifierOfBasketConstituentsRule;
	@Inject protected IdentifierOfFloatingRateOfLeg1Rule identifierOfFloatingRateOfLeg1Rule;
	@Inject protected IdentifierOfFloatingRateOfLeg2Rule identifierOfFloatingRateOfLeg2Rule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected IndicatorOfTheFloatingRateOfLeg1Rule indicatorOfTheFloatingRateOfLeg1Rule;
	@Inject protected IndicatorOfTheFloatingRateOfLeg2Rule indicatorOfTheFloatingRateOfLeg2Rule;
	@Inject protected IndicatorOfTheUnderlyingIndexRule indicatorOfTheUnderlyingIndexRule;
	@Inject protected InterconnectionPointRule interconnectionPointRule;
	@Inject protected IntragroupRule intragroupRule;
	@Inject protected LevelRule levelRule;
	@Inject protected LoadTypeRule loadTypeRule;
	@Inject protected MasterAgreementTypeRule masterAgreementTypeRule;
	@Inject protected MasterAgreementVersionRule masterAgreementVersionRule;
	@Inject protected MaturityDateOfTheUnderlyingRule maturityDateOfTheUnderlyingRule;
	@Inject protected NameOfTheFloatingRateOfLeg1Rule nameOfTheFloatingRateOfLeg1Rule;
	@Inject protected NameOfTheFloatingRateOfLeg2Rule nameOfTheFloatingRateOfLeg2Rule;
	@Inject protected NameOfTheUnderlyingIndexRule nameOfTheUnderlyingIndexRule;
	@Inject protected NatureOfCounterparty1Rule natureOfCounterparty1Rule;
	@Inject protected NatureOfTheCounterparty2Rule natureOfTheCounterparty2Rule;
	@Inject protected NotionalAmountOfLeg1Rule notionalAmountOfLeg1Rule;
	@Inject protected NotionalAmountOfLeg2Rule notionalAmountOfLeg2Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalCurrency1Rule notionalCurrency1Rule;
	@Inject protected NotionalCurrency2Rule notionalCurrency2Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
	@Inject protected OptionStyleRule optionStyleRule;
	@Inject protected OptionTypeRule optionTypeRule;
	@Inject protected OtherMasterAgreementTypeRule otherMasterAgreementTypeRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PTRRIDRule pTRRIDRule;
	@Inject protected PTRRRule pTRRRule;
	@Inject protected PTRRServiceProviderRule pTRRServiceProviderRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionPriceRule packageTransactionPriceRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PackageTransactionSpreadRule packageTransactionSpreadRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceRule priceRule;
	@Inject protected PriorUtiProprietaryRule priorUtiProprietaryRule;
	@Inject protected PriorUtiRule priorUtiRule;
	@Inject protected ProductClassificationRule productClassificationRule;
	@Inject protected ReferenceEntityRule referenceEntityRule;
	@Inject protected ReportSubmittingEntityRule reportSubmittingEntityRule;
	@Inject protected ReportTrackingNumberRule reportTrackingNumberRule;
	@Inject protected ReportingObligationOfTheCounterparty2Rule reportingObligationOfTheCounterparty2Rule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SeniorityRule seniorityRule;
	@Inject protected SeriesRule seriesRule;
	@Inject protected SettlementCurrency1Rule settlementCurrency1Rule;
	@Inject protected SettlementCurrency2Rule settlementCurrency2Rule;
	@Inject protected SingleOrUpperAndLowerBarrierRule singleOrUpperAndLowerBarrierRule;
	@Inject protected SpreadCurrencyOfLeg1Rule spreadCurrencyOfLeg1Rule;
	@Inject protected SpreadCurrencyOfLeg2Rule spreadCurrencyOfLeg2Rule;
	@Inject protected SpreadOfLeg1NotationRule spreadOfLeg1NotationRule;
	@Inject protected SpreadOfLeg2NotationRule spreadOfLeg2NotationRule;
	@Inject protected SpreadOfLeg2Rule spreadOfLeg2Rule;
	@Inject protected SpreadofLeg1Rule spreadofLeg1Rule;
	@Inject protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceRule strikePriceRule;
	@Inject protected StrikePriceScheduleRule strikePriceScheduleRule;
	@Inject protected SubProductRule subProductRule;
	@Inject protected SubsequentPositionUtiRule subsequentPositionUtiRule;
	@Inject protected TotalNotionalQuantityOfLeg1Rule totalNotionalQuantityOfLeg1Rule;
	@Inject protected TotalNotionalQuantityOfLeg2Rule totalNotionalQuantityOfLeg2Rule;
	@Inject protected TraderLocationRule traderLocationRule;
	@Inject protected TradingCapacityRule tradingCapacityRule;
	@Inject protected TrancheRule trancheRule;
	@Inject protected TypeOfPTRRTechniqueRule typeOfPTRRTechniqueRule;
	@Inject protected UPIRule uPIRule;
	@Inject protected UnderlyingIdentificationRule underlyingIdentificationRule;
	@Inject protected UnderlyingIdentificationTypeRule underlyingIdentificationTypeRule;
	@Inject protected UtiProprietaryRule utiProprietaryRule;
	@Inject protected UtiRule utiRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationMethodRule valuationMethodRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;
	@Inject protected VenueOfExecutionRule venueOfExecutionRule;
	@Inject protected VersionRule versionRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ESMAEMIRTransactionReport evaluate(TransactionReportInstruction input) {
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final ESMAEMIRTransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(ESMAEMIRTransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class ESMAEMIRTradeReportFunctionDefault extends ESMAEMIRTradeReportFunction {
		@Override
		protected ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder output = ESMAEMIRTransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder assignOutput(ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setEarlyTerminationDate(earlyTerminationDateRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeRule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyRule.evaluate(input));
			
			output
				.setClearingMember(clearingMemberRule.evaluate(input));
			
			output
				.setConfirmed(confirmedRule.evaluate(input));
			
			output
				.setPriceSchedule(contractPriceScheduleRule.evaluate(input));
			
			output
				.setStrikePriceSchedule(strikePriceScheduleRule.evaluate(input));
			
			output
				.setPrice(priceRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPrice(packageTransactionPriceRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpread(packageTransactionSpreadRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyCurrencyPairRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setOptionPremiumPaymentDate(optionPremiumPaymentDateRule.evaluate(input));
			
			output
				.setCdSIndexAttachmentPoint(cDSIndexAttachmentPointRule.evaluate(input));
			
			output
				.setCdSIndexDetachmentPoint(cDSIndexDetachmentPointRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setFinalContractualSettlementDate(finalContractualSettlementDateRule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRateDayCountConvention(fixedRateOrCouponDayCountConventionLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateDayCountConvention(floatingRateDayCountConventionOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriod(fixedRateOrCouponPaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriod(floatingRatePaymentFrequencyPeriodOfLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal0 = fixedRateOrCouponPaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriodMultiplier((bigDecimal0 == null ? null : bigDecimal0.intValueExact()));
			
			final BigDecimal bigDecimal1 = floatingRatePaymentFrequencyPeriodMultiplierOfLeg1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriodMultiplier((bigDecimal1 == null ? null : bigDecimal1.intValueExact()));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyPeriod(floatingRateResetFrequencyPeriodOfLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal2 = floatingRateResetFrequencyMultiplierOfLeg1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyMultiplier((bigDecimal2 == null ? null : bigDecimal2.intValueExact()));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateIndicator(indicatorOfTheFloatingRateOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateIdentifier(identifierOfFloatingRateOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateReferencePeriod(floatingRateReferencePeriodOfLeg1TimePeriodRule.evaluate(input));
			
			final BigDecimal bigDecimal3 = floatingRateReferencePeriodOfLeg1MultiplierRule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateReferencePeriodMultiplier((bigDecimal3 == null ? null : bigDecimal3.intValueExact()));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setNameOfTheFloatingRate(nameOfTheFloatingRateOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalAmount(notionalAmountOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalAmountSchedule(notionalAmountScheduleLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalQuantitySchedule(notionalQuantityScheduleLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalCurrency(notionalCurrency1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setTotalNotionalQuantity(totalNotionalQuantityOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setFixedRate(fixedRateOfLeg1OrCouponRule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSettlementCurrency(settlementCurrency1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpread(spreadofLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpreadNotation(spreadOfLeg1NotationRule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpreadCurrency(spreadCurrencyOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRateDayCountConvention(fixedRateDayCountConventionLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateDayCountConvention(floatingRateDayCountConventionOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriod(fixedRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriod(floatingRatePaymentFrequencyPeriodOfLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal4 = fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriodMultiplier((bigDecimal4 == null ? null : bigDecimal4.intValueExact()));
			
			final BigDecimal bigDecimal5 = floatingRatePaymentFrequencyPeriodMultiplierOfLeg2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriodMultiplier((bigDecimal5 == null ? null : bigDecimal5.intValueExact()));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyPeriod(floatingRateResetFrequencyPeriodOfLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal6 = floatingRateResetFrequencyMultiplierOfLeg2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyMultiplier((bigDecimal6 == null ? null : bigDecimal6.intValueExact()));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateIndicator(indicatorOfTheFloatingRateOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateIdentifier(identifierOfFloatingRateOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateReferencePeriod(floatingRateReferencePeriodOfLeg2TimePeriodRule.evaluate(input));
			
			final BigDecimal bigDecimal7 = floatingRateReferencePeriodOfLeg2MultiplierRule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateReferencePeriodMultiplier((bigDecimal7 == null ? null : bigDecimal7.intValueExact()));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setNameOfTheFloatingRate(nameOfTheFloatingRateOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalAmount(notionalAmountOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalAmountSchedule(notionalAmountScheduleLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalQuantitySchedule(notionalQuantityScheduleLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalCurrency(notionalCurrency2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setTotalNotionalQuantity(totalNotionalQuantityOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setFixedRate(fixedRateOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSettlementCurrency(settlementCurrency2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpread(spreadOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpreadNotation(spreadOfLeg2NotationRule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpreadCurrency(spreadCurrencyOfLeg2Rule.evaluate(input));
			
			output
				.setCounterparty2Name(counterparty2NameRule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty1(executionAgentCounterparty1Rule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty2DTCC(executionAgentCounterparty2DTCCRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(reportSubmittingEntityRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(utiRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifierProprietary(utiProprietaryRule.evaluate(input));
			
			output
				.setPriorUTI(priorUtiRule.evaluate(input));
			
			output
				.setPriorUTIProprietary(priorUtiProprietaryRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uPIRule.evaluate(input));
			
			output
				.setContractType(contractTypeRule.evaluate(input));
			
			output
				.setAssetClass(assetClassRule.evaluate(input));
			
			output
				.setClearingTimestamp(clearingTimestampRule.evaluate(input));
			
			output
				.setDirection1(directionRule.evaluate(input));
			
			output
				.setDirection2Leg1(directionOfLeg1Rule.evaluate(input));
			
			output
				.setDirection2Leg2(directionOfLeg2Rule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.setBarrier(singleOrUpperAndLowerBarrierRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setNameOfTheUnderlyingIndex(nameOfTheUnderlyingIndexRule.evaluate(input));
			
			output
				.setBasketConstituents(identifierOfBasketConstituentsRule.evaluate(input));
			
			output
				.getOrCreateUnderlying()
				.setUnderlyingIdentification(MapperC.of(underlyingIdentificationRule.evaluate(input)).get());
			
			output
				.getOrCreateUnderlying()
				.setUnderlyingIdentificationType(underlyingIdentificationTypeRule.evaluate(input));
			
			output
				.setMaturityDateOfTheUnderlying(maturityDateOfTheUnderlyingRule.evaluate(input));
			
			output
				.setOptionType(optionTypeRule.evaluate(input));
			
			output
				.setOptionStyle(optionStyleRule.evaluate(input));
			
			output
				.setDeliveryType(deliveryTypeRule.evaluate(input));
			
			output
				.setCountryOfTheCounterparty2(countryOfCounterparty2Rule.evaluate(input));
			
			output
				.setBookingLocation(bookingLocationRule.evaluate(input));
			
			output
				.setTraderLocation(traderLocationRule.evaluate(input));
			
			output
				.setTradingCapacity(tradingCapacityRule.evaluate(input));
			
			output
				.setEmbeddedOptionType(embeddedOptionTypeRule.evaluate(input));
			
			output
				.setSeniority(seniorityRule.evaluate(input));
			
			final BigDecimal bigDecimal8 = seriesRule.evaluate(input);
			output
				.setSeries((bigDecimal8 == null ? null : bigDecimal8.intValueExact()));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			output
				.setEntityResponsibleForReporting(entityResponsibleForReportingRule.evaluate(input));
			
			output
				.setNatureOfCounterparty1(natureOfCounterparty1Rule.evaluate(input));
			
			output
				.setCorporateSectorOfTheCounterparty1(corporateSectorOfTheCounterparty1Rule.evaluate(input));
			
			output
				.setClearingThresholdOfCounterparty1(clearingThresholdOfCounterparty1Rule.evaluate(input));
			
			output
				.setCountryOfTheCounterParty2(countryOfTheCounterParty2Rule.evaluate(input));
			
			output
				.setNatureOfCounterparty2(natureOfTheCounterparty2Rule.evaluate(input));
			
			output
				.setCorporateSectorOfTheCounterparty2(corporateSectorOfTheCounterparty2Rule.evaluate(input));
			
			output
				.setClearingThresholdOfCounterparty2(clearingThresholdOfCounterparty2Rule.evaluate(input));
			
			output
				.setReportingObligationOfTheCounterparty2(reportingObligationOfTheCounterparty2Rule.evaluate(input));
			
			output
				.setBrokerID(brokerIDRule.evaluate(input));
			
			output
				.setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(directlyLinkedToCommercialActivityOrTreasuryFinancingRule.evaluate(input));
			
			output
				.setReportTrackingNumber(reportTrackingNumberRule.evaluate(input));
			
			output
				.setPtrrId(pTRRIDRule.evaluate(input));
			
			output
				.setSubsequentPositionUTI(subsequentPositionUtiRule.evaluate(input));
			
			output
				.setIsin(iSINRule.evaluate(input));
			
			output
				.setProductClassification(productClassificationRule.evaluate(input));
			
			output
				.setIsCrypto(derivativeBasedOnCryptoAssetsRule.evaluate(input));
			
			output
				.setIndicatorOfTheUnderlyingIndex(indicatorOfTheUnderlyingIndexRule.evaluate(input));
			
			output
				.setCustomBasketCode(customBasketCodeRule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationMethod(valuationMethodRule.evaluate(input));
			
			output
				.setDelta(deltaRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setConfirmationTimestamp(confirmationTimestampRule.evaluate(input));
			
			output
				.setClearingObligation(clearingObligationRule.evaluate(input));
			
			output
				.setMasterAgreementType(masterAgreementTypeRule.evaluate(input));
			
			output
				.setOtherMasterAgreementType(otherMasterAgreementTypeRule.evaluate(input));
			
			output
				.setMasterAgreementVersion(masterAgreementVersionRule.evaluate(input));
			
			output
				.setIntragroup(intragroupRule.evaluate(input));
			
			output
				.setPtrr(pTRRRule.evaluate(input));
			
			output
				.setTypeOfPTRRTechnique(typeOfPTRRTechniqueRule.evaluate(input));
			
			output
				.setPtrrServiceProvider(pTRRServiceProviderRule.evaluate(input));
			
			output
				.setVenueOfExecution(venueOfExecutionRule.evaluate(input));
			
			output
				.setForwardExchangeRate(forwardExchangeRateRule.evaluate(input));
			
			output
				.setBaseProduct(baseProductRule.evaluate(input));
			
			output
				.setSubProduct(subProductRule.evaluate(input));
			
			output
				.setFurtherSubProduct(furtherSubProductRule.evaluate(input));
			
			output
				.setDeliveryPoint(deliveryPointOrZoneRule.evaluate(input));
			
			output
				.setInterconnectionPoint(interconnectionPointRule.evaluate(input));
			
			output
				.setLoadType(loadTypeRule.evaluate(input));
			
			output
				.setDeliveryReport(deliveryRule.evaluate(input));
			
			output
				.setReferenceEntity(referenceEntityRule.evaluate(input));
			
			final BigDecimal bigDecimal9 = versionRule.evaluate(input);
			output
				.setVersion((bigDecimal9 == null ? null : bigDecimal9.intValueExact()));
			
			output
				.setTranche(trancheRule.evaluate(input));
			
			output
				.setCollateralPortfolioCode(collateralPortfolioCodeRule.evaluate(input));
			
			output
				.setEventDate(eventDateRule.evaluate(input));
			
			output
				.setLevel(levelRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
