package drr.regulation.fca.ukemir.refit.margin.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRMarginReport;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class FCAUKEMIRMarginReportTypeFormatValidator implements Validator<FCAUKEMIRMarginReport> {

	private List<ComparisonResult> getComparisonResults(FCAUKEMIRMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("FCAUKEMIRMarginReport", ValidationType.TYPE_FORMAT, "FCAUKEMIRMarginReport", path, "", res.getError());
				}
				return success("FCAUKEMIRMarginReport", ValidationType.TYPE_FORMAT, "FCAUKEMIRMarginReport", path, "");
			})
			.collect(toList());
	}

}
