package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsActionTypeCORR;
import drr.regulation.common.functions.IsActionTypeNEWT;
import drr.regulation.common.functions.IsActionTypePOSC;
import drr.regulation.common.functions.IsActionTypeREVI;
import drr.regulation.common.functions.IsActionTypeVALU;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(DeltaRule.DeltaRuleDefault.class)
public abstract class DeltaRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.quantity.reports.DeltaRule deltaRule;
	@Inject protected IsActionTypeCORR isActionTypeCORR;
	@Inject protected IsActionTypeNEWT isActionTypeNEWT;
	@Inject protected IsActionTypePOSC isActionTypePOSC;
	@Inject protected IsActionTypeREVI isActionTypeREVI;
	@Inject protected IsActionTypeVALU isActionTypeVALU;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class DeltaRuleDefault extends DeltaRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> ComparisonResult.of(MapperS.of(isActionTypeNEWT.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isActionTypeVALU.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isActionTypeCORR.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isActionTypeREVI.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isActionTypePOSC.evaluate(item.get())))).get());
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(deltaRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
