package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.event.common.TradeState;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ExtractOtherPaymentPayer;
import drr.regulation.common.functions.ExtractOtherPaymentReceiver;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsOtherPayment;
import drr.regulation.common.functions.TradeStateForEvent;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.payment.OtherPayment.OtherPaymentBuilder;
import drr.standards.iosco.cde.payment.reports.OtherPaymentAmountRule;
import drr.standards.iosco.cde.payment.reports.OtherPaymentCurrencyRule;
import drr.standards.iosco.cde.payment.reports.OtherPaymentDateRule;
import drr.standards.iosco.cde.payment.reports.OtherPaymentPayerFormatRule;
import drr.standards.iosco.cde.payment.reports.OtherPaymentReceiverFormatRule;
import drr.standards.iosco.cde.payment.reports.OtherPaymentTypeRule;
import drr.standards.iso.PaymentType4Code;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentRule.OtherPaymentRuleDefault.class)
public abstract class OtherPaymentRule implements ReportFunction<TransactionReportInstruction, List<? extends OtherPayment>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractOtherPaymentPayer extractOtherPaymentPayer;
	@Inject protected ExtractOtherPaymentReceiver extractOtherPaymentReceiver;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsOtherPayment isOtherPayment;
	@Inject protected OtherPaymentAmountRule otherPaymentAmountRule;
	@Inject protected OtherPaymentCurrencyRule otherPaymentCurrencyRule;
	@Inject protected OtherPaymentDateRule otherPaymentDateRule;
	@Inject protected OtherPaymentPayerFormatRule otherPaymentPayerFormatRule;
	@Inject protected OtherPaymentReceiverFormatRule otherPaymentReceiverFormatRule;
	@Inject protected OtherPaymentTypeRule otherPaymentTypeRule;
	@Inject protected TradeStateForEvent tradeStateForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends OtherPayment> evaluate(TransactionReportInstruction input) {
		List<OtherPayment.OtherPaymentBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends OtherPayment> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(OtherPayment::build).collect(Collectors.toList());
			objectValidator.validate(OtherPayment.class, output);
		}
		
		return output;
	}

	protected abstract List<OtherPayment.OtherPaymentBuilder> doEvaluate(TransactionReportInstruction input);

	public static class OtherPaymentRuleDefault extends OtherPaymentRule {
		@Override
		protected List<OtherPayment.OtherPaymentBuilder> doEvaluate(TransactionReportInstruction input) {
			List<OtherPayment.OtherPaymentBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<OtherPayment.OtherPaymentBuilder> assignOutput(List<OtherPayment.OtherPaymentBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> ComparisonResult.of(MapperS.of(isAllowableAction.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isActionTypeTERM.evaluate(item.get())))).get());
			output = toBuilder(thenArg
				.mapSingleToList(transactionReportInstruction -> {
					final MapperS<TradeState> thenArg0 = MapperS.of(tradeStateForEvent.evaluate(thenArg.get()));
					final MapperC<TransferState> thenArg1 = thenArg0
						.mapSingleToList(item -> item.<TransferState>mapC("getTransferHistory", tradeState -> tradeState.getTransferHistory()));
					final MapperC<TransferState> thenArg2 = thenArg1
						.filterItemNullSafe(item -> isOtherPayment.evaluate(item.get()));
					return thenArg2
						.mapItem(item -> MapperS.of(OtherPayment.builder()
							.setPaymentType(MapperS.of(otherPaymentTypeRule.evaluate(item.get())).checkedMap("to-enum", PaymentType4Code::fromDisplayName, IllegalArgumentException.class).get())
							.setAmount(otherPaymentAmountRule.evaluate(item.get()))
							.setCurrency(otherPaymentCurrencyRule.evaluate(item.get()))
							.setDate(otherPaymentDateRule.evaluate(item.get()))
							.setPayer(extractOtherPaymentPayer.evaluate(item.get(), transactionReportInstruction.get()))
							.setPayerFormat(otherPaymentPayerFormatRule.evaluate(item.get()))
							.setReceiver(extractOtherPaymentReceiver.evaluate(item.get(), transactionReportInstruction.get()))
							.setReceiverFormat(otherPaymentReceiverFormatRule.evaluate(item.get()))
							.build()));
				}).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
