package drr.regulation.fca.ukemir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.ExecutionAgent;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class ExecutionAgentTypeFormatValidator implements Validator<ExecutionAgent> {

	private List<ComparisonResult> getComparisonResults(ExecutionAgent o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("executionAgentReportingParty", o.getExecutionAgentReportingParty(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("executionAgentReportingCounterparty", o.getExecutionAgentReportingCounterparty(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionAgent o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ExecutionAgent", ValidationType.TYPE_FORMAT, "ExecutionAgent", path, "", res.getError());
				}
				return success("ExecutionAgent", ValidationType.TYPE_FORMAT, "ExecutionAgent", path, "");
			})
			.collect(toList());
	}

}
