package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRNonReportable;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.MicData;
import drr.standards.iso.MicMarketCategoryEnum;
import drr.standards.iso.functions.GetOrFetchMicData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2007_01")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2007_01.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2007_01 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2007_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if venueOfExecution exists and (venueOfExecution = \"XOFF\" or (GetOrFetchMicData( nonReportable -> enrichment -> micData, venueOfExecution ) extract marketCategory = MicMarketCategoryEnum -> RMKT or marketCategory = MicMarketCategoryEnum -> MLTF or marketCategory = MicMarketCategoryEnum -> OTFS)) = True then isin exists else if venueOfExecution exists and (GetOrFetchMicData( nonReportable -> enrichment -> micData, venueOfExecution ) extract marketCategory = MicMarketCategoryEnum -> SINT ) = True then isin exists or isin is absent";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2007_01 {
	
		@Inject protected GetOrFetchMicData getOrFetchMicData;
		
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<ActionTypeEnum>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getVenueOfExecution", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getVenueOfExecution())).and(areEqual(areEqual(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getVenueOfExecution", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getVenueOfExecution()), MapperS.of("XOFF"), CardinalityOperator.All).or(ComparisonResult.of(MapperS.of(getOrFetchMicData.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<FCAUKEMIRNonReportable>map("getNonReportable", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportable -> fCAUKEMIRNonReportable.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).getMulti(), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getVenueOfExecution", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getVenueOfExecution()).get()))
						.mapSingleToItem(item -> areEqual(item.<MicMarketCategoryEnum>map("getMarketCategory", micData -> micData.getMarketCategory()), MapperS.of(MicMarketCategoryEnum.RMKT), CardinalityOperator.All).or(areEqual(item.<MicMarketCategoryEnum>map("getMarketCategory", micData -> micData.getMarketCategory()), MapperS.of(MicMarketCategoryEnum.MLTF), CardinalityOperator.All)).or(areEqual(item.<MicMarketCategoryEnum>map("getMarketCategory", micData -> micData.getMarketCategory()), MapperS.of(MicMarketCategoryEnum.OTFS), CardinalityOperator.All)).asMapper()))), MapperS.of(true), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getIsin", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getIsin()));
					}
					if (exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getVenueOfExecution", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getVenueOfExecution())).and(areEqual(MapperS.of(getOrFetchMicData.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<FCAUKEMIRNonReportable>map("getNonReportable", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportable -> fCAUKEMIRNonReportable.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).getMulti(), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getVenueOfExecution", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getVenueOfExecution()).get()))
						.mapSingleToItem(item -> areEqual(item.<MicMarketCategoryEnum>map("getMarketCategory", micData -> micData.getMarketCategory()), MapperS.of(MicMarketCategoryEnum.SINT), CardinalityOperator.All).asMapper()), MapperS.of(true), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getIsin", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getIsin())).or(notExists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getIsin", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getIsin())));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2007_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
