package drr.regulation.fca.ukemir.refit.trade.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.trade.ExecutionAgent;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ExecutionAgentOnlyExistsValidator implements ValidatorWithArg<ExecutionAgent, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ExecutionAgent> ValidationResult<ExecutionAgent> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("executionAgentReportingParty", ExistenceChecker.isSet((String) o.getExecutionAgentReportingParty()))
				.put("executionAgentReportingCounterparty", ExistenceChecker.isSet((String) o.getExecutionAgentReportingCounterparty()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ExecutionAgent", ValidationType.ONLY_EXISTS, "ExecutionAgent", path, "");
		}
		return failure("ExecutionAgent", ValidationType.ONLY_EXISTS, "ExecutionAgent", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
