package drr.regulation.hkma.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.common.PartyIdentifierFormat2Enum;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport.HKMAMarginReportBuilder;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport.HKMAMarginReportBuilderImpl;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport.HKMAMarginReportImpl;
import drr.regulation.hkma.rewrite.margin.meta.HKMAMarginReportMeta;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="HKMAMarginReport", builder=HKMAMarginReport.HKMAMarginReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="HKMAMarginReport", model="drr", builder=HKMAMarginReport.HKMAMarginReportBuilderImpl.class, version="6.0.0-dev.128")
public interface HKMAMarginReport extends RosettaModelObject {

	HKMAMarginReportMeta metaData = new HKMAMarginReportMeta();

	/*********************** Getter Methods  ***********************/
	ZonedDateTime getReportingTimestamp();
	String getCounterparty1();
	String getCounterparty2();
	String getCounterparty2Name();
	Boolean getCounterparty2IdentifierTypeIndicator();
	Boolean getCollateralPortfolioIndicator();
	BigDecimal getInitialMarginPostedByTheReportingCounterparty1PreHaircut();
	BigDecimal getInitialMarginPostedByTheReportingCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted();
	BigDecimal getInitialMarginCollectedByTheReportingCounterparty1PreHaircut();
	BigDecimal getInitialMarginCollectedByTheReportingCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected();
	BigDecimal getVariationMarginPostedByTheReportingCounterparty1PreHaircut();
	BigDecimal getVariationMarginPostedByTheReportingCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted();
	BigDecimal getVariationMarginCollectedByTheReportingCounterparty1PreHaircut();
	BigDecimal getVariationMarginCollectedByTheReportingCounterparty1PostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected();
	BigDecimal getExcessCollateralPostedByTheCounterparty1();
	String getCurrencyOfExcessCollateralPosted();
	BigDecimal getExcessCollateralCollectedByTheCounterparty1();
	String getCurrencyOfTheExcessCollateralCollected();
	CollateralisationType3Code__1 getCollateralisationCategory();
	MarginActionEnum getActionType();
	ZonedDateTime getEventTimestamp();
	String getUniqueTransactionIdentifier();
	String getInitialMarginCollateralPortfolioCode();
	Boolean getPortfolioContainingNonReportableComponentIndicator();
	String getVariationMarginCollateralPortfolioCode();
	String getSubmitterIdentifier();
	String getEntityResponsibleForReporting();
	ZonedDateTime getCollateralTimestamp();
	BigDecimal getNumberRecords();
	String getTechnicalRecordId();
	Date getEventDate();
	PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat();

	/*********************** Build Methods  ***********************/
	HKMAMarginReport build();
	
	HKMAMarginReport.HKMAMarginReportBuilder toBuilder();
	
	static HKMAMarginReport.HKMAMarginReportBuilder builder() {
		return new HKMAMarginReport.HKMAMarginReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends HKMAMarginReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends HKMAMarginReport> getType() {
		return HKMAMarginReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, getCounterparty2IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfInitialMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfInitialMarginPosted(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfInitialMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfInitialMarginCollected(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginPosted(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterparty1PreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterparty1PostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginCollected(), this);
		processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, getExcessCollateralPostedByTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("currencyOfExcessCollateralPosted"), String.class, getCurrencyOfExcessCollateralPosted(), this);
		processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, getExcessCollateralCollectedByTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, getCurrencyOfTheExcessCollateralCollected(), this);
		processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
		processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, getPortfolioContainingNonReportableComponentIndicator(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, getCollateralTimestamp(), this);
		processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, getNumberRecords(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, getCounterparty2IdentifierFormat(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface HKMAMarginReportBuilder extends HKMAMarginReport, RosettaModelObjectBuilder {
		HKMAMarginReport.HKMAMarginReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		HKMAMarginReport.HKMAMarginReportBuilder setCounterparty1(String counterparty1);
		HKMAMarginReport.HKMAMarginReportBuilder setCounterparty2(String counterparty2);
		HKMAMarginReport.HKMAMarginReportBuilder setCounterparty2Name(String counterparty2Name);
		HKMAMarginReport.HKMAMarginReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean counterparty2IdentifierTypeIndicator);
		HKMAMarginReport.HKMAMarginReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginPostedByTheReportingCounterparty1PreHaircut(BigDecimal initialMarginPostedByTheReportingCounterparty1PreHaircut);
		HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginPostedByTheReportingCounterparty1PostHaircut(BigDecimal initialMarginPostedByTheReportingCounterparty1PostHaircut);
		HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfInitialMarginPosted(ISOCurrencyCodeEnum currencyOfInitialMarginPosted);
		HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginCollectedByTheReportingCounterparty1PreHaircut(BigDecimal initialMarginCollectedByTheReportingCounterparty1PreHaircut);
		HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginCollectedByTheReportingCounterparty1PostHaircut(BigDecimal initialMarginCollectedByTheReportingCounterparty1PostHaircut);
		HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfInitialMarginCollected(ISOCurrencyCodeEnum currencyOfInitialMarginCollected);
		HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginPostedByTheReportingCounterparty1PreHaircut(BigDecimal variationMarginPostedByTheReportingCounterparty1PreHaircut);
		HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginPostedByTheReportingCounterparty1PostHaircut(BigDecimal variationMarginPostedByTheReportingCounterparty1PostHaircut);
		HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum currencyOfVariationMarginPosted);
		HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginCollectedByTheReportingCounterparty1PreHaircut(BigDecimal variationMarginCollectedByTheReportingCounterparty1PreHaircut);
		HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginCollectedByTheReportingCounterparty1PostHaircut(BigDecimal variationMarginCollectedByTheReportingCounterparty1PostHaircut);
		HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum currencyOfVariationMarginCollected);
		HKMAMarginReport.HKMAMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal excessCollateralPostedByTheCounterparty1);
		HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfExcessCollateralPosted(String currencyOfExcessCollateralPosted);
		HKMAMarginReport.HKMAMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal excessCollateralCollectedByTheCounterparty1);
		HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String currencyOfTheExcessCollateralCollected);
		HKMAMarginReport.HKMAMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 collateralisationCategory);
		HKMAMarginReport.HKMAMarginReportBuilder setActionType(MarginActionEnum actionType);
		HKMAMarginReport.HKMAMarginReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		HKMAMarginReport.HKMAMarginReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		HKMAMarginReport.HKMAMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean portfolioContainingNonReportableComponentIndicator);
		HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		HKMAMarginReport.HKMAMarginReportBuilder setSubmitterIdentifier(String submitterIdentifier);
		HKMAMarginReport.HKMAMarginReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		HKMAMarginReport.HKMAMarginReportBuilder setCollateralTimestamp(ZonedDateTime collateralTimestamp);
		HKMAMarginReport.HKMAMarginReportBuilder setNumberRecords(BigDecimal numberRecords);
		HKMAMarginReport.HKMAMarginReportBuilder setTechnicalRecordId(String technicalRecordId);
		HKMAMarginReport.HKMAMarginReportBuilder setEventDate(Date eventDate);
		HKMAMarginReport.HKMAMarginReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum counterparty2IdentifierFormat);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, getCounterparty2IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfInitialMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfInitialMarginPosted(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterparty1PreHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterparty1PostHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfInitialMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfInitialMarginCollected(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginPosted(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterparty1PreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterparty1PreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterparty1PostHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterparty1PostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginCollected(), this);
			processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, getExcessCollateralPostedByTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("currencyOfExcessCollateralPosted"), String.class, getCurrencyOfExcessCollateralPosted(), this);
			processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, getExcessCollateralCollectedByTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, getCurrencyOfTheExcessCollateralCollected(), this);
			processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
			processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, getPortfolioContainingNonReportableComponentIndicator(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, getCollateralTimestamp(), this);
			processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, getNumberRecords(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, getCounterparty2IdentifierFormat(), this);
		}
		

		HKMAMarginReport.HKMAMarginReportBuilder prune();
	}

	/*********************** Immutable Implementation of HKMAMarginReport  ***********************/
	class HKMAMarginReportImpl implements HKMAMarginReport {
		private final ZonedDateTime reportingTimestamp;
		private final String counterparty1;
		private final String counterparty2;
		private final String counterparty2Name;
		private final Boolean counterparty2IdentifierTypeIndicator;
		private final Boolean collateralPortfolioIndicator;
		private final BigDecimal initialMarginPostedByTheReportingCounterparty1PreHaircut;
		private final BigDecimal initialMarginPostedByTheReportingCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum currencyOfInitialMarginPosted;
		private final BigDecimal initialMarginCollectedByTheReportingCounterparty1PreHaircut;
		private final BigDecimal initialMarginCollectedByTheReportingCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum currencyOfInitialMarginCollected;
		private final BigDecimal variationMarginPostedByTheReportingCounterparty1PreHaircut;
		private final BigDecimal variationMarginPostedByTheReportingCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
		private final BigDecimal variationMarginCollectedByTheReportingCounterparty1PreHaircut;
		private final BigDecimal variationMarginCollectedByTheReportingCounterparty1PostHaircut;
		private final ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
		private final BigDecimal excessCollateralPostedByTheCounterparty1;
		private final String currencyOfExcessCollateralPosted;
		private final BigDecimal excessCollateralCollectedByTheCounterparty1;
		private final String currencyOfTheExcessCollateralCollected;
		private final CollateralisationType3Code__1 collateralisationCategory;
		private final MarginActionEnum actionType;
		private final ZonedDateTime eventTimestamp;
		private final String uniqueTransactionIdentifier;
		private final String initialMarginCollateralPortfolioCode;
		private final Boolean portfolioContainingNonReportableComponentIndicator;
		private final String variationMarginCollateralPortfolioCode;
		private final String submitterIdentifier;
		private final String entityResponsibleForReporting;
		private final ZonedDateTime collateralTimestamp;
		private final BigDecimal numberRecords;
		private final String technicalRecordId;
		private final Date eventDate;
		private final PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
		
		protected HKMAMarginReportImpl(HKMAMarginReport.HKMAMarginReportBuilder builder) {
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2Name = builder.getCounterparty2Name();
			this.counterparty2IdentifierTypeIndicator = builder.getCounterparty2IdentifierTypeIndicator();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.initialMarginPostedByTheReportingCounterparty1PreHaircut = builder.getInitialMarginPostedByTheReportingCounterparty1PreHaircut();
			this.initialMarginPostedByTheReportingCounterparty1PostHaircut = builder.getInitialMarginPostedByTheReportingCounterparty1PostHaircut();
			this.currencyOfInitialMarginPosted = builder.getCurrencyOfInitialMarginPosted();
			this.initialMarginCollectedByTheReportingCounterparty1PreHaircut = builder.getInitialMarginCollectedByTheReportingCounterparty1PreHaircut();
			this.initialMarginCollectedByTheReportingCounterparty1PostHaircut = builder.getInitialMarginCollectedByTheReportingCounterparty1PostHaircut();
			this.currencyOfInitialMarginCollected = builder.getCurrencyOfInitialMarginCollected();
			this.variationMarginPostedByTheReportingCounterparty1PreHaircut = builder.getVariationMarginPostedByTheReportingCounterparty1PreHaircut();
			this.variationMarginPostedByTheReportingCounterparty1PostHaircut = builder.getVariationMarginPostedByTheReportingCounterparty1PostHaircut();
			this.currencyOfVariationMarginPosted = builder.getCurrencyOfVariationMarginPosted();
			this.variationMarginCollectedByTheReportingCounterparty1PreHaircut = builder.getVariationMarginCollectedByTheReportingCounterparty1PreHaircut();
			this.variationMarginCollectedByTheReportingCounterparty1PostHaircut = builder.getVariationMarginCollectedByTheReportingCounterparty1PostHaircut();
			this.currencyOfVariationMarginCollected = builder.getCurrencyOfVariationMarginCollected();
			this.excessCollateralPostedByTheCounterparty1 = builder.getExcessCollateralPostedByTheCounterparty1();
			this.currencyOfExcessCollateralPosted = builder.getCurrencyOfExcessCollateralPosted();
			this.excessCollateralCollectedByTheCounterparty1 = builder.getExcessCollateralCollectedByTheCounterparty1();
			this.currencyOfTheExcessCollateralCollected = builder.getCurrencyOfTheExcessCollateralCollected();
			this.collateralisationCategory = builder.getCollateralisationCategory();
			this.actionType = builder.getActionType();
			this.eventTimestamp = builder.getEventTimestamp();
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.portfolioContainingNonReportableComponentIndicator = builder.getPortfolioContainingNonReportableComponentIndicator();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.submitterIdentifier = builder.getSubmitterIdentifier();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.collateralTimestamp = builder.getCollateralTimestamp();
			this.numberRecords = builder.getNumberRecords();
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.eventDate = builder.getEventDate();
			this.counterparty2IdentifierFormat = builder.getCounterparty2IdentifierFormat();
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public String getCounterparty2Name() {
			return counterparty2Name;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierTypeIndicator")
		@RuneAttribute("counterparty2IdentifierTypeIndicator")
		public Boolean getCounterparty2IdentifierTypeIndicator() {
			return counterparty2IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterparty1PreHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterparty1PreHaircut() {
			return initialMarginPostedByTheReportingCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterparty1PostHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterparty1PostHaircut() {
			return initialMarginPostedByTheReportingCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginPosted")
		@RuneAttribute("currencyOfInitialMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted() {
			return currencyOfInitialMarginPosted;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterparty1PreHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingCounterparty1PreHaircut() {
			return initialMarginCollectedByTheReportingCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterparty1PostHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingCounterparty1PostHaircut() {
			return initialMarginCollectedByTheReportingCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginCollected")
		@RuneAttribute("currencyOfInitialMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected() {
			return currencyOfInitialMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterparty1PreHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterparty1PreHaircut() {
			return variationMarginPostedByTheReportingCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterparty1PostHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterparty1PostHaircut() {
			return variationMarginPostedByTheReportingCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
			return currencyOfVariationMarginPosted;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterparty1PreHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterparty1PreHaircut() {
			return variationMarginCollectedByTheReportingCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterparty1PostHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterparty1PostHaircut() {
			return variationMarginCollectedByTheReportingCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
			return currencyOfVariationMarginCollected;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByTheCounterparty1")
		@RuneAttribute("excessCollateralPostedByTheCounterparty1")
		public BigDecimal getExcessCollateralPostedByTheCounterparty1() {
			return excessCollateralPostedByTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfExcessCollateralPosted")
		@RuneAttribute("currencyOfExcessCollateralPosted")
		public String getCurrencyOfExcessCollateralPosted() {
			return currencyOfExcessCollateralPosted;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByTheCounterparty1")
		@RuneAttribute("excessCollateralCollectedByTheCounterparty1")
		public BigDecimal getExcessCollateralCollectedByTheCounterparty1() {
			return excessCollateralCollectedByTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		public String getCurrencyOfTheExcessCollateralCollected() {
			return currencyOfTheExcessCollateralCollected;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("portfolioContainingNonReportableComponentIndicator")
		@RuneAttribute("portfolioContainingNonReportableComponentIndicator")
		public Boolean getPortfolioContainingNonReportableComponentIndicator() {
			return portfolioContainingNonReportableComponentIndicator;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("submitterIdentifier")
		@RuneAttribute("submitterIdentifier")
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		public ZonedDateTime getCollateralTimestamp() {
			return collateralTimestamp;
		}
		
		@Override
		@RosettaAttribute("numberRecords")
		@RuneAttribute("numberRecords")
		public BigDecimal getNumberRecords() {
			return numberRecords;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
			return counterparty2IdentifierFormat;
		}
		
		@Override
		public HKMAMarginReport build() {
			return this;
		}
		
		@Override
		public HKMAMarginReport.HKMAMarginReportBuilder toBuilder() {
			HKMAMarginReport.HKMAMarginReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(HKMAMarginReport.HKMAMarginReportBuilder builder) {
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
			ofNullable(getCounterparty2IdentifierTypeIndicator()).ifPresent(builder::setCounterparty2IdentifierTypeIndicator);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getInitialMarginPostedByTheReportingCounterparty1PreHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterparty1PreHaircut);
			ofNullable(getInitialMarginPostedByTheReportingCounterparty1PostHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterparty1PostHaircut);
			ofNullable(getCurrencyOfInitialMarginPosted()).ifPresent(builder::setCurrencyOfInitialMarginPosted);
			ofNullable(getInitialMarginCollectedByTheReportingCounterparty1PreHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingCounterparty1PreHaircut);
			ofNullable(getInitialMarginCollectedByTheReportingCounterparty1PostHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingCounterparty1PostHaircut);
			ofNullable(getCurrencyOfInitialMarginCollected()).ifPresent(builder::setCurrencyOfInitialMarginCollected);
			ofNullable(getVariationMarginPostedByTheReportingCounterparty1PreHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterparty1PreHaircut);
			ofNullable(getVariationMarginPostedByTheReportingCounterparty1PostHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterparty1PostHaircut);
			ofNullable(getCurrencyOfVariationMarginPosted()).ifPresent(builder::setCurrencyOfVariationMarginPosted);
			ofNullable(getVariationMarginCollectedByTheReportingCounterparty1PreHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterparty1PreHaircut);
			ofNullable(getVariationMarginCollectedByTheReportingCounterparty1PostHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterparty1PostHaircut);
			ofNullable(getCurrencyOfVariationMarginCollected()).ifPresent(builder::setCurrencyOfVariationMarginCollected);
			ofNullable(getExcessCollateralPostedByTheCounterparty1()).ifPresent(builder::setExcessCollateralPostedByTheCounterparty1);
			ofNullable(getCurrencyOfExcessCollateralPosted()).ifPresent(builder::setCurrencyOfExcessCollateralPosted);
			ofNullable(getExcessCollateralCollectedByTheCounterparty1()).ifPresent(builder::setExcessCollateralCollectedByTheCounterparty1);
			ofNullable(getCurrencyOfTheExcessCollateralCollected()).ifPresent(builder::setCurrencyOfTheExcessCollateralCollected);
			ofNullable(getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getEventTimestamp()).ifPresent(builder::setEventTimestamp);
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getPortfolioContainingNonReportableComponentIndicator()).ifPresent(builder::setPortfolioContainingNonReportableComponentIndicator);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getCollateralTimestamp()).ifPresent(builder::setCollateralTimestamp);
			ofNullable(getNumberRecords()).ifPresent(builder::setNumberRecords);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getEventDate()).ifPresent(builder::setEventDate);
			ofNullable(getCounterparty2IdentifierFormat()).ifPresent(builder::setCounterparty2IdentifierFormat);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			HKMAMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2Name, _that.getCounterparty2Name())) return false;
			if (!Objects.equals(counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterparty1PreHaircut, _that.getInitialMarginPostedByTheReportingCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterparty1PostHaircut, _that.getInitialMarginPostedByTheReportingCounterparty1PostHaircut())) return false;
			if (!Objects.equals(currencyOfInitialMarginPosted, _that.getCurrencyOfInitialMarginPosted())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingCounterparty1PreHaircut, _that.getInitialMarginCollectedByTheReportingCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingCounterparty1PostHaircut, _that.getInitialMarginCollectedByTheReportingCounterparty1PostHaircut())) return false;
			if (!Objects.equals(currencyOfInitialMarginCollected, _that.getCurrencyOfInitialMarginCollected())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterparty1PreHaircut, _that.getVariationMarginPostedByTheReportingCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterparty1PostHaircut, _that.getVariationMarginPostedByTheReportingCounterparty1PostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterparty1PreHaircut, _that.getVariationMarginCollectedByTheReportingCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterparty1PostHaircut, _that.getVariationMarginCollectedByTheReportingCounterparty1PostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) return false;
			if (!Objects.equals(excessCollateralPostedByTheCounterparty1, _that.getExcessCollateralPostedByTheCounterparty1())) return false;
			if (!Objects.equals(currencyOfExcessCollateralPosted, _that.getCurrencyOfExcessCollateralPosted())) return false;
			if (!Objects.equals(excessCollateralCollectedByTheCounterparty1, _that.getExcessCollateralCollectedByTheCounterparty1())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralCollected, _that.getCurrencyOfTheExcessCollateralCollected())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(collateralTimestamp, _that.getCollateralTimestamp())) return false;
			if (!Objects.equals(numberRecords, _that.getNumberRecords())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(counterparty2IdentifierFormat, _that.getCounterparty2IdentifierFormat())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2Name != null ? counterparty2Name.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierTypeIndicator != null ? counterparty2IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterparty1PreHaircut != null ? initialMarginPostedByTheReportingCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterparty1PostHaircut != null ? initialMarginPostedByTheReportingCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfInitialMarginPosted != null ? currencyOfInitialMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingCounterparty1PreHaircut != null ? initialMarginCollectedByTheReportingCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingCounterparty1PostHaircut != null ? initialMarginCollectedByTheReportingCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfInitialMarginCollected != null ? currencyOfInitialMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterparty1PreHaircut != null ? variationMarginPostedByTheReportingCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterparty1PostHaircut != null ? variationMarginPostedByTheReportingCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginPosted != null ? currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterparty1PreHaircut != null ? variationMarginCollectedByTheReportingCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterparty1PostHaircut != null ? variationMarginCollectedByTheReportingCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginCollected != null ? currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (excessCollateralPostedByTheCounterparty1 != null ? excessCollateralPostedByTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfExcessCollateralPosted != null ? currencyOfExcessCollateralPosted.hashCode() : 0);
			_result = 31 * _result + (excessCollateralCollectedByTheCounterparty1 != null ? excessCollateralCollectedByTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralCollected != null ? currencyOfTheExcessCollateralCollected.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (portfolioContainingNonReportableComponentIndicator != null ? portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (collateralTimestamp != null ? collateralTimestamp.hashCode() : 0);
			_result = 31 * _result + (numberRecords != null ? numberRecords.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierFormat != null ? counterparty2IdentifierFormat.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HKMAMarginReport {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2Name=" + this.counterparty2Name + ", " +
				"counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"initialMarginPostedByTheReportingCounterparty1PreHaircut=" + this.initialMarginPostedByTheReportingCounterparty1PreHaircut + ", " +
				"initialMarginPostedByTheReportingCounterparty1PostHaircut=" + this.initialMarginPostedByTheReportingCounterparty1PostHaircut + ", " +
				"currencyOfInitialMarginPosted=" + this.currencyOfInitialMarginPosted + ", " +
				"initialMarginCollectedByTheReportingCounterparty1PreHaircut=" + this.initialMarginCollectedByTheReportingCounterparty1PreHaircut + ", " +
				"initialMarginCollectedByTheReportingCounterparty1PostHaircut=" + this.initialMarginCollectedByTheReportingCounterparty1PostHaircut + ", " +
				"currencyOfInitialMarginCollected=" + this.currencyOfInitialMarginCollected + ", " +
				"variationMarginPostedByTheReportingCounterparty1PreHaircut=" + this.variationMarginPostedByTheReportingCounterparty1PreHaircut + ", " +
				"variationMarginPostedByTheReportingCounterparty1PostHaircut=" + this.variationMarginPostedByTheReportingCounterparty1PostHaircut + ", " +
				"currencyOfVariationMarginPosted=" + this.currencyOfVariationMarginPosted + ", " +
				"variationMarginCollectedByTheReportingCounterparty1PreHaircut=" + this.variationMarginCollectedByTheReportingCounterparty1PreHaircut + ", " +
				"variationMarginCollectedByTheReportingCounterparty1PostHaircut=" + this.variationMarginCollectedByTheReportingCounterparty1PostHaircut + ", " +
				"currencyOfVariationMarginCollected=" + this.currencyOfVariationMarginCollected + ", " +
				"excessCollateralPostedByTheCounterparty1=" + this.excessCollateralPostedByTheCounterparty1 + ", " +
				"currencyOfExcessCollateralPosted=" + this.currencyOfExcessCollateralPosted + ", " +
				"excessCollateralCollectedByTheCounterparty1=" + this.excessCollateralCollectedByTheCounterparty1 + ", " +
				"currencyOfTheExcessCollateralCollected=" + this.currencyOfTheExcessCollateralCollected + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"actionType=" + this.actionType + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"collateralTimestamp=" + this.collateralTimestamp + ", " +
				"numberRecords=" + this.numberRecords + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"eventDate=" + this.eventDate + ", " +
				"counterparty2IdentifierFormat=" + this.counterparty2IdentifierFormat +
			'}';
		}
	}

	/*********************** Builder Implementation of HKMAMarginReport  ***********************/
	class HKMAMarginReportBuilderImpl implements HKMAMarginReport.HKMAMarginReportBuilder {
	
		protected ZonedDateTime reportingTimestamp;
		protected String counterparty1;
		protected String counterparty2;
		protected String counterparty2Name;
		protected Boolean counterparty2IdentifierTypeIndicator;
		protected Boolean collateralPortfolioIndicator;
		protected BigDecimal initialMarginPostedByTheReportingCounterparty1PreHaircut;
		protected BigDecimal initialMarginPostedByTheReportingCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum currencyOfInitialMarginPosted;
		protected BigDecimal initialMarginCollectedByTheReportingCounterparty1PreHaircut;
		protected BigDecimal initialMarginCollectedByTheReportingCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum currencyOfInitialMarginCollected;
		protected BigDecimal variationMarginPostedByTheReportingCounterparty1PreHaircut;
		protected BigDecimal variationMarginPostedByTheReportingCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
		protected BigDecimal variationMarginCollectedByTheReportingCounterparty1PreHaircut;
		protected BigDecimal variationMarginCollectedByTheReportingCounterparty1PostHaircut;
		protected ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
		protected BigDecimal excessCollateralPostedByTheCounterparty1;
		protected String currencyOfExcessCollateralPosted;
		protected BigDecimal excessCollateralCollectedByTheCounterparty1;
		protected String currencyOfTheExcessCollateralCollected;
		protected CollateralisationType3Code__1 collateralisationCategory;
		protected MarginActionEnum actionType;
		protected ZonedDateTime eventTimestamp;
		protected String uniqueTransactionIdentifier;
		protected String initialMarginCollateralPortfolioCode;
		protected Boolean portfolioContainingNonReportableComponentIndicator;
		protected String variationMarginCollateralPortfolioCode;
		protected String submitterIdentifier;
		protected String entityResponsibleForReporting;
		protected ZonedDateTime collateralTimestamp;
		protected BigDecimal numberRecords;
		protected String technicalRecordId;
		protected Date eventDate;
		protected PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public String getCounterparty2Name() {
			return counterparty2Name;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierTypeIndicator")
		@RuneAttribute("counterparty2IdentifierTypeIndicator")
		public Boolean getCounterparty2IdentifierTypeIndicator() {
			return counterparty2IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterparty1PreHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterparty1PreHaircut() {
			return initialMarginPostedByTheReportingCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterparty1PostHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterparty1PostHaircut() {
			return initialMarginPostedByTheReportingCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginPosted")
		@RuneAttribute("currencyOfInitialMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted() {
			return currencyOfInitialMarginPosted;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterparty1PreHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingCounterparty1PreHaircut() {
			return initialMarginCollectedByTheReportingCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterparty1PostHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingCounterparty1PostHaircut() {
			return initialMarginCollectedByTheReportingCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginCollected")
		@RuneAttribute("currencyOfInitialMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected() {
			return currencyOfInitialMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterparty1PreHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterparty1PreHaircut() {
			return variationMarginPostedByTheReportingCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterparty1PostHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterparty1PostHaircut() {
			return variationMarginPostedByTheReportingCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
			return currencyOfVariationMarginPosted;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterparty1PreHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterparty1PreHaircut() {
			return variationMarginCollectedByTheReportingCounterparty1PreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterparty1PostHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterparty1PostHaircut() {
			return variationMarginCollectedByTheReportingCounterparty1PostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
			return currencyOfVariationMarginCollected;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByTheCounterparty1")
		@RuneAttribute("excessCollateralPostedByTheCounterparty1")
		public BigDecimal getExcessCollateralPostedByTheCounterparty1() {
			return excessCollateralPostedByTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfExcessCollateralPosted")
		@RuneAttribute("currencyOfExcessCollateralPosted")
		public String getCurrencyOfExcessCollateralPosted() {
			return currencyOfExcessCollateralPosted;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByTheCounterparty1")
		@RuneAttribute("excessCollateralCollectedByTheCounterparty1")
		public BigDecimal getExcessCollateralCollectedByTheCounterparty1() {
			return excessCollateralCollectedByTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		public String getCurrencyOfTheExcessCollateralCollected() {
			return currencyOfTheExcessCollateralCollected;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("portfolioContainingNonReportableComponentIndicator")
		@RuneAttribute("portfolioContainingNonReportableComponentIndicator")
		public Boolean getPortfolioContainingNonReportableComponentIndicator() {
			return portfolioContainingNonReportableComponentIndicator;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("submitterIdentifier")
		@RuneAttribute("submitterIdentifier")
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		public ZonedDateTime getCollateralTimestamp() {
			return collateralTimestamp;
		}
		
		@Override
		@RosettaAttribute("numberRecords")
		@RuneAttribute("numberRecords")
		public BigDecimal getNumberRecords() {
			return numberRecords;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
			return counterparty2IdentifierFormat;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public HKMAMarginReport.HKMAMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public HKMAMarginReport.HKMAMarginReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public HKMAMarginReport.HKMAMarginReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public HKMAMarginReport.HKMAMarginReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierTypeIndicator")
		@RuneAttribute("counterparty2IdentifierTypeIndicator")
		public HKMAMarginReport.HKMAMarginReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean _counterparty2IdentifierTypeIndicator) {
			this.counterparty2IdentifierTypeIndicator = _counterparty2IdentifierTypeIndicator == null ? null : _counterparty2IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public HKMAMarginReport.HKMAMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterparty1PreHaircut")
		public HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginPostedByTheReportingCounterparty1PreHaircut(BigDecimal _initialMarginPostedByTheReportingCounterparty1PreHaircut) {
			this.initialMarginPostedByTheReportingCounterparty1PreHaircut = _initialMarginPostedByTheReportingCounterparty1PreHaircut == null ? null : _initialMarginPostedByTheReportingCounterparty1PreHaircut;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterparty1PostHaircut")
		public HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginPostedByTheReportingCounterparty1PostHaircut(BigDecimal _initialMarginPostedByTheReportingCounterparty1PostHaircut) {
			this.initialMarginPostedByTheReportingCounterparty1PostHaircut = _initialMarginPostedByTheReportingCounterparty1PostHaircut == null ? null : _initialMarginPostedByTheReportingCounterparty1PostHaircut;
			return this;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginPosted")
		@RuneAttribute("currencyOfInitialMarginPosted")
		public HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfInitialMarginPosted(ISOCurrencyCodeEnum _currencyOfInitialMarginPosted) {
			this.currencyOfInitialMarginPosted = _currencyOfInitialMarginPosted == null ? null : _currencyOfInitialMarginPosted;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterparty1PreHaircut")
		public HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginCollectedByTheReportingCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByTheReportingCounterparty1PreHaircut) {
			this.initialMarginCollectedByTheReportingCounterparty1PreHaircut = _initialMarginCollectedByTheReportingCounterparty1PreHaircut == null ? null : _initialMarginCollectedByTheReportingCounterparty1PreHaircut;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterparty1PostHaircut")
		public HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginCollectedByTheReportingCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByTheReportingCounterparty1PostHaircut) {
			this.initialMarginCollectedByTheReportingCounterparty1PostHaircut = _initialMarginCollectedByTheReportingCounterparty1PostHaircut == null ? null : _initialMarginCollectedByTheReportingCounterparty1PostHaircut;
			return this;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginCollected")
		@RuneAttribute("currencyOfInitialMarginCollected")
		public HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfInitialMarginCollected(ISOCurrencyCodeEnum _currencyOfInitialMarginCollected) {
			this.currencyOfInitialMarginCollected = _currencyOfInitialMarginCollected == null ? null : _currencyOfInitialMarginCollected;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterparty1PreHaircut")
		public HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginPostedByTheReportingCounterparty1PreHaircut(BigDecimal _variationMarginPostedByTheReportingCounterparty1PreHaircut) {
			this.variationMarginPostedByTheReportingCounterparty1PreHaircut = _variationMarginPostedByTheReportingCounterparty1PreHaircut == null ? null : _variationMarginPostedByTheReportingCounterparty1PreHaircut;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterparty1PostHaircut")
		public HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginPostedByTheReportingCounterparty1PostHaircut(BigDecimal _variationMarginPostedByTheReportingCounterparty1PostHaircut) {
			this.variationMarginPostedByTheReportingCounterparty1PostHaircut = _variationMarginPostedByTheReportingCounterparty1PostHaircut == null ? null : _variationMarginPostedByTheReportingCounterparty1PostHaircut;
			return this;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum _currencyOfVariationMarginPosted) {
			this.currencyOfVariationMarginPosted = _currencyOfVariationMarginPosted == null ? null : _currencyOfVariationMarginPosted;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterparty1PreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterparty1PreHaircut")
		public HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginCollectedByTheReportingCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterparty1PreHaircut) {
			this.variationMarginCollectedByTheReportingCounterparty1PreHaircut = _variationMarginCollectedByTheReportingCounterparty1PreHaircut == null ? null : _variationMarginCollectedByTheReportingCounterparty1PreHaircut;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterparty1PostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterparty1PostHaircut")
		public HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginCollectedByTheReportingCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterparty1PostHaircut) {
			this.variationMarginCollectedByTheReportingCounterparty1PostHaircut = _variationMarginCollectedByTheReportingCounterparty1PostHaircut == null ? null : _variationMarginCollectedByTheReportingCounterparty1PostHaircut;
			return this;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum _currencyOfVariationMarginCollected) {
			this.currencyOfVariationMarginCollected = _currencyOfVariationMarginCollected == null ? null : _currencyOfVariationMarginCollected;
			return this;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByTheCounterparty1")
		@RuneAttribute("excessCollateralPostedByTheCounterparty1")
		public HKMAMarginReport.HKMAMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal _excessCollateralPostedByTheCounterparty1) {
			this.excessCollateralPostedByTheCounterparty1 = _excessCollateralPostedByTheCounterparty1 == null ? null : _excessCollateralPostedByTheCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("currencyOfExcessCollateralPosted")
		@RuneAttribute("currencyOfExcessCollateralPosted")
		public HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfExcessCollateralPosted(String _currencyOfExcessCollateralPosted) {
			this.currencyOfExcessCollateralPosted = _currencyOfExcessCollateralPosted == null ? null : _currencyOfExcessCollateralPosted;
			return this;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByTheCounterparty1")
		@RuneAttribute("excessCollateralCollectedByTheCounterparty1")
		public HKMAMarginReport.HKMAMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal _excessCollateralCollectedByTheCounterparty1) {
			this.excessCollateralCollectedByTheCounterparty1 = _excessCollateralCollectedByTheCounterparty1 == null ? null : _excessCollateralCollectedByTheCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		public HKMAMarginReport.HKMAMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
			this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public HKMAMarginReport.HKMAMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
			this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
			return this;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public HKMAMarginReport.HKMAMarginReportBuilder setActionType(MarginActionEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public HKMAMarginReport.HKMAMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public HKMAMarginReport.HKMAMarginReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public HKMAMarginReport.HKMAMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("portfolioContainingNonReportableComponentIndicator")
		@RuneAttribute("portfolioContainingNonReportableComponentIndicator")
		public HKMAMarginReport.HKMAMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean _portfolioContainingNonReportableComponentIndicator) {
			this.portfolioContainingNonReportableComponentIndicator = _portfolioContainingNonReportableComponentIndicator == null ? null : _portfolioContainingNonReportableComponentIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public HKMAMarginReport.HKMAMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("submitterIdentifier")
		@RuneAttribute("submitterIdentifier")
		public HKMAMarginReport.HKMAMarginReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
			this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public HKMAMarginReport.HKMAMarginReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		public HKMAMarginReport.HKMAMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
			this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("numberRecords")
		@RuneAttribute("numberRecords")
		public HKMAMarginReport.HKMAMarginReportBuilder setNumberRecords(BigDecimal _numberRecords) {
			this.numberRecords = _numberRecords == null ? null : _numberRecords;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public HKMAMarginReport.HKMAMarginReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public HKMAMarginReport.HKMAMarginReportBuilder setEventDate(Date _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public HKMAMarginReport.HKMAMarginReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum _counterparty2IdentifierFormat) {
			this.counterparty2IdentifierFormat = _counterparty2IdentifierFormat == null ? null : _counterparty2IdentifierFormat;
			return this;
		}
		
		@Override
		public HKMAMarginReport build() {
			return new HKMAMarginReport.HKMAMarginReportImpl(this);
		}
		
		@Override
		public HKMAMarginReport.HKMAMarginReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HKMAMarginReport.HKMAMarginReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getReportingTimestamp()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2Name()!=null) return true;
			if (getCounterparty2IdentifierTypeIndicator()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getInitialMarginPostedByTheReportingCounterparty1PreHaircut()!=null) return true;
			if (getInitialMarginPostedByTheReportingCounterparty1PostHaircut()!=null) return true;
			if (getCurrencyOfInitialMarginPosted()!=null) return true;
			if (getInitialMarginCollectedByTheReportingCounterparty1PreHaircut()!=null) return true;
			if (getInitialMarginCollectedByTheReportingCounterparty1PostHaircut()!=null) return true;
			if (getCurrencyOfInitialMarginCollected()!=null) return true;
			if (getVariationMarginPostedByTheReportingCounterparty1PreHaircut()!=null) return true;
			if (getVariationMarginPostedByTheReportingCounterparty1PostHaircut()!=null) return true;
			if (getCurrencyOfVariationMarginPosted()!=null) return true;
			if (getVariationMarginCollectedByTheReportingCounterparty1PreHaircut()!=null) return true;
			if (getVariationMarginCollectedByTheReportingCounterparty1PostHaircut()!=null) return true;
			if (getCurrencyOfVariationMarginCollected()!=null) return true;
			if (getExcessCollateralPostedByTheCounterparty1()!=null) return true;
			if (getCurrencyOfExcessCollateralPosted()!=null) return true;
			if (getExcessCollateralCollectedByTheCounterparty1()!=null) return true;
			if (getCurrencyOfTheExcessCollateralCollected()!=null) return true;
			if (getCollateralisationCategory()!=null) return true;
			if (getActionType()!=null) return true;
			if (getEventTimestamp()!=null) return true;
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getPortfolioContainingNonReportableComponentIndicator()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getSubmitterIdentifier()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getCollateralTimestamp()!=null) return true;
			if (getNumberRecords()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getEventDate()!=null) return true;
			if (getCounterparty2IdentifierFormat()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HKMAMarginReport.HKMAMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			HKMAMarginReport.HKMAMarginReportBuilder o = (HKMAMarginReport.HKMAMarginReportBuilder) other;
			
			
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2Name(), o.getCounterparty2Name(), this::setCounterparty2Name);
			merger.mergeBasic(getCounterparty2IdentifierTypeIndicator(), o.getCounterparty2IdentifierTypeIndicator(), this::setCounterparty2IdentifierTypeIndicator);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getInitialMarginPostedByTheReportingCounterparty1PreHaircut(), o.getInitialMarginPostedByTheReportingCounterparty1PreHaircut(), this::setInitialMarginPostedByTheReportingCounterparty1PreHaircut);
			merger.mergeBasic(getInitialMarginPostedByTheReportingCounterparty1PostHaircut(), o.getInitialMarginPostedByTheReportingCounterparty1PostHaircut(), this::setInitialMarginPostedByTheReportingCounterparty1PostHaircut);
			merger.mergeBasic(getCurrencyOfInitialMarginPosted(), o.getCurrencyOfInitialMarginPosted(), this::setCurrencyOfInitialMarginPosted);
			merger.mergeBasic(getInitialMarginCollectedByTheReportingCounterparty1PreHaircut(), o.getInitialMarginCollectedByTheReportingCounterparty1PreHaircut(), this::setInitialMarginCollectedByTheReportingCounterparty1PreHaircut);
			merger.mergeBasic(getInitialMarginCollectedByTheReportingCounterparty1PostHaircut(), o.getInitialMarginCollectedByTheReportingCounterparty1PostHaircut(), this::setInitialMarginCollectedByTheReportingCounterparty1PostHaircut);
			merger.mergeBasic(getCurrencyOfInitialMarginCollected(), o.getCurrencyOfInitialMarginCollected(), this::setCurrencyOfInitialMarginCollected);
			merger.mergeBasic(getVariationMarginPostedByTheReportingCounterparty1PreHaircut(), o.getVariationMarginPostedByTheReportingCounterparty1PreHaircut(), this::setVariationMarginPostedByTheReportingCounterparty1PreHaircut);
			merger.mergeBasic(getVariationMarginPostedByTheReportingCounterparty1PostHaircut(), o.getVariationMarginPostedByTheReportingCounterparty1PostHaircut(), this::setVariationMarginPostedByTheReportingCounterparty1PostHaircut);
			merger.mergeBasic(getCurrencyOfVariationMarginPosted(), o.getCurrencyOfVariationMarginPosted(), this::setCurrencyOfVariationMarginPosted);
			merger.mergeBasic(getVariationMarginCollectedByTheReportingCounterparty1PreHaircut(), o.getVariationMarginCollectedByTheReportingCounterparty1PreHaircut(), this::setVariationMarginCollectedByTheReportingCounterparty1PreHaircut);
			merger.mergeBasic(getVariationMarginCollectedByTheReportingCounterparty1PostHaircut(), o.getVariationMarginCollectedByTheReportingCounterparty1PostHaircut(), this::setVariationMarginCollectedByTheReportingCounterparty1PostHaircut);
			merger.mergeBasic(getCurrencyOfVariationMarginCollected(), o.getCurrencyOfVariationMarginCollected(), this::setCurrencyOfVariationMarginCollected);
			merger.mergeBasic(getExcessCollateralPostedByTheCounterparty1(), o.getExcessCollateralPostedByTheCounterparty1(), this::setExcessCollateralPostedByTheCounterparty1);
			merger.mergeBasic(getCurrencyOfExcessCollateralPosted(), o.getCurrencyOfExcessCollateralPosted(), this::setCurrencyOfExcessCollateralPosted);
			merger.mergeBasic(getExcessCollateralCollectedByTheCounterparty1(), o.getExcessCollateralCollectedByTheCounterparty1(), this::setExcessCollateralCollectedByTheCounterparty1);
			merger.mergeBasic(getCurrencyOfTheExcessCollateralCollected(), o.getCurrencyOfTheExcessCollateralCollected(), this::setCurrencyOfTheExcessCollateralCollected);
			merger.mergeBasic(getCollateralisationCategory(), o.getCollateralisationCategory(), this::setCollateralisationCategory);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getEventTimestamp(), o.getEventTimestamp(), this::setEventTimestamp);
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getPortfolioContainingNonReportableComponentIndicator(), o.getPortfolioContainingNonReportableComponentIndicator(), this::setPortfolioContainingNonReportableComponentIndicator);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getSubmitterIdentifier(), o.getSubmitterIdentifier(), this::setSubmitterIdentifier);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getCollateralTimestamp(), o.getCollateralTimestamp(), this::setCollateralTimestamp);
			merger.mergeBasic(getNumberRecords(), o.getNumberRecords(), this::setNumberRecords);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			merger.mergeBasic(getEventDate(), o.getEventDate(), this::setEventDate);
			merger.mergeBasic(getCounterparty2IdentifierFormat(), o.getCounterparty2IdentifierFormat(), this::setCounterparty2IdentifierFormat);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			HKMAMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2Name, _that.getCounterparty2Name())) return false;
			if (!Objects.equals(counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterparty1PreHaircut, _that.getInitialMarginPostedByTheReportingCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterparty1PostHaircut, _that.getInitialMarginPostedByTheReportingCounterparty1PostHaircut())) return false;
			if (!Objects.equals(currencyOfInitialMarginPosted, _that.getCurrencyOfInitialMarginPosted())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingCounterparty1PreHaircut, _that.getInitialMarginCollectedByTheReportingCounterparty1PreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingCounterparty1PostHaircut, _that.getInitialMarginCollectedByTheReportingCounterparty1PostHaircut())) return false;
			if (!Objects.equals(currencyOfInitialMarginCollected, _that.getCurrencyOfInitialMarginCollected())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterparty1PreHaircut, _that.getVariationMarginPostedByTheReportingCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterparty1PostHaircut, _that.getVariationMarginPostedByTheReportingCounterparty1PostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterparty1PreHaircut, _that.getVariationMarginCollectedByTheReportingCounterparty1PreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterparty1PostHaircut, _that.getVariationMarginCollectedByTheReportingCounterparty1PostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) return false;
			if (!Objects.equals(excessCollateralPostedByTheCounterparty1, _that.getExcessCollateralPostedByTheCounterparty1())) return false;
			if (!Objects.equals(currencyOfExcessCollateralPosted, _that.getCurrencyOfExcessCollateralPosted())) return false;
			if (!Objects.equals(excessCollateralCollectedByTheCounterparty1, _that.getExcessCollateralCollectedByTheCounterparty1())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralCollected, _that.getCurrencyOfTheExcessCollateralCollected())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(collateralTimestamp, _that.getCollateralTimestamp())) return false;
			if (!Objects.equals(numberRecords, _that.getNumberRecords())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(counterparty2IdentifierFormat, _that.getCounterparty2IdentifierFormat())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2Name != null ? counterparty2Name.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierTypeIndicator != null ? counterparty2IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterparty1PreHaircut != null ? initialMarginPostedByTheReportingCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterparty1PostHaircut != null ? initialMarginPostedByTheReportingCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfInitialMarginPosted != null ? currencyOfInitialMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingCounterparty1PreHaircut != null ? initialMarginCollectedByTheReportingCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingCounterparty1PostHaircut != null ? initialMarginCollectedByTheReportingCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfInitialMarginCollected != null ? currencyOfInitialMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterparty1PreHaircut != null ? variationMarginPostedByTheReportingCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterparty1PostHaircut != null ? variationMarginPostedByTheReportingCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginPosted != null ? currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterparty1PreHaircut != null ? variationMarginCollectedByTheReportingCounterparty1PreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterparty1PostHaircut != null ? variationMarginCollectedByTheReportingCounterparty1PostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginCollected != null ? currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (excessCollateralPostedByTheCounterparty1 != null ? excessCollateralPostedByTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfExcessCollateralPosted != null ? currencyOfExcessCollateralPosted.hashCode() : 0);
			_result = 31 * _result + (excessCollateralCollectedByTheCounterparty1 != null ? excessCollateralCollectedByTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralCollected != null ? currencyOfTheExcessCollateralCollected.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (portfolioContainingNonReportableComponentIndicator != null ? portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (collateralTimestamp != null ? collateralTimestamp.hashCode() : 0);
			_result = 31 * _result + (numberRecords != null ? numberRecords.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierFormat != null ? counterparty2IdentifierFormat.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HKMAMarginReportBuilder {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2Name=" + this.counterparty2Name + ", " +
				"counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"initialMarginPostedByTheReportingCounterparty1PreHaircut=" + this.initialMarginPostedByTheReportingCounterparty1PreHaircut + ", " +
				"initialMarginPostedByTheReportingCounterparty1PostHaircut=" + this.initialMarginPostedByTheReportingCounterparty1PostHaircut + ", " +
				"currencyOfInitialMarginPosted=" + this.currencyOfInitialMarginPosted + ", " +
				"initialMarginCollectedByTheReportingCounterparty1PreHaircut=" + this.initialMarginCollectedByTheReportingCounterparty1PreHaircut + ", " +
				"initialMarginCollectedByTheReportingCounterparty1PostHaircut=" + this.initialMarginCollectedByTheReportingCounterparty1PostHaircut + ", " +
				"currencyOfInitialMarginCollected=" + this.currencyOfInitialMarginCollected + ", " +
				"variationMarginPostedByTheReportingCounterparty1PreHaircut=" + this.variationMarginPostedByTheReportingCounterparty1PreHaircut + ", " +
				"variationMarginPostedByTheReportingCounterparty1PostHaircut=" + this.variationMarginPostedByTheReportingCounterparty1PostHaircut + ", " +
				"currencyOfVariationMarginPosted=" + this.currencyOfVariationMarginPosted + ", " +
				"variationMarginCollectedByTheReportingCounterparty1PreHaircut=" + this.variationMarginCollectedByTheReportingCounterparty1PreHaircut + ", " +
				"variationMarginCollectedByTheReportingCounterparty1PostHaircut=" + this.variationMarginCollectedByTheReportingCounterparty1PostHaircut + ", " +
				"currencyOfVariationMarginCollected=" + this.currencyOfVariationMarginCollected + ", " +
				"excessCollateralPostedByTheCounterparty1=" + this.excessCollateralPostedByTheCounterparty1 + ", " +
				"currencyOfExcessCollateralPosted=" + this.currencyOfExcessCollateralPosted + ", " +
				"excessCollateralCollectedByTheCounterparty1=" + this.excessCollateralCollectedByTheCounterparty1 + ", " +
				"currencyOfTheExcessCollateralCollected=" + this.currencyOfTheExcessCollateralCollected + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"actionType=" + this.actionType + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"collateralTimestamp=" + this.collateralTimestamp + ", " +
				"numberRecords=" + this.numberRecords + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"eventDate=" + this.eventDate + ", " +
				"counterparty2IdentifierFormat=" + this.counterparty2IdentifierFormat +
			'}';
		}
	}
}
