package drr.regulation.hkma.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport.HKMAMarginReportBuilder;
import drr.regulation.hkma.rewrite.margin.labels.HKMAMarginLabelProvider;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.hkma.rewrite.margin", body="HKMA", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=HKMAMarginLabelProvider.class)
@ImplementedBy(HKMAMarginReportFunction.HKMAMarginReportFunctionDefault.class)
public abstract class HKMAMarginReportFunction implements ReportFunction<CollateralReportInstruction, HKMAMarginReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected CollateralTimestampRule collateralTimestampRule;
	@Inject protected CollateralisationCategoryRule collateralisationCategoryRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierFormatRule counterparty2IdentifierFormatRule;
	@Inject protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
	@Inject protected Counterparty2NameRule counterparty2NameRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CurrencyOfExcessCollateralCollectedRule currencyOfExcessCollateralCollectedRule;
	@Inject protected CurrencyOfExcessCollateralPostedRule currencyOfExcessCollateralPostedRule;
	@Inject protected CurrencyOfInitialMarginCollectedRule currencyOfInitialMarginCollectedRule;
	@Inject protected CurrencyOfInitialMarginPostedRule currencyOfInitialMarginPostedRule;
	@Inject protected CurrencyOfVariationMarginCollectedRule currencyOfVariationMarginCollectedRule;
	@Inject protected CurrencyOfVariationMarginPostedRule currencyOfVariationMarginPostedRule;
	@Inject protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
	@Inject protected EventDateRule eventDateRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected ExcessCollateralCollectedByTheCounterparty1Rule excessCollateralCollectedByTheCounterparty1Rule;
	@Inject protected ExcessCollateralPostedByTheCounterparty1Rule excessCollateralPostedByTheCounterparty1Rule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected InitialMarginCollectedByTheReportingCounterparty1PostHaircutRule initialMarginCollectedByTheReportingCounterparty1PostHaircutRule;
	@Inject protected InitialMarginCollectedByTheReportingCounterparty1PreHaircutRule initialMarginCollectedByTheReportingCounterparty1PreHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingCounterparty1PostHaircutRule initialMarginPostedByTheReportingCounterparty1PostHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingCounterparty1PreHaircutRule initialMarginPostedByTheReportingCounterparty1PreHaircutRule;
	@Inject protected NumberRecordsRule numberRecordsRule;
	@Inject protected PortfolioContainingNonReportableComponentIndicatorRule portfolioContainingNonReportableComponentIndicatorRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
	@Inject protected VariationMarginPostedByTheReportingCounterparty1PostHaircutRule variationMarginPostedByTheReportingCounterparty1PostHaircutRule;
	@Inject protected VariationMarginPostedByTheReportingCounterparty1PreHaircutRule variationMarginPostedByTheReportingCounterparty1PreHaircutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public HKMAMarginReport evaluate(CollateralReportInstruction input) {
		HKMAMarginReport.HKMAMarginReportBuilder outputBuilder = doEvaluate(input);
		
		final HKMAMarginReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(HKMAMarginReport.class, output);
		}
		
		return output;
	}

	protected abstract HKMAMarginReport.HKMAMarginReportBuilder doEvaluate(CollateralReportInstruction input);

	public static class HKMAMarginReportFunctionDefault extends HKMAMarginReportFunction {
		@Override
		protected HKMAMarginReport.HKMAMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
			HKMAMarginReport.HKMAMarginReportBuilder output = HKMAMarginReport.builder();
			return assignOutput(output, input);
		}
		
		protected HKMAMarginReport.HKMAMarginReportBuilder assignOutput(HKMAMarginReport.HKMAMarginReportBuilder output, CollateralReportInstruction input) {
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2Name(counterparty2NameRule.evaluate(input));
			
			output
				.setCounterparty2IdentifierTypeIndicator(counterparty2IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setInitialMarginPostedByTheReportingCounterparty1PreHaircut(initialMarginPostedByTheReportingCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.setInitialMarginPostedByTheReportingCounterparty1PostHaircut(initialMarginPostedByTheReportingCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfInitialMarginPosted(currencyOfInitialMarginPostedRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByTheReportingCounterparty1PreHaircut(initialMarginCollectedByTheReportingCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByTheReportingCounterparty1PostHaircut(initialMarginCollectedByTheReportingCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfInitialMarginCollected(currencyOfInitialMarginCollectedRule.evaluate(input));
			
			output
				.setVariationMarginPostedByTheReportingCounterparty1PreHaircut(variationMarginPostedByTheReportingCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.setVariationMarginPostedByTheReportingCounterparty1PostHaircut(variationMarginPostedByTheReportingCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfVariationMarginPosted(currencyOfVariationMarginPostedRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByTheReportingCounterparty1PreHaircut(variationMarginPostedByTheReportingCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByTheReportingCounterparty1PostHaircut(variationMarginPostedByTheReportingCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfVariationMarginCollected(currencyOfVariationMarginCollectedRule.evaluate(input));
			
			output
				.setExcessCollateralPostedByTheCounterparty1(excessCollateralPostedByTheCounterparty1Rule.evaluate(input));
			
			output
				.setCurrencyOfExcessCollateralPosted(currencyOfExcessCollateralPostedRule.evaluate(input));
			
			output
				.setExcessCollateralCollectedByTheCounterparty1(excessCollateralCollectedByTheCounterparty1Rule.evaluate(input));
			
			output
				.setCurrencyOfTheExcessCollateralCollected(currencyOfExcessCollateralCollectedRule.evaluate(input));
			
			output
				.setCollateralisationCategory(collateralisationCategoryRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setPortfolioContainingNonReportableComponentIndicator(portfolioContainingNonReportableComponentIndicatorRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setSubmitterIdentifier(submitterIdentifierRule.evaluate(input));
			
			output
				.setEntityResponsibleForReporting(entityResponsibleForReportingRule.evaluate(input));
			
			output
				.setCollateralTimestamp(collateralTimestampRule.evaluate(input));
			
			output
				.setNumberRecords(null);
			
			output
				.setTechnicalRecordId(technicalRecordIdRule.evaluate(input));
			
			output
				.setEventDate(eventDateRule.evaluate(input));
			
			output
				.setCounterparty2IdentifierFormat(counterparty2IdentifierFormatRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
