package drr.regulation.hkma.rewrite.margin.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.common.PartyIdentifierFormat2Enum;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class HKMAMarginReportOnlyExistsValidator implements ValidatorWithArg<HKMAMarginReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends HKMAMarginReport> ValidationResult<HKMAMarginReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2Name", ExistenceChecker.isSet((String) o.getCounterparty2Name()))
				.put("counterparty2IdentifierTypeIndicator", ExistenceChecker.isSet((Boolean) o.getCounterparty2IdentifierTypeIndicator()))
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("initialMarginPostedByTheReportingCounterparty1PreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByTheReportingCounterparty1PreHaircut()))
				.put("initialMarginPostedByTheReportingCounterparty1PostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByTheReportingCounterparty1PostHaircut()))
				.put("currencyOfInitialMarginPosted", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfInitialMarginPosted()))
				.put("initialMarginCollectedByTheReportingCounterparty1PreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByTheReportingCounterparty1PreHaircut()))
				.put("initialMarginCollectedByTheReportingCounterparty1PostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByTheReportingCounterparty1PostHaircut()))
				.put("currencyOfInitialMarginCollected", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfInitialMarginCollected()))
				.put("variationMarginPostedByTheReportingCounterparty1PreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginPostedByTheReportingCounterparty1PreHaircut()))
				.put("variationMarginPostedByTheReportingCounterparty1PostHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginPostedByTheReportingCounterparty1PostHaircut()))
				.put("currencyOfVariationMarginPosted", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginPosted()))
				.put("variationMarginCollectedByTheReportingCounterparty1PreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginCollectedByTheReportingCounterparty1PreHaircut()))
				.put("variationMarginCollectedByTheReportingCounterparty1PostHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginCollectedByTheReportingCounterparty1PostHaircut()))
				.put("currencyOfVariationMarginCollected", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginCollected()))
				.put("excessCollateralPostedByTheCounterparty1", ExistenceChecker.isSet((BigDecimal) o.getExcessCollateralPostedByTheCounterparty1()))
				.put("currencyOfExcessCollateralPosted", ExistenceChecker.isSet((String) o.getCurrencyOfExcessCollateralPosted()))
				.put("excessCollateralCollectedByTheCounterparty1", ExistenceChecker.isSet((BigDecimal) o.getExcessCollateralCollectedByTheCounterparty1()))
				.put("currencyOfTheExcessCollateralCollected", ExistenceChecker.isSet((String) o.getCurrencyOfTheExcessCollateralCollected()))
				.put("collateralisationCategory", ExistenceChecker.isSet((CollateralisationType3Code__1) o.getCollateralisationCategory()))
				.put("actionType", ExistenceChecker.isSet((MarginActionEnum) o.getActionType()))
				.put("eventTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getEventTimestamp()))
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("portfolioContainingNonReportableComponentIndicator", ExistenceChecker.isSet((Boolean) o.getPortfolioContainingNonReportableComponentIndicator()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("submitterIdentifier", ExistenceChecker.isSet((String) o.getSubmitterIdentifier()))
				.put("entityResponsibleForReporting", ExistenceChecker.isSet((String) o.getEntityResponsibleForReporting()))
				.put("collateralTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getCollateralTimestamp()))
				.put("numberRecords", ExistenceChecker.isSet((BigDecimal) o.getNumberRecords()))
				.put("technicalRecordId", ExistenceChecker.isSet((String) o.getTechnicalRecordId()))
				.put("eventDate", ExistenceChecker.isSet((Date) o.getEventDate()))
				.put("counterparty2IdentifierFormat", ExistenceChecker.isSet((PartyIdentifierFormat2Enum) o.getCounterparty2IdentifierFormat()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("HKMAMarginReport", ValidationType.ONLY_EXISTS, "HKMAMarginReport", path, "");
		}
		return failure("HKMAMarginReport", ValidationType.ONLY_EXISTS, "HKMAMarginReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
