package drr.regulation.hkma.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.PartyIdentifierFormat2Enum;
import drr.regulation.common.ReferenceEntityFormatEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilder;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilderImpl;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportImpl;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.common.trade.basket.BasketConstituentsReport.BasketConstituentsReportBuilder;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilder;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport.HKMATransactionReportBuilder;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport.HKMATransactionReportBuilderImpl;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport.HKMATransactionReportImpl;
import drr.regulation.hkma.rewrite.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.hkma.rewrite.trade.NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder;
import drr.regulation.hkma.rewrite.trade.NotionalQuantityScheduleLeg2Report;
import drr.regulation.hkma.rewrite.trade.NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder;
import drr.regulation.hkma.rewrite.trade.meta.HKMATransactionReportMeta;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.payment.OtherPayment.OtherPaymentBuilder;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceFormat.PriceFormatBuilder;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.price.PricePeriod.PricePeriodBuilder;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="HKMATransactionReport", builder=HKMATransactionReport.HKMATransactionReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="HKMATransactionReport", model="drr", builder=HKMATransactionReport.HKMATransactionReportBuilderImpl.class, version="6.0.0-dev.128")
public interface HKMATransactionReport extends CommonTransactionReport {

	HKMATransactionReportMeta metaData = new HKMATransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	String getSettlementLocation();
	String getBaseProduct();
	String getSubProduct();
	String getFurtherSubProduct();
	String getReferenceEntity();
	Integer getSeriesVersion();
	/**
	 *
	 * Body HKMA
	 * Corpus Dissemination Trade   
	 * dataElement "102/104/106" * field "Notional Quantity Schedule - Leg 1"
	 *
	 * Provision Fields 102/104/106 are repeatable and shall be populated in the case of derivatives involving notional quantity schedules.
	 *
	 */
	List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1();
	/**
	 *
	 * Body HKMA
	 * Corpus Dissemination Trade   
	 * dataElement "103/105/107" * field "Notional Quantity Schedule - Leg 2"
	 *
	 * Provision Fields 103/105/107 are repeatable and shall be populated in the case of derivatives involving notional quantity schedules.
	 *
	 */
	List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2();
	String getCustomBasketCode();
	List<BigDecimal> getBasketConstituentNumberOfUnits();
	List<String> getBasketConstituentUnitOfMeasure();
	String getUnderlyingIdOther();
	ProductIdTypeEnum getUnderlyingIdOtherSource();
	String getUnderlyingAssetTradingPlatformIdentifier();
	String getUnderlyingAssetPriceSource();
	String getUnderlyingIdentification();
	String getUnderlyingIdentificationType();
	Boolean getCryptoAssetUnderlyingIndicator();
	String getInitialMarginCollateralPortfolioCode();
	String getVariationMarginCollateralPortfolioCode();
	String getEntityResponsibleForReporting();
	String getBrokerId();
	Boolean getIntragroup();
	String getNatureOfTheCounterparty1();
	String getNatureOfTheCounterparty2();
	Boolean getNonStandardizedTermIndicator();
	BigDecimal getLowerBarrierLevel();
	BigDecimal getUpperBarrierLevel();
	BigDecimal getSingleBarrierLevel();
	String getProductDescription();
	String getBeneficiary();
	String getRemarks();
	String getSwapLinkID();
	String getSecondaryTransactionIdentifier();
	String getUniqueProductIdentifierProprietary();
	String getSectorOfTheCounterparty1();
	String getSectorOfTheCounterparty2();
	PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat();
	ReferenceEntityFormatEnum getReferenceEntityFormat();

	/*********************** Build Methods  ***********************/
	HKMATransactionReport build();
	
	HKMATransactionReport.HKMATransactionReportBuilder toBuilder();
	
	static HKMATransactionReport.HKMATransactionReportBuilder builder() {
		return new HKMATransactionReport.HKMATransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends HKMATransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends HKMATransactionReport> getType() {
		return HKMATransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, getStrikePriceSchedule());
		processRosetta(path.newSubPath("price"), processor, PriceFormat.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, getOtherPayment());
		processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, getLeg1());
		processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, getLeg2());
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
		processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
		processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, getBarrier());
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.class, getUnderlying());
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("settlementLocation"), String.class, getSettlementLocation(), this);
		processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
		processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
		processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
		processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
		processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, getSeriesVersion(), this);
		processRosetta(path.newSubPath("notionalQuantityScheduleLeg1"), processor, NotionalQuantityScheduleLeg1Report.class, getNotionalQuantityScheduleLeg1());
		processRosetta(path.newSubPath("notionalQuantityScheduleLeg2"), processor, NotionalQuantityScheduleLeg2Report.class, getNotionalQuantityScheduleLeg2());
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processor.processBasic(path.newSubPath("basketConstituentNumberOfUnits"), BigDecimal.class, getBasketConstituentNumberOfUnits(), this);
		processor.processBasic(path.newSubPath("basketConstituentUnitOfMeasure"), String.class, getBasketConstituentUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
		processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, getUnderlyingIdOtherSource(), this);
		processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, getUnderlyingAssetTradingPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, getUnderlyingAssetPriceSource(), this);
		processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
		processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
		processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, getCryptoAssetUnderlyingIndicator(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("brokerId"), String.class, getBrokerId(), this);
		processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
		processor.processBasic(path.newSubPath("natureOfTheCounterparty1"), String.class, getNatureOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("natureOfTheCounterparty2"), String.class, getNatureOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
		processor.processBasic(path.newSubPath("lowerBarrierLevel"), BigDecimal.class, getLowerBarrierLevel(), this);
		processor.processBasic(path.newSubPath("upperBarrierLevel"), BigDecimal.class, getUpperBarrierLevel(), this);
		processor.processBasic(path.newSubPath("singleBarrierLevel"), BigDecimal.class, getSingleBarrierLevel(), this);
		processor.processBasic(path.newSubPath("productDescription"), String.class, getProductDescription(), this);
		processor.processBasic(path.newSubPath("beneficiary"), String.class, getBeneficiary(), this);
		processor.processBasic(path.newSubPath("remarks"), String.class, getRemarks(), this);
		processor.processBasic(path.newSubPath("swapLinkID"), String.class, getSwapLinkID(), this);
		processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, getSecondaryTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifierProprietary"), String.class, getUniqueProductIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("sectorOfTheCounterparty1"), String.class, getSectorOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("sectorOfTheCounterparty2"), String.class, getSectorOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, getCounterparty2IdentifierFormat(), this);
		processor.processBasic(path.newSubPath("referenceEntityFormat"), ReferenceEntityFormatEnum.class, getReferenceEntityFormat(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface HKMATransactionReportBuilder extends HKMATransactionReport, CommonTransactionReport.CommonTransactionReportBuilder {
		NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1(int _index);
		@Override
		List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1();
		NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2(int _index);
		@Override
		List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2();
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setEventType(EventTypeEnum eventType);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setEventIdentifier(String eventIdentifier);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setEffectiveDate(Date effectiveDate);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setExpirationDate(Date expirationDate);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCounterparty1(String counterparty1);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCounterparty2(String counterparty2);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setBeneficiary1(String beneficiary1);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCleared(ClearedEnum cleared);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setClearingMember(String clearingMember);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setConfirmed(ConfirmationEnum confirmed);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCallAmount(BigDecimal callAmount);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPutAmount(BigDecimal putAmount);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule, int _idx);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule, int _idx);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPrice(PriceFormat price);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPriceNotation(PriceNotationEnum priceNotation);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionPrice(PriceFormat packageTransactionPrice);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionSpread(PriceFormat packageTransactionSpread);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setStrikePrice(PriceFormat strikePrice);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addOtherPayment(OtherPayment otherPayment);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addOtherPayment(OtherPayment otherPayment, int _idx);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setLeg1(Leg leg1);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setLeg2(Leg leg2);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setLeg1(CommonLeg leg1);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setLeg2(CommonLeg leg2);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setExecutionAgentCounterparty1(String executionAgentCounterparty1);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setExecutionAgentCounterparty2DTCC(String executionAgentCounterparty2DTCC);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPriorUTI(String priorUTI);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setContractType(CommonContractType contractType);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setAssetClass(CommonAssetClass assetClass);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setDirection1(Direction1Enum direction1);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setDirection2Leg1(Direction2Enum direction2Leg1);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setDirection2Leg2(Direction2Enum direction2Leg2);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier barrier);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int _idx);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setUnderlying(UnderlyingIdentifier underlying);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setOptionType(OptionTypeCode optionType);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setOptionStyle(OptionStyleEnum optionStyle);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setDeliveryType(DeliveryTypeEnum deliveryType);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum countryOfTheCounterparty2);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum bookingLocation);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum traderLocation);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setTradingCapacity(TradingCapacity7Code tradingCapacity);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum embeddedOptionType);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setSeniority(SeniorityEnum seniority);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setSeries(Integer series);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		@Override
		HKMATransactionReport.HKMATransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		HKMATransactionReport.HKMATransactionReportBuilder setSettlementLocation(String settlementLocation);
		HKMATransactionReport.HKMATransactionReportBuilder setBaseProduct(String baseProduct);
		HKMATransactionReport.HKMATransactionReportBuilder setSubProduct(String subProduct);
		HKMATransactionReport.HKMATransactionReportBuilder setFurtherSubProduct(String furtherSubProduct);
		HKMATransactionReport.HKMATransactionReportBuilder setReferenceEntity(String referenceEntity);
		HKMATransactionReport.HKMATransactionReportBuilder setSeriesVersion(Integer seriesVersion);
		HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1);
		HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1, int _idx);
		HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1);
		HKMATransactionReport.HKMATransactionReportBuilder setNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1);
		HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2);
		HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2, int _idx);
		HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2);
		HKMATransactionReport.HKMATransactionReportBuilder setNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2);
		HKMATransactionReport.HKMATransactionReportBuilder setCustomBasketCode(String customBasketCode);
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(BigDecimal basketConstituentNumberOfUnits);
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(BigDecimal basketConstituentNumberOfUnits, int _idx);
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(List<BigDecimal> basketConstituentNumberOfUnits);
		HKMATransactionReport.HKMATransactionReportBuilder setBasketConstituentNumberOfUnits(List<BigDecimal> basketConstituentNumberOfUnits);
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(String basketConstituentUnitOfMeasure);
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(String basketConstituentUnitOfMeasure, int _idx);
		HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(List<String> basketConstituentUnitOfMeasure);
		HKMATransactionReport.HKMATransactionReportBuilder setBasketConstituentUnitOfMeasure(List<String> basketConstituentUnitOfMeasure);
		HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingIdOther(String underlyingIdOther);
		HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum underlyingIdOtherSource);
		HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String underlyingAssetTradingPlatformIdentifier);
		HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingAssetPriceSource(String underlyingAssetPriceSource);
		HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingIdentification(String underlyingIdentification);
		HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingIdentificationType(String underlyingIdentificationType);
		HKMATransactionReport.HKMATransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean cryptoAssetUnderlyingIndicator);
		HKMATransactionReport.HKMATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		HKMATransactionReport.HKMATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		HKMATransactionReport.HKMATransactionReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		HKMATransactionReport.HKMATransactionReportBuilder setBrokerId(String brokerId);
		HKMATransactionReport.HKMATransactionReportBuilder setIntragroup(Boolean intragroup);
		HKMATransactionReport.HKMATransactionReportBuilder setNatureOfTheCounterparty1(String natureOfTheCounterparty1);
		HKMATransactionReport.HKMATransactionReportBuilder setNatureOfTheCounterparty2(String natureOfTheCounterparty2);
		HKMATransactionReport.HKMATransactionReportBuilder setNonStandardizedTermIndicator(Boolean nonStandardizedTermIndicator);
		HKMATransactionReport.HKMATransactionReportBuilder setLowerBarrierLevel(BigDecimal lowerBarrierLevel);
		HKMATransactionReport.HKMATransactionReportBuilder setUpperBarrierLevel(BigDecimal upperBarrierLevel);
		HKMATransactionReport.HKMATransactionReportBuilder setSingleBarrierLevel(BigDecimal singleBarrierLevel);
		HKMATransactionReport.HKMATransactionReportBuilder setProductDescription(String productDescription);
		HKMATransactionReport.HKMATransactionReportBuilder setBeneficiary(String beneficiary);
		HKMATransactionReport.HKMATransactionReportBuilder setRemarks(String remarks);
		HKMATransactionReport.HKMATransactionReportBuilder setSwapLinkID(String swapLinkID);
		HKMATransactionReport.HKMATransactionReportBuilder setSecondaryTransactionIdentifier(String secondaryTransactionIdentifier);
		HKMATransactionReport.HKMATransactionReportBuilder setUniqueProductIdentifierProprietary(String uniqueProductIdentifierProprietary);
		HKMATransactionReport.HKMATransactionReportBuilder setSectorOfTheCounterparty1(String sectorOfTheCounterparty1);
		HKMATransactionReport.HKMATransactionReportBuilder setSectorOfTheCounterparty2(String sectorOfTheCounterparty2);
		HKMATransactionReport.HKMATransactionReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum counterparty2IdentifierFormat);
		HKMATransactionReport.HKMATransactionReportBuilder setReferenceEntityFormat(ReferenceEntityFormatEnum referenceEntityFormat);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getStrikePriceSchedule());
			processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, getLeg1());
			processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, getLeg2());
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
			processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
			processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.UnderlyingIdentifierBuilder.class, getUnderlying());
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("settlementLocation"), String.class, getSettlementLocation(), this);
			processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
			processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
			processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
			processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
			processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, getSeriesVersion(), this);
			processRosetta(path.newSubPath("notionalQuantityScheduleLeg1"), processor, NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder.class, getNotionalQuantityScheduleLeg1());
			processRosetta(path.newSubPath("notionalQuantityScheduleLeg2"), processor, NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder.class, getNotionalQuantityScheduleLeg2());
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processor.processBasic(path.newSubPath("basketConstituentNumberOfUnits"), BigDecimal.class, getBasketConstituentNumberOfUnits(), this);
			processor.processBasic(path.newSubPath("basketConstituentUnitOfMeasure"), String.class, getBasketConstituentUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
			processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, getUnderlyingIdOtherSource(), this);
			processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, getUnderlyingAssetTradingPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, getUnderlyingAssetPriceSource(), this);
			processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
			processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
			processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, getCryptoAssetUnderlyingIndicator(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("brokerId"), String.class, getBrokerId(), this);
			processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
			processor.processBasic(path.newSubPath("natureOfTheCounterparty1"), String.class, getNatureOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("natureOfTheCounterparty2"), String.class, getNatureOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
			processor.processBasic(path.newSubPath("lowerBarrierLevel"), BigDecimal.class, getLowerBarrierLevel(), this);
			processor.processBasic(path.newSubPath("upperBarrierLevel"), BigDecimal.class, getUpperBarrierLevel(), this);
			processor.processBasic(path.newSubPath("singleBarrierLevel"), BigDecimal.class, getSingleBarrierLevel(), this);
			processor.processBasic(path.newSubPath("productDescription"), String.class, getProductDescription(), this);
			processor.processBasic(path.newSubPath("beneficiary"), String.class, getBeneficiary(), this);
			processor.processBasic(path.newSubPath("remarks"), String.class, getRemarks(), this);
			processor.processBasic(path.newSubPath("swapLinkID"), String.class, getSwapLinkID(), this);
			processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, getSecondaryTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifierProprietary"), String.class, getUniqueProductIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("sectorOfTheCounterparty1"), String.class, getSectorOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("sectorOfTheCounterparty2"), String.class, getSectorOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, getCounterparty2IdentifierFormat(), this);
			processor.processBasic(path.newSubPath("referenceEntityFormat"), ReferenceEntityFormatEnum.class, getReferenceEntityFormat(), this);
		}
		

		HKMATransactionReport.HKMATransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of HKMATransactionReport  ***********************/
	class HKMATransactionReportImpl extends CommonTransactionReport.CommonTransactionReportImpl implements HKMATransactionReport {
		private final String settlementLocation;
		private final String baseProduct;
		private final String subProduct;
		private final String furtherSubProduct;
		private final String referenceEntity;
		private final Integer seriesVersion;
		private final List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1;
		private final List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2;
		private final String customBasketCode;
		private final List<BigDecimal> basketConstituentNumberOfUnits;
		private final List<String> basketConstituentUnitOfMeasure;
		private final String underlyingIdOther;
		private final ProductIdTypeEnum underlyingIdOtherSource;
		private final String underlyingAssetTradingPlatformIdentifier;
		private final String underlyingAssetPriceSource;
		private final String underlyingIdentification;
		private final String underlyingIdentificationType;
		private final Boolean cryptoAssetUnderlyingIndicator;
		private final String initialMarginCollateralPortfolioCode;
		private final String variationMarginCollateralPortfolioCode;
		private final String entityResponsibleForReporting;
		private final String brokerId;
		private final Boolean intragroup;
		private final String natureOfTheCounterparty1;
		private final String natureOfTheCounterparty2;
		private final Boolean nonStandardizedTermIndicator;
		private final BigDecimal lowerBarrierLevel;
		private final BigDecimal upperBarrierLevel;
		private final BigDecimal singleBarrierLevel;
		private final String productDescription;
		private final String beneficiary;
		private final String remarks;
		private final String swapLinkID;
		private final String secondaryTransactionIdentifier;
		private final String uniqueProductIdentifierProprietary;
		private final String sectorOfTheCounterparty1;
		private final String sectorOfTheCounterparty2;
		private final PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
		private final ReferenceEntityFormatEnum referenceEntityFormat;
		
		protected HKMATransactionReportImpl(HKMATransactionReport.HKMATransactionReportBuilder builder) {
			super(builder);
			this.settlementLocation = builder.getSettlementLocation();
			this.baseProduct = builder.getBaseProduct();
			this.subProduct = builder.getSubProduct();
			this.furtherSubProduct = builder.getFurtherSubProduct();
			this.referenceEntity = builder.getReferenceEntity();
			this.seriesVersion = builder.getSeriesVersion();
			this.notionalQuantityScheduleLeg1 = ofNullable(builder.getNotionalQuantityScheduleLeg1()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalQuantityScheduleLeg2 = ofNullable(builder.getNotionalQuantityScheduleLeg2()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.customBasketCode = builder.getCustomBasketCode();
			this.basketConstituentNumberOfUnits = ofNullable(builder.getBasketConstituentNumberOfUnits()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.basketConstituentUnitOfMeasure = ofNullable(builder.getBasketConstituentUnitOfMeasure()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.underlyingIdOther = builder.getUnderlyingIdOther();
			this.underlyingIdOtherSource = builder.getUnderlyingIdOtherSource();
			this.underlyingAssetTradingPlatformIdentifier = builder.getUnderlyingAssetTradingPlatformIdentifier();
			this.underlyingAssetPriceSource = builder.getUnderlyingAssetPriceSource();
			this.underlyingIdentification = builder.getUnderlyingIdentification();
			this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
			this.cryptoAssetUnderlyingIndicator = builder.getCryptoAssetUnderlyingIndicator();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.brokerId = builder.getBrokerId();
			this.intragroup = builder.getIntragroup();
			this.natureOfTheCounterparty1 = builder.getNatureOfTheCounterparty1();
			this.natureOfTheCounterparty2 = builder.getNatureOfTheCounterparty2();
			this.nonStandardizedTermIndicator = builder.getNonStandardizedTermIndicator();
			this.lowerBarrierLevel = builder.getLowerBarrierLevel();
			this.upperBarrierLevel = builder.getUpperBarrierLevel();
			this.singleBarrierLevel = builder.getSingleBarrierLevel();
			this.productDescription = builder.getProductDescription();
			this.beneficiary = builder.getBeneficiary();
			this.remarks = builder.getRemarks();
			this.swapLinkID = builder.getSwapLinkID();
			this.secondaryTransactionIdentifier = builder.getSecondaryTransactionIdentifier();
			this.uniqueProductIdentifierProprietary = builder.getUniqueProductIdentifierProprietary();
			this.sectorOfTheCounterparty1 = builder.getSectorOfTheCounterparty1();
			this.sectorOfTheCounterparty2 = builder.getSectorOfTheCounterparty2();
			this.counterparty2IdentifierFormat = builder.getCounterparty2IdentifierFormat();
			this.referenceEntityFormat = builder.getReferenceEntityFormat();
		}
		
		@Override
		@RosettaAttribute("settlementLocation")
		@RuneAttribute("settlementLocation")
		public String getSettlementLocation() {
			return settlementLocation;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public String getBaseProduct() {
			return baseProduct;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public String getSubProduct() {
			return subProduct;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public String getFurtherSubProduct() {
			return furtherSubProduct;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("seriesVersion")
		@RuneAttribute("seriesVersion")
		public Integer getSeriesVersion() {
			return seriesVersion;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		public List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1() {
			return notionalQuantityScheduleLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		public List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2() {
			return notionalQuantityScheduleLeg2;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("basketConstituentNumberOfUnits")
		@RuneAttribute("basketConstituentNumberOfUnits")
		public List<BigDecimal> getBasketConstituentNumberOfUnits() {
			return basketConstituentNumberOfUnits;
		}
		
		@Override
		@RosettaAttribute("basketConstituentUnitOfMeasure")
		@RuneAttribute("basketConstituentUnitOfMeasure")
		public List<String> getBasketConstituentUnitOfMeasure() {
			return basketConstituentUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public String getUnderlyingIdOther() {
			return underlyingIdOther;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public ProductIdTypeEnum getUnderlyingIdOtherSource() {
			return underlyingIdOtherSource;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifier")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifier")
		public String getUnderlyingAssetTradingPlatformIdentifier() {
			return underlyingAssetTradingPlatformIdentifier;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSource")
		@RuneAttribute("underlyingAssetPriceSource")
		public String getUnderlyingAssetPriceSource() {
			return underlyingAssetPriceSource;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicator")
		@RuneAttribute("cryptoAssetUnderlyingIndicator")
		public Boolean getCryptoAssetUnderlyingIndicator() {
			return cryptoAssetUnderlyingIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("brokerId")
		@RuneAttribute("brokerId")
		public String getBrokerId() {
			return brokerId;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public Boolean getIntragroup() {
			return intragroup;
		}
		
		@Override
		@RosettaAttribute("natureOfTheCounterparty1")
		@RuneAttribute("natureOfTheCounterparty1")
		public String getNatureOfTheCounterparty1() {
			return natureOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("natureOfTheCounterparty2")
		@RuneAttribute("natureOfTheCounterparty2")
		public String getNatureOfTheCounterparty2() {
			return natureOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public Boolean getNonStandardizedTermIndicator() {
			return nonStandardizedTermIndicator;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierLevel")
		@RuneAttribute("lowerBarrierLevel")
		public BigDecimal getLowerBarrierLevel() {
			return lowerBarrierLevel;
		}
		
		@Override
		@RosettaAttribute("upperBarrierLevel")
		@RuneAttribute("upperBarrierLevel")
		public BigDecimal getUpperBarrierLevel() {
			return upperBarrierLevel;
		}
		
		@Override
		@RosettaAttribute("singleBarrierLevel")
		@RuneAttribute("singleBarrierLevel")
		public BigDecimal getSingleBarrierLevel() {
			return singleBarrierLevel;
		}
		
		@Override
		@RosettaAttribute("productDescription")
		@RuneAttribute("productDescription")
		public String getProductDescription() {
			return productDescription;
		}
		
		@Override
		@RosettaAttribute("beneficiary")
		@RuneAttribute("beneficiary")
		public String getBeneficiary() {
			return beneficiary;
		}
		
		@Override
		@RosettaAttribute("remarks")
		@RuneAttribute("remarks")
		public String getRemarks() {
			return remarks;
		}
		
		@Override
		@RosettaAttribute("swapLinkID")
		@RuneAttribute("swapLinkID")
		public String getSwapLinkID() {
			return swapLinkID;
		}
		
		@Override
		@RosettaAttribute("secondaryTransactionIdentifier")
		@RuneAttribute("secondaryTransactionIdentifier")
		public String getSecondaryTransactionIdentifier() {
			return secondaryTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifierProprietary")
		@RuneAttribute("uniqueProductIdentifierProprietary")
		public String getUniqueProductIdentifierProprietary() {
			return uniqueProductIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute("sectorOfTheCounterparty1")
		@RuneAttribute("sectorOfTheCounterparty1")
		public String getSectorOfTheCounterparty1() {
			return sectorOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("sectorOfTheCounterparty2")
		@RuneAttribute("sectorOfTheCounterparty2")
		public String getSectorOfTheCounterparty2() {
			return sectorOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
			return counterparty2IdentifierFormat;
		}
		
		@Override
		@RosettaAttribute("referenceEntityFormat")
		@RuneAttribute("referenceEntityFormat")
		public ReferenceEntityFormatEnum getReferenceEntityFormat() {
			return referenceEntityFormat;
		}
		
		@Override
		public HKMATransactionReport build() {
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder toBuilder() {
			HKMATransactionReport.HKMATransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(HKMATransactionReport.HKMATransactionReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getSettlementLocation()).ifPresent(builder::setSettlementLocation);
			ofNullable(getBaseProduct()).ifPresent(builder::setBaseProduct);
			ofNullable(getSubProduct()).ifPresent(builder::setSubProduct);
			ofNullable(getFurtherSubProduct()).ifPresent(builder::setFurtherSubProduct);
			ofNullable(getReferenceEntity()).ifPresent(builder::setReferenceEntity);
			ofNullable(getSeriesVersion()).ifPresent(builder::setSeriesVersion);
			ofNullable(getNotionalQuantityScheduleLeg1()).ifPresent(builder::setNotionalQuantityScheduleLeg1);
			ofNullable(getNotionalQuantityScheduleLeg2()).ifPresent(builder::setNotionalQuantityScheduleLeg2);
			ofNullable(getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
			ofNullable(getBasketConstituentNumberOfUnits()).ifPresent(builder::setBasketConstituentNumberOfUnits);
			ofNullable(getBasketConstituentUnitOfMeasure()).ifPresent(builder::setBasketConstituentUnitOfMeasure);
			ofNullable(getUnderlyingIdOther()).ifPresent(builder::setUnderlyingIdOther);
			ofNullable(getUnderlyingIdOtherSource()).ifPresent(builder::setUnderlyingIdOtherSource);
			ofNullable(getUnderlyingAssetTradingPlatformIdentifier()).ifPresent(builder::setUnderlyingAssetTradingPlatformIdentifier);
			ofNullable(getUnderlyingAssetPriceSource()).ifPresent(builder::setUnderlyingAssetPriceSource);
			ofNullable(getUnderlyingIdentification()).ifPresent(builder::setUnderlyingIdentification);
			ofNullable(getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
			ofNullable(getCryptoAssetUnderlyingIndicator()).ifPresent(builder::setCryptoAssetUnderlyingIndicator);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getBrokerId()).ifPresent(builder::setBrokerId);
			ofNullable(getIntragroup()).ifPresent(builder::setIntragroup);
			ofNullable(getNatureOfTheCounterparty1()).ifPresent(builder::setNatureOfTheCounterparty1);
			ofNullable(getNatureOfTheCounterparty2()).ifPresent(builder::setNatureOfTheCounterparty2);
			ofNullable(getNonStandardizedTermIndicator()).ifPresent(builder::setNonStandardizedTermIndicator);
			ofNullable(getLowerBarrierLevel()).ifPresent(builder::setLowerBarrierLevel);
			ofNullable(getUpperBarrierLevel()).ifPresent(builder::setUpperBarrierLevel);
			ofNullable(getSingleBarrierLevel()).ifPresent(builder::setSingleBarrierLevel);
			ofNullable(getProductDescription()).ifPresent(builder::setProductDescription);
			ofNullable(getBeneficiary()).ifPresent(builder::setBeneficiary);
			ofNullable(getRemarks()).ifPresent(builder::setRemarks);
			ofNullable(getSwapLinkID()).ifPresent(builder::setSwapLinkID);
			ofNullable(getSecondaryTransactionIdentifier()).ifPresent(builder::setSecondaryTransactionIdentifier);
			ofNullable(getUniqueProductIdentifierProprietary()).ifPresent(builder::setUniqueProductIdentifierProprietary);
			ofNullable(getSectorOfTheCounterparty1()).ifPresent(builder::setSectorOfTheCounterparty1);
			ofNullable(getSectorOfTheCounterparty2()).ifPresent(builder::setSectorOfTheCounterparty2);
			ofNullable(getCounterparty2IdentifierFormat()).ifPresent(builder::setCounterparty2IdentifierFormat);
			ofNullable(getReferenceEntityFormat()).ifPresent(builder::setReferenceEntityFormat);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			HKMATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(settlementLocation, _that.getSettlementLocation())) return false;
			if (!Objects.equals(baseProduct, _that.getBaseProduct())) return false;
			if (!Objects.equals(subProduct, _that.getSubProduct())) return false;
			if (!Objects.equals(furtherSubProduct, _that.getFurtherSubProduct())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(seriesVersion, _that.getSeriesVersion())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg1, _that.getNotionalQuantityScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg2, _that.getNotionalQuantityScheduleLeg2())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!ListEquals.listEquals(basketConstituentNumberOfUnits, _that.getBasketConstituentNumberOfUnits())) return false;
			if (!ListEquals.listEquals(basketConstituentUnitOfMeasure, _that.getBasketConstituentUnitOfMeasure())) return false;
			if (!Objects.equals(underlyingIdOther, _that.getUnderlyingIdOther())) return false;
			if (!Objects.equals(underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) return false;
			if (!Objects.equals(underlyingAssetTradingPlatformIdentifier, _that.getUnderlyingAssetTradingPlatformIdentifier())) return false;
			if (!Objects.equals(underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(brokerId, _that.getBrokerId())) return false;
			if (!Objects.equals(intragroup, _that.getIntragroup())) return false;
			if (!Objects.equals(natureOfTheCounterparty1, _that.getNatureOfTheCounterparty1())) return false;
			if (!Objects.equals(natureOfTheCounterparty2, _that.getNatureOfTheCounterparty2())) return false;
			if (!Objects.equals(nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) return false;
			if (!Objects.equals(lowerBarrierLevel, _that.getLowerBarrierLevel())) return false;
			if (!Objects.equals(upperBarrierLevel, _that.getUpperBarrierLevel())) return false;
			if (!Objects.equals(singleBarrierLevel, _that.getSingleBarrierLevel())) return false;
			if (!Objects.equals(productDescription, _that.getProductDescription())) return false;
			if (!Objects.equals(beneficiary, _that.getBeneficiary())) return false;
			if (!Objects.equals(remarks, _that.getRemarks())) return false;
			if (!Objects.equals(swapLinkID, _that.getSwapLinkID())) return false;
			if (!Objects.equals(secondaryTransactionIdentifier, _that.getSecondaryTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueProductIdentifierProprietary, _that.getUniqueProductIdentifierProprietary())) return false;
			if (!Objects.equals(sectorOfTheCounterparty1, _that.getSectorOfTheCounterparty1())) return false;
			if (!Objects.equals(sectorOfTheCounterparty2, _that.getSectorOfTheCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierFormat, _that.getCounterparty2IdentifierFormat())) return false;
			if (!Objects.equals(referenceEntityFormat, _that.getReferenceEntityFormat())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (settlementLocation != null ? settlementLocation.hashCode() : 0);
			_result = 31 * _result + (baseProduct != null ? baseProduct.hashCode() : 0);
			_result = 31 * _result + (subProduct != null ? subProduct.hashCode() : 0);
			_result = 31 * _result + (furtherSubProduct != null ? furtherSubProduct.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (seriesVersion != null ? seriesVersion.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg1 != null ? notionalQuantityScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg2 != null ? notionalQuantityScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (basketConstituentNumberOfUnits != null ? basketConstituentNumberOfUnits.hashCode() : 0);
			_result = 31 * _result + (basketConstituentUnitOfMeasure != null ? basketConstituentUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOther != null ? underlyingIdOther.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOtherSource != null ? underlyingIdOtherSource.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlyingAssetTradingPlatformIdentifier != null ? underlyingAssetTradingPlatformIdentifier.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetPriceSource != null ? underlyingAssetPriceSource.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (cryptoAssetUnderlyingIndicator != null ? cryptoAssetUnderlyingIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (brokerId != null ? brokerId.hashCode() : 0);
			_result = 31 * _result + (intragroup != null ? intragroup.hashCode() : 0);
			_result = 31 * _result + (natureOfTheCounterparty1 != null ? natureOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (natureOfTheCounterparty2 != null ? natureOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (nonStandardizedTermIndicator != null ? nonStandardizedTermIndicator.hashCode() : 0);
			_result = 31 * _result + (lowerBarrierLevel != null ? lowerBarrierLevel.hashCode() : 0);
			_result = 31 * _result + (upperBarrierLevel != null ? upperBarrierLevel.hashCode() : 0);
			_result = 31 * _result + (singleBarrierLevel != null ? singleBarrierLevel.hashCode() : 0);
			_result = 31 * _result + (productDescription != null ? productDescription.hashCode() : 0);
			_result = 31 * _result + (beneficiary != null ? beneficiary.hashCode() : 0);
			_result = 31 * _result + (remarks != null ? remarks.hashCode() : 0);
			_result = 31 * _result + (swapLinkID != null ? swapLinkID.hashCode() : 0);
			_result = 31 * _result + (secondaryTransactionIdentifier != null ? secondaryTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifierProprietary != null ? uniqueProductIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (sectorOfTheCounterparty1 != null ? sectorOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (sectorOfTheCounterparty2 != null ? sectorOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierFormat != null ? counterparty2IdentifierFormat.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (referenceEntityFormat != null ? referenceEntityFormat.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HKMATransactionReport {" +
				"settlementLocation=" + this.settlementLocation + ", " +
				"baseProduct=" + this.baseProduct + ", " +
				"subProduct=" + this.subProduct + ", " +
				"furtherSubProduct=" + this.furtherSubProduct + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"seriesVersion=" + this.seriesVersion + ", " +
				"notionalQuantityScheduleLeg1=" + this.notionalQuantityScheduleLeg1 + ", " +
				"notionalQuantityScheduleLeg2=" + this.notionalQuantityScheduleLeg2 + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"basketConstituentNumberOfUnits=" + this.basketConstituentNumberOfUnits + ", " +
				"basketConstituentUnitOfMeasure=" + this.basketConstituentUnitOfMeasure + ", " +
				"underlyingIdOther=" + this.underlyingIdOther + ", " +
				"underlyingIdOtherSource=" + this.underlyingIdOtherSource + ", " +
				"underlyingAssetTradingPlatformIdentifier=" + this.underlyingAssetTradingPlatformIdentifier + ", " +
				"underlyingAssetPriceSource=" + this.underlyingAssetPriceSource + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"brokerId=" + this.brokerId + ", " +
				"intragroup=" + this.intragroup + ", " +
				"natureOfTheCounterparty1=" + this.natureOfTheCounterparty1 + ", " +
				"natureOfTheCounterparty2=" + this.natureOfTheCounterparty2 + ", " +
				"nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", " +
				"lowerBarrierLevel=" + this.lowerBarrierLevel + ", " +
				"upperBarrierLevel=" + this.upperBarrierLevel + ", " +
				"singleBarrierLevel=" + this.singleBarrierLevel + ", " +
				"productDescription=" + this.productDescription + ", " +
				"beneficiary=" + this.beneficiary + ", " +
				"remarks=" + this.remarks + ", " +
				"swapLinkID=" + this.swapLinkID + ", " +
				"secondaryTransactionIdentifier=" + this.secondaryTransactionIdentifier + ", " +
				"uniqueProductIdentifierProprietary=" + this.uniqueProductIdentifierProprietary + ", " +
				"sectorOfTheCounterparty1=" + this.sectorOfTheCounterparty1 + ", " +
				"sectorOfTheCounterparty2=" + this.sectorOfTheCounterparty2 + ", " +
				"counterparty2IdentifierFormat=" + this.counterparty2IdentifierFormat + ", " +
				"referenceEntityFormat=" + this.referenceEntityFormat +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of HKMATransactionReport  ***********************/
	class HKMATransactionReportBuilderImpl extends CommonTransactionReport.CommonTransactionReportBuilderImpl implements HKMATransactionReport.HKMATransactionReportBuilder {
	
		protected String settlementLocation;
		protected String baseProduct;
		protected String subProduct;
		protected String furtherSubProduct;
		protected String referenceEntity;
		protected Integer seriesVersion;
		protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> notionalQuantityScheduleLeg1 = new ArrayList<>();
		protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> notionalQuantityScheduleLeg2 = new ArrayList<>();
		protected String customBasketCode;
		protected List<BigDecimal> basketConstituentNumberOfUnits = new ArrayList<>();
		protected List<String> basketConstituentUnitOfMeasure = new ArrayList<>();
		protected String underlyingIdOther;
		protected ProductIdTypeEnum underlyingIdOtherSource;
		protected String underlyingAssetTradingPlatformIdentifier;
		protected String underlyingAssetPriceSource;
		protected String underlyingIdentification;
		protected String underlyingIdentificationType;
		protected Boolean cryptoAssetUnderlyingIndicator;
		protected String initialMarginCollateralPortfolioCode;
		protected String variationMarginCollateralPortfolioCode;
		protected String entityResponsibleForReporting;
		protected String brokerId;
		protected Boolean intragroup;
		protected String natureOfTheCounterparty1;
		protected String natureOfTheCounterparty2;
		protected Boolean nonStandardizedTermIndicator;
		protected BigDecimal lowerBarrierLevel;
		protected BigDecimal upperBarrierLevel;
		protected BigDecimal singleBarrierLevel;
		protected String productDescription;
		protected String beneficiary;
		protected String remarks;
		protected String swapLinkID;
		protected String secondaryTransactionIdentifier;
		protected String uniqueProductIdentifierProprietary;
		protected String sectorOfTheCounterparty1;
		protected String sectorOfTheCounterparty2;
		protected PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
		protected ReferenceEntityFormatEnum referenceEntityFormat;
		
		@Override
		@RosettaAttribute("settlementLocation")
		@RuneAttribute("settlementLocation")
		public String getSettlementLocation() {
			return settlementLocation;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public String getBaseProduct() {
			return baseProduct;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public String getSubProduct() {
			return subProduct;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public String getFurtherSubProduct() {
			return furtherSubProduct;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("seriesVersion")
		@RuneAttribute("seriesVersion")
		public Integer getSeriesVersion() {
			return seriesVersion;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		public List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1() {
			return notionalQuantityScheduleLeg1;
		}
		
		@Override
		public NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1(int _index) {
		
			if (notionalQuantityScheduleLeg1==null) {
				this.notionalQuantityScheduleLeg1 = new ArrayList<>();
			}
			NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder result;
			return getIndex(notionalQuantityScheduleLeg1, _index, () -> {
						NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder newNotionalQuantityScheduleLeg1 = NotionalQuantityScheduleLeg1Report.builder();
						return newNotionalQuantityScheduleLeg1;
					});
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		public List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2() {
			return notionalQuantityScheduleLeg2;
		}
		
		@Override
		public NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2(int _index) {
		
			if (notionalQuantityScheduleLeg2==null) {
				this.notionalQuantityScheduleLeg2 = new ArrayList<>();
			}
			NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder result;
			return getIndex(notionalQuantityScheduleLeg2, _index, () -> {
						NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder newNotionalQuantityScheduleLeg2 = NotionalQuantityScheduleLeg2Report.builder();
						return newNotionalQuantityScheduleLeg2;
					});
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("basketConstituentNumberOfUnits")
		@RuneAttribute("basketConstituentNumberOfUnits")
		public List<BigDecimal> getBasketConstituentNumberOfUnits() {
			return basketConstituentNumberOfUnits;
		}
		
		@Override
		@RosettaAttribute("basketConstituentUnitOfMeasure")
		@RuneAttribute("basketConstituentUnitOfMeasure")
		public List<String> getBasketConstituentUnitOfMeasure() {
			return basketConstituentUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public String getUnderlyingIdOther() {
			return underlyingIdOther;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public ProductIdTypeEnum getUnderlyingIdOtherSource() {
			return underlyingIdOtherSource;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifier")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifier")
		public String getUnderlyingAssetTradingPlatformIdentifier() {
			return underlyingAssetTradingPlatformIdentifier;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSource")
		@RuneAttribute("underlyingAssetPriceSource")
		public String getUnderlyingAssetPriceSource() {
			return underlyingAssetPriceSource;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicator")
		@RuneAttribute("cryptoAssetUnderlyingIndicator")
		public Boolean getCryptoAssetUnderlyingIndicator() {
			return cryptoAssetUnderlyingIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("brokerId")
		@RuneAttribute("brokerId")
		public String getBrokerId() {
			return brokerId;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public Boolean getIntragroup() {
			return intragroup;
		}
		
		@Override
		@RosettaAttribute("natureOfTheCounterparty1")
		@RuneAttribute("natureOfTheCounterparty1")
		public String getNatureOfTheCounterparty1() {
			return natureOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("natureOfTheCounterparty2")
		@RuneAttribute("natureOfTheCounterparty2")
		public String getNatureOfTheCounterparty2() {
			return natureOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public Boolean getNonStandardizedTermIndicator() {
			return nonStandardizedTermIndicator;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierLevel")
		@RuneAttribute("lowerBarrierLevel")
		public BigDecimal getLowerBarrierLevel() {
			return lowerBarrierLevel;
		}
		
		@Override
		@RosettaAttribute("upperBarrierLevel")
		@RuneAttribute("upperBarrierLevel")
		public BigDecimal getUpperBarrierLevel() {
			return upperBarrierLevel;
		}
		
		@Override
		@RosettaAttribute("singleBarrierLevel")
		@RuneAttribute("singleBarrierLevel")
		public BigDecimal getSingleBarrierLevel() {
			return singleBarrierLevel;
		}
		
		@Override
		@RosettaAttribute("productDescription")
		@RuneAttribute("productDescription")
		public String getProductDescription() {
			return productDescription;
		}
		
		@Override
		@RosettaAttribute("beneficiary")
		@RuneAttribute("beneficiary")
		public String getBeneficiary() {
			return beneficiary;
		}
		
		@Override
		@RosettaAttribute("remarks")
		@RuneAttribute("remarks")
		public String getRemarks() {
			return remarks;
		}
		
		@Override
		@RosettaAttribute("swapLinkID")
		@RuneAttribute("swapLinkID")
		public String getSwapLinkID() {
			return swapLinkID;
		}
		
		@Override
		@RosettaAttribute("secondaryTransactionIdentifier")
		@RuneAttribute("secondaryTransactionIdentifier")
		public String getSecondaryTransactionIdentifier() {
			return secondaryTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifierProprietary")
		@RuneAttribute("uniqueProductIdentifierProprietary")
		public String getUniqueProductIdentifierProprietary() {
			return uniqueProductIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute("sectorOfTheCounterparty1")
		@RuneAttribute("sectorOfTheCounterparty1")
		public String getSectorOfTheCounterparty1() {
			return sectorOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("sectorOfTheCounterparty2")
		@RuneAttribute("sectorOfTheCounterparty2")
		public String getSectorOfTheCounterparty2() {
			return sectorOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
			return counterparty2IdentifierFormat;
		}
		
		@Override
		@RosettaAttribute("referenceEntityFormat")
		@RuneAttribute("referenceEntityFormat")
		public ReferenceEntityFormatEnum getReferenceEntityFormat() {
			return referenceEntityFormat;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public HKMATransactionReport.HKMATransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public HKMATransactionReport.HKMATransactionReportBuilder setEventType(EventTypeEnum _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public HKMATransactionReport.HKMATransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public HKMATransactionReport.HKMATransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public HKMATransactionReport.HKMATransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public HKMATransactionReport.HKMATransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public HKMATransactionReport.HKMATransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public HKMATransactionReport.HKMATransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public HKMATransactionReport.HKMATransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public HKMATransactionReport.HKMATransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public HKMATransactionReport.HKMATransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public HKMATransactionReport.HKMATransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public HKMATransactionReport.HKMATransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public HKMATransactionReport.HKMATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public HKMATransactionReport.HKMATransactionReportBuilder setCleared(ClearedEnum _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public HKMATransactionReport.HKMATransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public HKMATransactionReport.HKMATransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public HKMATransactionReport.HKMATransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public HKMATransactionReport.HKMATransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public HKMATransactionReport.HKMATransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public HKMATransactionReport.HKMATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public HKMATransactionReport.HKMATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public HKMATransactionReport.HKMATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int _idx) {
			getIndex(this.priceSchedule, _idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public HKMATransactionReport.HKMATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules != null) {
				for (final PricePeriod toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("priceSchedule")
		public HKMATransactionReport.HKMATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public HKMATransactionReport.HKMATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int _idx) {
			getIndex(this.strikePriceSchedule, _idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public HKMATransactionReport.HKMATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final PricePeriod toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("strikePriceSchedule")
		public HKMATransactionReport.HKMATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public HKMATransactionReport.HKMATransactionReportBuilder setPrice(PriceFormat _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public HKMATransactionReport.HKMATransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public HKMATransactionReport.HKMATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public HKMATransactionReport.HKMATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public HKMATransactionReport.HKMATransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public HKMATransactionReport.HKMATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public HKMATransactionReport.HKMATransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public HKMATransactionReport.HKMATransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public HKMATransactionReport.HKMATransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public HKMATransactionReport.HKMATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public HKMATransactionReport.HKMATransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public HKMATransactionReport.HKMATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public HKMATransactionReport.HKMATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public HKMATransactionReport.HKMATransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public HKMATransactionReport.HKMATransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public HKMATransactionReport.HKMATransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public HKMATransactionReport.HKMATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int _idx) {
			getIndex(this.otherPayment, _idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override 
		public HKMATransactionReport.HKMATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPayment toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPayment")
		public HKMATransactionReport.HKMATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1")
		@RuneAttribute("leg1")
		public HKMATransactionReport.HKMATransactionReportBuilder setLeg1(CommonLeg _leg1) {
			this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public HKMATransactionReport.HKMATransactionReportBuilder setLeg1(Leg _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("leg2")
		@RuneAttribute("leg2")
		public HKMATransactionReport.HKMATransactionReportBuilder setLeg2(CommonLeg _leg2) {
			this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public HKMATransactionReport.HKMATransactionReportBuilder setLeg2(Leg _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public HKMATransactionReport.HKMATransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty1")
		@RuneAttribute("executionAgentCounterparty1")
		public HKMATransactionReport.HKMATransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
			this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty2DTCC")
		@RuneAttribute("executionAgentCounterparty2DTCC")
		public HKMATransactionReport.HKMATransactionReportBuilder setExecutionAgentCounterparty2DTCC(String _executionAgentCounterparty2DTCC) {
			this.executionAgentCounterparty2DTCC = _executionAgentCounterparty2DTCC == null ? null : _executionAgentCounterparty2DTCC;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportSubmittingEntityID")
		@RuneAttribute("reportSubmittingEntityID")
		public HKMATransactionReport.HKMATransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public HKMATransactionReport.HKMATransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public HKMATransactionReport.HKMATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public HKMATransactionReport.HKMATransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public HKMATransactionReport.HKMATransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public HKMATransactionReport.HKMATransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public HKMATransactionReport.HKMATransactionReportBuilder setContractType(CommonContractType _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@Override
		@RosettaAttribute("assetClass")
		@RuneAttribute("assetClass")
		public HKMATransactionReport.HKMATransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public HKMATransactionReport.HKMATransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public HKMATransactionReport.HKMATransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public HKMATransactionReport.HKMATransactionReportBuilder setDirection1(Direction1Enum _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public HKMATransactionReport.HKMATransactionReportBuilder setDirection2Leg1(Direction2Enum _direction2Leg1) {
			this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public HKMATransactionReport.HKMATransactionReportBuilder setDirection2Leg2(Direction2Enum _direction2Leg2) {
			this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public HKMATransactionReport.HKMATransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public HKMATransactionReport.HKMATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public HKMATransactionReport.HKMATransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public HKMATransactionReport.HKMATransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public HKMATransactionReport.HKMATransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int _idx) {
			getIndex(this.basketConstituents, _idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override 
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituents")
		public HKMATransactionReport.HKMATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public HKMATransactionReport.HKMATransactionReportBuilder setUnderlying(UnderlyingIdentifier _underlying) {
			this.underlying = _underlying == null ? null : _underlying.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public HKMATransactionReport.HKMATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public HKMATransactionReport.HKMATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public HKMATransactionReport.HKMATransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public HKMATransactionReport.HKMATransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public HKMATransactionReport.HKMATransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public HKMATransactionReport.HKMATransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterparty2")
		@RuneAttribute("countryOfTheCounterparty2")
		public HKMATransactionReport.HKMATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
			this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public HKMATransactionReport.HKMATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public HKMATransactionReport.HKMATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradingCapacity")
		@RuneAttribute("tradingCapacity")
		public HKMATransactionReport.HKMATransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
			this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
			return this;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public HKMATransactionReport.HKMATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public HKMATransactionReport.HKMATransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public HKMATransactionReport.HKMATransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public HKMATransactionReport.HKMATransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public HKMATransactionReport.HKMATransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementLocation")
		@RuneAttribute("settlementLocation")
		public HKMATransactionReport.HKMATransactionReportBuilder setSettlementLocation(String _settlementLocation) {
			this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public HKMATransactionReport.HKMATransactionReportBuilder setBaseProduct(String _baseProduct) {
			this.baseProduct = _baseProduct == null ? null : _baseProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public HKMATransactionReport.HKMATransactionReportBuilder setSubProduct(String _subProduct) {
			this.subProduct = _subProduct == null ? null : _subProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public HKMATransactionReport.HKMATransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
			this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public HKMATransactionReport.HKMATransactionReportBuilder setReferenceEntity(String _referenceEntity) {
			this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
			return this;
		}
		
		@Override
		@RosettaAttribute("seriesVersion")
		@RuneAttribute("seriesVersion")
		public HKMATransactionReport.HKMATransactionReportBuilder setSeriesVersion(Integer _seriesVersion) {
			this.seriesVersion = _seriesVersion == null ? null : _seriesVersion;
			return this;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		public HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1) {
			if (_notionalQuantityScheduleLeg1 != null) {
				this.notionalQuantityScheduleLeg1.add(_notionalQuantityScheduleLeg1.toBuilder());
			}
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1, int _idx) {
			getIndex(this.notionalQuantityScheduleLeg1, _idx, () -> _notionalQuantityScheduleLeg1.toBuilder());
			return this;
		}
		
		@Override 
		public HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1s) {
			if (notionalQuantityScheduleLeg1s != null) {
				for (final NotionalQuantityScheduleLeg1Report toAdd : notionalQuantityScheduleLeg1s) {
					this.notionalQuantityScheduleLeg1.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("notionalQuantityScheduleLeg1")
		public HKMATransactionReport.HKMATransactionReportBuilder setNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1s) {
			if (notionalQuantityScheduleLeg1s == null) {
				this.notionalQuantityScheduleLeg1 = new ArrayList<>();
			} else {
				this.notionalQuantityScheduleLeg1 = notionalQuantityScheduleLeg1s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		public HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2) {
			if (_notionalQuantityScheduleLeg2 != null) {
				this.notionalQuantityScheduleLeg2.add(_notionalQuantityScheduleLeg2.toBuilder());
			}
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2, int _idx) {
			getIndex(this.notionalQuantityScheduleLeg2, _idx, () -> _notionalQuantityScheduleLeg2.toBuilder());
			return this;
		}
		
		@Override 
		public HKMATransactionReport.HKMATransactionReportBuilder addNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2s) {
			if (notionalQuantityScheduleLeg2s != null) {
				for (final NotionalQuantityScheduleLeg2Report toAdd : notionalQuantityScheduleLeg2s) {
					this.notionalQuantityScheduleLeg2.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("notionalQuantityScheduleLeg2")
		public HKMATransactionReport.HKMATransactionReportBuilder setNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2s) {
			if (notionalQuantityScheduleLeg2s == null) {
				this.notionalQuantityScheduleLeg2 = new ArrayList<>();
			} else {
				this.notionalQuantityScheduleLeg2 = notionalQuantityScheduleLeg2s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public HKMATransactionReport.HKMATransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituentNumberOfUnits")
		@RuneAttribute("basketConstituentNumberOfUnits")
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(BigDecimal _basketConstituentNumberOfUnits) {
			if (_basketConstituentNumberOfUnits != null) {
				this.basketConstituentNumberOfUnits.add(_basketConstituentNumberOfUnits);
			}
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(BigDecimal _basketConstituentNumberOfUnits, int _idx) {
			getIndex(this.basketConstituentNumberOfUnits, _idx, () -> _basketConstituentNumberOfUnits);
			return this;
		}
		
		@Override 
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentNumberOfUnits(List<BigDecimal> basketConstituentNumberOfUnitss) {
			if (basketConstituentNumberOfUnitss != null) {
				for (final BigDecimal toAdd : basketConstituentNumberOfUnitss) {
					this.basketConstituentNumberOfUnits.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituentNumberOfUnits")
		public HKMATransactionReport.HKMATransactionReportBuilder setBasketConstituentNumberOfUnits(List<BigDecimal> basketConstituentNumberOfUnitss) {
			if (basketConstituentNumberOfUnitss == null) {
				this.basketConstituentNumberOfUnits = new ArrayList<>();
			} else {
				this.basketConstituentNumberOfUnits = basketConstituentNumberOfUnitss.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituentUnitOfMeasure")
		@RuneAttribute("basketConstituentUnitOfMeasure")
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(String _basketConstituentUnitOfMeasure) {
			if (_basketConstituentUnitOfMeasure != null) {
				this.basketConstituentUnitOfMeasure.add(_basketConstituentUnitOfMeasure);
			}
			return this;
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(String _basketConstituentUnitOfMeasure, int _idx) {
			getIndex(this.basketConstituentUnitOfMeasure, _idx, () -> _basketConstituentUnitOfMeasure);
			return this;
		}
		
		@Override 
		public HKMATransactionReport.HKMATransactionReportBuilder addBasketConstituentUnitOfMeasure(List<String> basketConstituentUnitOfMeasures) {
			if (basketConstituentUnitOfMeasures != null) {
				for (final String toAdd : basketConstituentUnitOfMeasures) {
					this.basketConstituentUnitOfMeasure.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituentUnitOfMeasure")
		public HKMATransactionReport.HKMATransactionReportBuilder setBasketConstituentUnitOfMeasure(List<String> basketConstituentUnitOfMeasures) {
			if (basketConstituentUnitOfMeasures == null) {
				this.basketConstituentUnitOfMeasure = new ArrayList<>();
			} else {
				this.basketConstituentUnitOfMeasure = basketConstituentUnitOfMeasures.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
			this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
			this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifier")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifier")
		public HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
			this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetPriceSource")
		@RuneAttribute("underlyingAssetPriceSource")
		public HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
			this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
			this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public HKMATransactionReport.HKMATransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
			this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("cryptoAssetUnderlyingIndicator")
		@RuneAttribute("cryptoAssetUnderlyingIndicator")
		public HKMATransactionReport.HKMATransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
			this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public HKMATransactionReport.HKMATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public HKMATransactionReport.HKMATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public HKMATransactionReport.HKMATransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@Override
		@RosettaAttribute("brokerId")
		@RuneAttribute("brokerId")
		public HKMATransactionReport.HKMATransactionReportBuilder setBrokerId(String _brokerId) {
			this.brokerId = _brokerId == null ? null : _brokerId;
			return this;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public HKMATransactionReport.HKMATransactionReportBuilder setIntragroup(Boolean _intragroup) {
			this.intragroup = _intragroup == null ? null : _intragroup;
			return this;
		}
		
		@Override
		@RosettaAttribute("natureOfTheCounterparty1")
		@RuneAttribute("natureOfTheCounterparty1")
		public HKMATransactionReport.HKMATransactionReportBuilder setNatureOfTheCounterparty1(String _natureOfTheCounterparty1) {
			this.natureOfTheCounterparty1 = _natureOfTheCounterparty1 == null ? null : _natureOfTheCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("natureOfTheCounterparty2")
		@RuneAttribute("natureOfTheCounterparty2")
		public HKMATransactionReport.HKMATransactionReportBuilder setNatureOfTheCounterparty2(String _natureOfTheCounterparty2) {
			this.natureOfTheCounterparty2 = _natureOfTheCounterparty2 == null ? null : _natureOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public HKMATransactionReport.HKMATransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
			this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierLevel")
		@RuneAttribute("lowerBarrierLevel")
		public HKMATransactionReport.HKMATransactionReportBuilder setLowerBarrierLevel(BigDecimal _lowerBarrierLevel) {
			this.lowerBarrierLevel = _lowerBarrierLevel == null ? null : _lowerBarrierLevel;
			return this;
		}
		
		@Override
		@RosettaAttribute("upperBarrierLevel")
		@RuneAttribute("upperBarrierLevel")
		public HKMATransactionReport.HKMATransactionReportBuilder setUpperBarrierLevel(BigDecimal _upperBarrierLevel) {
			this.upperBarrierLevel = _upperBarrierLevel == null ? null : _upperBarrierLevel;
			return this;
		}
		
		@Override
		@RosettaAttribute("singleBarrierLevel")
		@RuneAttribute("singleBarrierLevel")
		public HKMATransactionReport.HKMATransactionReportBuilder setSingleBarrierLevel(BigDecimal _singleBarrierLevel) {
			this.singleBarrierLevel = _singleBarrierLevel == null ? null : _singleBarrierLevel;
			return this;
		}
		
		@Override
		@RosettaAttribute("productDescription")
		@RuneAttribute("productDescription")
		public HKMATransactionReport.HKMATransactionReportBuilder setProductDescription(String _productDescription) {
			this.productDescription = _productDescription == null ? null : _productDescription;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary")
		@RuneAttribute("beneficiary")
		public HKMATransactionReport.HKMATransactionReportBuilder setBeneficiary(String _beneficiary) {
			this.beneficiary = _beneficiary == null ? null : _beneficiary;
			return this;
		}
		
		@Override
		@RosettaAttribute("remarks")
		@RuneAttribute("remarks")
		public HKMATransactionReport.HKMATransactionReportBuilder setRemarks(String _remarks) {
			this.remarks = _remarks == null ? null : _remarks;
			return this;
		}
		
		@Override
		@RosettaAttribute("swapLinkID")
		@RuneAttribute("swapLinkID")
		public HKMATransactionReport.HKMATransactionReportBuilder setSwapLinkID(String _swapLinkID) {
			this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
			return this;
		}
		
		@Override
		@RosettaAttribute("secondaryTransactionIdentifier")
		@RuneAttribute("secondaryTransactionIdentifier")
		public HKMATransactionReport.HKMATransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
			this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifierProprietary")
		@RuneAttribute("uniqueProductIdentifierProprietary")
		public HKMATransactionReport.HKMATransactionReportBuilder setUniqueProductIdentifierProprietary(String _uniqueProductIdentifierProprietary) {
			this.uniqueProductIdentifierProprietary = _uniqueProductIdentifierProprietary == null ? null : _uniqueProductIdentifierProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("sectorOfTheCounterparty1")
		@RuneAttribute("sectorOfTheCounterparty1")
		public HKMATransactionReport.HKMATransactionReportBuilder setSectorOfTheCounterparty1(String _sectorOfTheCounterparty1) {
			this.sectorOfTheCounterparty1 = _sectorOfTheCounterparty1 == null ? null : _sectorOfTheCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("sectorOfTheCounterparty2")
		@RuneAttribute("sectorOfTheCounterparty2")
		public HKMATransactionReport.HKMATransactionReportBuilder setSectorOfTheCounterparty2(String _sectorOfTheCounterparty2) {
			this.sectorOfTheCounterparty2 = _sectorOfTheCounterparty2 == null ? null : _sectorOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public HKMATransactionReport.HKMATransactionReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum _counterparty2IdentifierFormat) {
			this.counterparty2IdentifierFormat = _counterparty2IdentifierFormat == null ? null : _counterparty2IdentifierFormat;
			return this;
		}
		
		@Override
		@RosettaAttribute("referenceEntityFormat")
		@RuneAttribute("referenceEntityFormat")
		public HKMATransactionReport.HKMATransactionReportBuilder setReferenceEntityFormat(ReferenceEntityFormatEnum _referenceEntityFormat) {
			this.referenceEntityFormat = _referenceEntityFormat == null ? null : _referenceEntityFormat;
			return this;
		}
		
		@Override
		public HKMATransactionReport build() {
			return new HKMATransactionReport.HKMATransactionReportImpl(this);
		}
		
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder prune() {
			super.prune();
			notionalQuantityScheduleLeg1 = notionalQuantityScheduleLeg1.stream().filter(b->b!=null).<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalQuantityScheduleLeg2 = notionalQuantityScheduleLeg2.stream().filter(b->b!=null).<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getSettlementLocation()!=null) return true;
			if (getBaseProduct()!=null) return true;
			if (getSubProduct()!=null) return true;
			if (getFurtherSubProduct()!=null) return true;
			if (getReferenceEntity()!=null) return true;
			if (getSeriesVersion()!=null) return true;
			if (getNotionalQuantityScheduleLeg1()!=null && getNotionalQuantityScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalQuantityScheduleLeg2()!=null && getNotionalQuantityScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getCustomBasketCode()!=null) return true;
			if (getBasketConstituentNumberOfUnits()!=null && !getBasketConstituentNumberOfUnits().isEmpty()) return true;
			if (getBasketConstituentUnitOfMeasure()!=null && !getBasketConstituentUnitOfMeasure().isEmpty()) return true;
			if (getUnderlyingIdOther()!=null) return true;
			if (getUnderlyingIdOtherSource()!=null) return true;
			if (getUnderlyingAssetTradingPlatformIdentifier()!=null) return true;
			if (getUnderlyingAssetPriceSource()!=null) return true;
			if (getUnderlyingIdentification()!=null) return true;
			if (getUnderlyingIdentificationType()!=null) return true;
			if (getCryptoAssetUnderlyingIndicator()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getBrokerId()!=null) return true;
			if (getIntragroup()!=null) return true;
			if (getNatureOfTheCounterparty1()!=null) return true;
			if (getNatureOfTheCounterparty2()!=null) return true;
			if (getNonStandardizedTermIndicator()!=null) return true;
			if (getLowerBarrierLevel()!=null) return true;
			if (getUpperBarrierLevel()!=null) return true;
			if (getSingleBarrierLevel()!=null) return true;
			if (getProductDescription()!=null) return true;
			if (getBeneficiary()!=null) return true;
			if (getRemarks()!=null) return true;
			if (getSwapLinkID()!=null) return true;
			if (getSecondaryTransactionIdentifier()!=null) return true;
			if (getUniqueProductIdentifierProprietary()!=null) return true;
			if (getSectorOfTheCounterparty1()!=null) return true;
			if (getSectorOfTheCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierFormat()!=null) return true;
			if (getReferenceEntityFormat()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HKMATransactionReport.HKMATransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			HKMATransactionReport.HKMATransactionReportBuilder o = (HKMATransactionReport.HKMATransactionReportBuilder) other;
			
			merger.mergeRosetta(getNotionalQuantityScheduleLeg1(), o.getNotionalQuantityScheduleLeg1(), this::getOrCreateNotionalQuantityScheduleLeg1);
			merger.mergeRosetta(getNotionalQuantityScheduleLeg2(), o.getNotionalQuantityScheduleLeg2(), this::getOrCreateNotionalQuantityScheduleLeg2);
			
			merger.mergeBasic(getSettlementLocation(), o.getSettlementLocation(), this::setSettlementLocation);
			merger.mergeBasic(getBaseProduct(), o.getBaseProduct(), this::setBaseProduct);
			merger.mergeBasic(getSubProduct(), o.getSubProduct(), this::setSubProduct);
			merger.mergeBasic(getFurtherSubProduct(), o.getFurtherSubProduct(), this::setFurtherSubProduct);
			merger.mergeBasic(getReferenceEntity(), o.getReferenceEntity(), this::setReferenceEntity);
			merger.mergeBasic(getSeriesVersion(), o.getSeriesVersion(), this::setSeriesVersion);
			merger.mergeBasic(getCustomBasketCode(), o.getCustomBasketCode(), this::setCustomBasketCode);
			merger.mergeBasic(getBasketConstituentNumberOfUnits(), o.getBasketConstituentNumberOfUnits(), (Consumer<BigDecimal>) this::addBasketConstituentNumberOfUnits);
			merger.mergeBasic(getBasketConstituentUnitOfMeasure(), o.getBasketConstituentUnitOfMeasure(), (Consumer<String>) this::addBasketConstituentUnitOfMeasure);
			merger.mergeBasic(getUnderlyingIdOther(), o.getUnderlyingIdOther(), this::setUnderlyingIdOther);
			merger.mergeBasic(getUnderlyingIdOtherSource(), o.getUnderlyingIdOtherSource(), this::setUnderlyingIdOtherSource);
			merger.mergeBasic(getUnderlyingAssetTradingPlatformIdentifier(), o.getUnderlyingAssetTradingPlatformIdentifier(), this::setUnderlyingAssetTradingPlatformIdentifier);
			merger.mergeBasic(getUnderlyingAssetPriceSource(), o.getUnderlyingAssetPriceSource(), this::setUnderlyingAssetPriceSource);
			merger.mergeBasic(getUnderlyingIdentification(), o.getUnderlyingIdentification(), this::setUnderlyingIdentification);
			merger.mergeBasic(getUnderlyingIdentificationType(), o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType);
			merger.mergeBasic(getCryptoAssetUnderlyingIndicator(), o.getCryptoAssetUnderlyingIndicator(), this::setCryptoAssetUnderlyingIndicator);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getBrokerId(), o.getBrokerId(), this::setBrokerId);
			merger.mergeBasic(getIntragroup(), o.getIntragroup(), this::setIntragroup);
			merger.mergeBasic(getNatureOfTheCounterparty1(), o.getNatureOfTheCounterparty1(), this::setNatureOfTheCounterparty1);
			merger.mergeBasic(getNatureOfTheCounterparty2(), o.getNatureOfTheCounterparty2(), this::setNatureOfTheCounterparty2);
			merger.mergeBasic(getNonStandardizedTermIndicator(), o.getNonStandardizedTermIndicator(), this::setNonStandardizedTermIndicator);
			merger.mergeBasic(getLowerBarrierLevel(), o.getLowerBarrierLevel(), this::setLowerBarrierLevel);
			merger.mergeBasic(getUpperBarrierLevel(), o.getUpperBarrierLevel(), this::setUpperBarrierLevel);
			merger.mergeBasic(getSingleBarrierLevel(), o.getSingleBarrierLevel(), this::setSingleBarrierLevel);
			merger.mergeBasic(getProductDescription(), o.getProductDescription(), this::setProductDescription);
			merger.mergeBasic(getBeneficiary(), o.getBeneficiary(), this::setBeneficiary);
			merger.mergeBasic(getRemarks(), o.getRemarks(), this::setRemarks);
			merger.mergeBasic(getSwapLinkID(), o.getSwapLinkID(), this::setSwapLinkID);
			merger.mergeBasic(getSecondaryTransactionIdentifier(), o.getSecondaryTransactionIdentifier(), this::setSecondaryTransactionIdentifier);
			merger.mergeBasic(getUniqueProductIdentifierProprietary(), o.getUniqueProductIdentifierProprietary(), this::setUniqueProductIdentifierProprietary);
			merger.mergeBasic(getSectorOfTheCounterparty1(), o.getSectorOfTheCounterparty1(), this::setSectorOfTheCounterparty1);
			merger.mergeBasic(getSectorOfTheCounterparty2(), o.getSectorOfTheCounterparty2(), this::setSectorOfTheCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierFormat(), o.getCounterparty2IdentifierFormat(), this::setCounterparty2IdentifierFormat);
			merger.mergeBasic(getReferenceEntityFormat(), o.getReferenceEntityFormat(), this::setReferenceEntityFormat);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			HKMATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(settlementLocation, _that.getSettlementLocation())) return false;
			if (!Objects.equals(baseProduct, _that.getBaseProduct())) return false;
			if (!Objects.equals(subProduct, _that.getSubProduct())) return false;
			if (!Objects.equals(furtherSubProduct, _that.getFurtherSubProduct())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(seriesVersion, _that.getSeriesVersion())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg1, _that.getNotionalQuantityScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg2, _that.getNotionalQuantityScheduleLeg2())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!ListEquals.listEquals(basketConstituentNumberOfUnits, _that.getBasketConstituentNumberOfUnits())) return false;
			if (!ListEquals.listEquals(basketConstituentUnitOfMeasure, _that.getBasketConstituentUnitOfMeasure())) return false;
			if (!Objects.equals(underlyingIdOther, _that.getUnderlyingIdOther())) return false;
			if (!Objects.equals(underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) return false;
			if (!Objects.equals(underlyingAssetTradingPlatformIdentifier, _that.getUnderlyingAssetTradingPlatformIdentifier())) return false;
			if (!Objects.equals(underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(brokerId, _that.getBrokerId())) return false;
			if (!Objects.equals(intragroup, _that.getIntragroup())) return false;
			if (!Objects.equals(natureOfTheCounterparty1, _that.getNatureOfTheCounterparty1())) return false;
			if (!Objects.equals(natureOfTheCounterparty2, _that.getNatureOfTheCounterparty2())) return false;
			if (!Objects.equals(nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) return false;
			if (!Objects.equals(lowerBarrierLevel, _that.getLowerBarrierLevel())) return false;
			if (!Objects.equals(upperBarrierLevel, _that.getUpperBarrierLevel())) return false;
			if (!Objects.equals(singleBarrierLevel, _that.getSingleBarrierLevel())) return false;
			if (!Objects.equals(productDescription, _that.getProductDescription())) return false;
			if (!Objects.equals(beneficiary, _that.getBeneficiary())) return false;
			if (!Objects.equals(remarks, _that.getRemarks())) return false;
			if (!Objects.equals(swapLinkID, _that.getSwapLinkID())) return false;
			if (!Objects.equals(secondaryTransactionIdentifier, _that.getSecondaryTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueProductIdentifierProprietary, _that.getUniqueProductIdentifierProprietary())) return false;
			if (!Objects.equals(sectorOfTheCounterparty1, _that.getSectorOfTheCounterparty1())) return false;
			if (!Objects.equals(sectorOfTheCounterparty2, _that.getSectorOfTheCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierFormat, _that.getCounterparty2IdentifierFormat())) return false;
			if (!Objects.equals(referenceEntityFormat, _that.getReferenceEntityFormat())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (settlementLocation != null ? settlementLocation.hashCode() : 0);
			_result = 31 * _result + (baseProduct != null ? baseProduct.hashCode() : 0);
			_result = 31 * _result + (subProduct != null ? subProduct.hashCode() : 0);
			_result = 31 * _result + (furtherSubProduct != null ? furtherSubProduct.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (seriesVersion != null ? seriesVersion.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg1 != null ? notionalQuantityScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg2 != null ? notionalQuantityScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (basketConstituentNumberOfUnits != null ? basketConstituentNumberOfUnits.hashCode() : 0);
			_result = 31 * _result + (basketConstituentUnitOfMeasure != null ? basketConstituentUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOther != null ? underlyingIdOther.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOtherSource != null ? underlyingIdOtherSource.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlyingAssetTradingPlatformIdentifier != null ? underlyingAssetTradingPlatformIdentifier.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetPriceSource != null ? underlyingAssetPriceSource.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (cryptoAssetUnderlyingIndicator != null ? cryptoAssetUnderlyingIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (brokerId != null ? brokerId.hashCode() : 0);
			_result = 31 * _result + (intragroup != null ? intragroup.hashCode() : 0);
			_result = 31 * _result + (natureOfTheCounterparty1 != null ? natureOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (natureOfTheCounterparty2 != null ? natureOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (nonStandardizedTermIndicator != null ? nonStandardizedTermIndicator.hashCode() : 0);
			_result = 31 * _result + (lowerBarrierLevel != null ? lowerBarrierLevel.hashCode() : 0);
			_result = 31 * _result + (upperBarrierLevel != null ? upperBarrierLevel.hashCode() : 0);
			_result = 31 * _result + (singleBarrierLevel != null ? singleBarrierLevel.hashCode() : 0);
			_result = 31 * _result + (productDescription != null ? productDescription.hashCode() : 0);
			_result = 31 * _result + (beneficiary != null ? beneficiary.hashCode() : 0);
			_result = 31 * _result + (remarks != null ? remarks.hashCode() : 0);
			_result = 31 * _result + (swapLinkID != null ? swapLinkID.hashCode() : 0);
			_result = 31 * _result + (secondaryTransactionIdentifier != null ? secondaryTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifierProprietary != null ? uniqueProductIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (sectorOfTheCounterparty1 != null ? sectorOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (sectorOfTheCounterparty2 != null ? sectorOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierFormat != null ? counterparty2IdentifierFormat.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (referenceEntityFormat != null ? referenceEntityFormat.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HKMATransactionReportBuilder {" +
				"settlementLocation=" + this.settlementLocation + ", " +
				"baseProduct=" + this.baseProduct + ", " +
				"subProduct=" + this.subProduct + ", " +
				"furtherSubProduct=" + this.furtherSubProduct + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"seriesVersion=" + this.seriesVersion + ", " +
				"notionalQuantityScheduleLeg1=" + this.notionalQuantityScheduleLeg1 + ", " +
				"notionalQuantityScheduleLeg2=" + this.notionalQuantityScheduleLeg2 + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"basketConstituentNumberOfUnits=" + this.basketConstituentNumberOfUnits + ", " +
				"basketConstituentUnitOfMeasure=" + this.basketConstituentUnitOfMeasure + ", " +
				"underlyingIdOther=" + this.underlyingIdOther + ", " +
				"underlyingIdOtherSource=" + this.underlyingIdOtherSource + ", " +
				"underlyingAssetTradingPlatformIdentifier=" + this.underlyingAssetTradingPlatformIdentifier + ", " +
				"underlyingAssetPriceSource=" + this.underlyingAssetPriceSource + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"brokerId=" + this.brokerId + ", " +
				"intragroup=" + this.intragroup + ", " +
				"natureOfTheCounterparty1=" + this.natureOfTheCounterparty1 + ", " +
				"natureOfTheCounterparty2=" + this.natureOfTheCounterparty2 + ", " +
				"nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", " +
				"lowerBarrierLevel=" + this.lowerBarrierLevel + ", " +
				"upperBarrierLevel=" + this.upperBarrierLevel + ", " +
				"singleBarrierLevel=" + this.singleBarrierLevel + ", " +
				"productDescription=" + this.productDescription + ", " +
				"beneficiary=" + this.beneficiary + ", " +
				"remarks=" + this.remarks + ", " +
				"swapLinkID=" + this.swapLinkID + ", " +
				"secondaryTransactionIdentifier=" + this.secondaryTransactionIdentifier + ", " +
				"uniqueProductIdentifierProprietary=" + this.uniqueProductIdentifierProprietary + ", " +
				"sectorOfTheCounterparty1=" + this.sectorOfTheCounterparty1 + ", " +
				"sectorOfTheCounterparty2=" + this.sectorOfTheCounterparty2 + ", " +
				"counterparty2IdentifierFormat=" + this.counterparty2IdentifierFormat + ", " +
				"referenceEntityFormat=" + this.referenceEntityFormat +
			'}' + " " + super.toString();
		}
	}
}
