package drr.regulation.hkma.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.SupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.List;


@ImplementedBy(SupervisoryBodyForHKMA.SupervisoryBodyForHKMADefault.class)
public abstract class SupervisoryBodyForHKMA implements RosettaFunction {

	/**
	* @return supervisoryBodyHKMA 
	*/
	public List<SupervisoryBodyEnum> evaluate() {
		List<SupervisoryBodyEnum> supervisoryBodyHKMA = doEvaluate();
		
		return supervisoryBodyHKMA;
	}

	protected abstract List<SupervisoryBodyEnum> doEvaluate();

	public static class SupervisoryBodyForHKMADefault extends SupervisoryBodyForHKMA {
		@Override
		protected List<SupervisoryBodyEnum> doEvaluate() {
			List<SupervisoryBodyEnum> supervisoryBodyHKMA = new ArrayList<>();
			return assignOutput(supervisoryBodyHKMA);
		}
		
		protected List<SupervisoryBodyEnum> assignOutput(List<SupervisoryBodyEnum> supervisoryBodyHKMA) {
			supervisoryBodyHKMA.addAll(MapperC.<SupervisoryBodyEnum>of(MapperS.of(SupervisoryBodyEnum.HKMA)).getMulti());
			
			return supervisoryBodyHKMA;
		}
	}
}
