package drr.regulation.hkma.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentIdentifierSourceRule.BasketConstituentIdentifierSourceRuleDefault.class)
public abstract class BasketConstituentIdentifierSourceRule implements ReportFunction<ProductIdentifier, ProductIdTypeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.trade.basket.reports.BasketConstituentIdentifierSourceRule basketConstituentIdentifierSourceRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ProductIdTypeEnum evaluate(ProductIdentifier input) {
		ProductIdTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ProductIdTypeEnum doEvaluate(ProductIdentifier input);

	public static class BasketConstituentIdentifierSourceRuleDefault extends BasketConstituentIdentifierSourceRule {
		@Override
		protected ProductIdTypeEnum doEvaluate(ProductIdentifier input) {
			ProductIdTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ProductIdTypeEnum assignOutput(ProductIdTypeEnum output, ProductIdentifier input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(basketConstituentIdentifierSourceRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
