package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.party.reports.Counterparty2IdentifierTypeRule;
import javax.inject.Inject;


@ImplementedBy(Counterparty2IdentifierTypeIndicatorRule.Counterparty2IdentifierTypeIndicatorRuleDefault.class)
public abstract class Counterparty2IdentifierTypeIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class Counterparty2IdentifierTypeIndicatorRuleDefault extends Counterparty2IdentifierTypeIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(counterparty2IdentifierTypeRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
