package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg1Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg1;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg1Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateIdentifierLeg1Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateIndicatorLeg1Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodLeg1Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodMultiplierLeg1Rule;
import drr.regulation.common.trade.underlier.reports.NameOfTheFloatingRateOfLeg1Rule;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.standards.iosco.cde.functions.Leg1;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalQuantityScheduleLeg1Rule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Leg1ReportRule.Leg1ReportRuleDefault.class)
public abstract class Leg1ReportRule implements ReportFunction<TransactionReportInstruction, CommonLeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FixingDateLeg1Rule fixingDateLeg1Rule;
	@Inject protected FloatingRateIdentifierLeg1Rule floatingRateIdentifierLeg1Rule;
	@Inject protected FloatingRateIndicatorLeg1Rule floatingRateIndicatorLeg1Rule;
	@Inject protected FloatingRateReferencePeriodLeg1Rule floatingRateReferencePeriodLeg1Rule;
	@Inject protected FloatingRateReferencePeriodMultiplierLeg1Rule floatingRateReferencePeriodMultiplierLeg1Rule;
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;
	@Inject protected Leg1 leg1;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NameOfTheFloatingRateOfLeg1Rule nameOfTheFloatingRateOfLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected QuantityFrequencyLeg1 quantityFrequencyLeg1;
	@Inject protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonLeg evaluate(TransactionReportInstruction input) {
		CommonLeg.CommonLegBuilder outputBuilder = doEvaluate(input);
		
		final CommonLeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CommonLeg.class, output);
		}
		
		return output;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg1ReportRuleDefault extends Leg1ReportRule {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
			CommonLeg.CommonLegBuilder output = CommonLeg.builder();
			return assignOutput(output, input);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			final MapperS<CommonLeg> ifThenElseResult;
			if (exists(thenArg).getOrDefault(false)) {
				final BigDecimal bigDecimal = floatingRateReferencePeriodMultiplierLeg1Rule.evaluate(thenArg.get());
				ifThenElseResult = MapperS.of(legEnrichment.evaluate(leg1.evaluate(thenArg.get(), null), notionalAmountScheduleLeg1Rule.evaluate(thenArg.get()), notionalQuantityScheduleLeg1Rule.evaluate(thenArg.get()), notionalQuantityLeg1Rule.evaluate(thenArg.get()), null, null, fixingDateLeg1Rule.evaluate(thenArg.get()), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), floatingRateIndicatorLeg1Rule.evaluate(thenArg.get()), floatingRateIdentifierLeg1Rule.evaluate(thenArg.get()), floatingRateReferencePeriodLeg1Rule.evaluate(thenArg.get()), (bigDecimal == null ? null : bigDecimal.intValueExact()), nameOfTheFloatingRateOfLeg1Rule.evaluate(thenArg.get())));
			} else {
				ifThenElseResult = MapperS.<CommonLeg>ofNull();
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
