package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg2Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg2;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg2Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateIdentifierLeg2Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateIndicatorLeg2Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodLeg2Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodMultiplierLeg2Rule;
import drr.regulation.common.trade.underlier.reports.NameOfTheFloatingRateOfLeg2Rule;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.standards.iosco.cde.functions.Leg2;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountScheduleLeg2Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalQuantityScheduleLeg2Rule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Leg2ReportRule.Leg2ReportRuleDefault.class)
public abstract class Leg2ReportRule implements ReportFunction<TransactionReportInstruction, CommonLeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FixingDateLeg2Rule fixingDateLeg2Rule;
	@Inject protected FloatingRateIdentifierLeg2Rule floatingRateIdentifierLeg2Rule;
	@Inject protected FloatingRateIndicatorLeg2Rule floatingRateIndicatorLeg2Rule;
	@Inject protected FloatingRateReferencePeriodLeg2Rule floatingRateReferencePeriodLeg2Rule;
	@Inject protected FloatingRateReferencePeriodMultiplierLeg2Rule floatingRateReferencePeriodMultiplierLeg2Rule;
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;
	@Inject protected Leg2 leg2;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NameOfTheFloatingRateOfLeg2Rule nameOfTheFloatingRateOfLeg2Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
	@Inject protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
	@Inject protected QuantityFrequencyLeg2 quantityFrequencyLeg2;
	@Inject protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonLeg evaluate(TransactionReportInstruction input) {
		CommonLeg.CommonLegBuilder outputBuilder = doEvaluate(input);
		
		final CommonLeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CommonLeg.class, output);
		}
		
		return output;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg2ReportRuleDefault extends Leg2ReportRule {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
			CommonLeg.CommonLegBuilder output = CommonLeg.builder();
			return assignOutput(output, input);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			final MapperS<CommonLeg> ifThenElseResult;
			if (exists(thenArg).getOrDefault(false)) {
				final BigDecimal bigDecimal = floatingRateReferencePeriodMultiplierLeg2Rule.evaluate(thenArg.get());
				ifThenElseResult = MapperS.of(legEnrichment.evaluate(leg2.evaluate(thenArg.get(), null), notionalAmountScheduleLeg2Rule.evaluate(thenArg.get()), notionalQuantityScheduleLeg2Rule.evaluate(thenArg.get()), notionalQuantityLeg2Rule.evaluate(thenArg.get()), null, null, fixingDateLeg2Rule.evaluate(thenArg.get()), MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get(), MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<Integer>map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), floatingRateIndicatorLeg2Rule.evaluate(thenArg.get()), floatingRateIdentifierLeg2Rule.evaluate(thenArg.get()), floatingRateReferencePeriodLeg2Rule.evaluate(thenArg.get()), (bigDecimal == null ? null : bigDecimal.intValueExact()), nameOfTheFloatingRateOfLeg2Rule.evaluate(thenArg.get())));
			} else {
				ifThenElseResult = MapperS.<CommonLeg>ofNull();
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
