package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;


@ImplementedBy(NotionalQuantityScheduleEffectiveDateLeg2Rule.NotionalQuantityScheduleEffectiveDateLeg2RuleDefault.class)
public abstract class NotionalQuantityScheduleEffectiveDateLeg2Rule implements ReportFunction<TransactionReportInstruction, Void> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Void evaluate(TransactionReportInstruction input) {
		Void output = doEvaluate(input);
		
		return output;
	}

	protected abstract Void doEvaluate(TransactionReportInstruction input);

	public static class NotionalQuantityScheduleEffectiveDateLeg2RuleDefault extends NotionalQuantityScheduleEffectiveDateLeg2Rule {
		@Override
		protected Void doEvaluate(TransactionReportInstruction input) {
			Void output = null;
			return assignOutput(output, input);
		}
		
		protected Void assignOutput(Void output, TransactionReportInstruction input) {
			output = null;
			
			return output;
		}
	}
}
