package drr.regulation.hkma.rewrite.trade.reports;

import cdm.base.staticdata.identifier.IdentifiedList;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPackageInformation;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(PackageIdentifierRule.PackageIdentifierRuleDefault.class)
public abstract class PackageIdentifierRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetPackageInformation getPackageInformation;
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected drr.standards.iosco.cde.link.reports.PackageIdentifierRule packageIdentifierRule;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PackageIdentifierRuleDefault extends PackageIdentifierRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			final Boolean _boolean = isFXSwap.evaluate(productForEvent.evaluate(thenArg0.get()));
			final MapperS<IdentifiedList> ifThenElseResult;
			if ((_boolean == null ? false : _boolean)) {
				ifThenElseResult = MapperS.<IdentifiedList>ofNull();
			} else {
				ifThenElseResult = thenArg0
					.mapSingleToItem(item -> MapperS.of(getPackageInformation.evaluate(item.get())));
			}
			final MapperC<FieldWithMetaString> thenArg1 = ifThenElseResult
				.mapSingleToList(item -> MapperC.<FieldWithMetaString>of(packageIdentifierRule.evaluate(item.get()).stream()
					.<FieldWithMetaString>map(string -> FieldWithMetaString.builder().setValue(string).build())
					.collect(Collectors.toList())
				));
			final FieldWithMetaString fieldWithMetaString = MapperS.of(thenArg1.get()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
