package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.esma.emir.refit.trade.reports.NatureOfCounterparty1Rule;
import javax.inject.Inject;


@ImplementedBy(SectorOfTheCounterparty1Rule.SectorOfTheCounterparty1RuleDefault.class)
public abstract class SectorOfTheCounterparty1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected NatureOfCounterparty1Rule natureOfCounterparty1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class SectorOfTheCounterparty1RuleDefault extends SectorOfTheCounterparty1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(natureOfCounterparty1Rule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
