package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.esma.emir.refit.trade.reports.NatureOfTheCounterparty2Rule;
import javax.inject.Inject;


@ImplementedBy(SectorOfTheCounterparty2Rule.SectorOfTheCounterparty2RuleDefault.class)
public abstract class SectorOfTheCounterparty2Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected NatureOfTheCounterparty2Rule natureOfTheCounterparty2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class SectorOfTheCounterparty2RuleDefault extends SectorOfTheCounterparty2Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(natureOfTheCounterparty2Rule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
