package drr.regulation.hkma.rewrite.trade.reports;

import cdm.observable.event.Trigger;
import cdm.observable.event.TriggerEvent;
import cdm.product.template.Barrier;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SingleBarrierLevelRule.SingleBarrierLevelRuleDefault.class)
public abstract class SingleBarrierLevelRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;
	@Inject protected IsOption isOption;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SingleBarrierLevelRuleDefault extends SingleBarrierLevelRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> isOption.evaluate(item.get()));
			final MapperS<Barrier> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Barrier>map("getBarrier", optionFeature -> optionFeature.getBarrier()));
			final MapperS<BigDecimal> ifThenElseResult;
			if (notExists(thenArg3.<TriggerEvent>map("getBarrierFloor", barrier -> barrier.getBarrierFloor())).or(notExists(thenArg3.<TriggerEvent>map("getBarrierCap", barrier -> barrier.getBarrierCap()))).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(MapperC.<BigDecimal>of(thenArg3.<TriggerEvent>map("getBarrierFloor", barrier -> barrier.getBarrierFloor()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()), thenArg3.<TriggerEvent>map("getBarrierCap", barrier -> barrier.getBarrierCap()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel())).get());
			} else {
				ifThenElseResult = MapperS.<BigDecimal>ofNull();
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
