package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;


@ImplementedBy(TechnicalRecordIdentificationRule.TechnicalRecordIdentificationRuleDefault.class)
public abstract class TechnicalRecordIdentificationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class TechnicalRecordIdentificationRuleDefault extends TechnicalRecordIdentificationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperC<String> thenArg = MapperC.<String>of(MapperS.of("HKMA"), MapperS.of(counterparty1Rule.evaluate(input)), MapperS.of(counterparty2Rule.evaluate(input)), MapperS.of(uniqueTransactionIdentifierRule.evaluate(input)), MapperS.of(eventTimestampRule.evaluate(input)).map("to-string", Object::toString));
			output = thenArg.join(MapperS.of("-")).get();
			
			return output;
		}
	}
}
