package drr.regulation.hkma.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.standards.iosco.cde.underlier.reports.UnderlierIDOtherSourceRule;
import javax.inject.Inject;


@ImplementedBy(UnderlierIdOtherSourceRule.UnderlierIdOtherSourceRuleDefault.class)
public abstract class UnderlierIdOtherSourceRule implements ReportFunction<TransactionReportInstruction, ProductIdTypeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;
	@Inject protected UnderlierIDOtherSourceRule underlierIDOtherSourceRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ProductIdTypeEnum evaluate(TransactionReportInstruction input) {
		ProductIdTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ProductIdTypeEnum doEvaluate(TransactionReportInstruction input);

	public static class UnderlierIdOtherSourceRuleDefault extends UnderlierIdOtherSourceRule {
		@Override
		protected ProductIdTypeEnum doEvaluate(TransactionReportInstruction input) {
			ProductIdTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ProductIdTypeEnum assignOutput(ProductIdTypeEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(underlierIDOtherSourceRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
